/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.pipenet.longdist.ILDEndpoint;
import gregtech.api.pipenet.longdist.LongDistanceNetwork;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class LDPipeProvider
implements IProbeInfoProvider {
    public String getID() {
        return "gregtech:ld_pipe_provider";
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, EntityPlayer entityPlayer, @NotNull World world, IBlockState blockState, @NotNull IProbeHitData probeHitData) {
        IGregTechTileEntity iGregTechTileEntity;
        MetaTileEntity metaTileEntity;
        BlockPos pos = probeHitData.getPos();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IGregTechTileEntity && (metaTileEntity = (iGregTechTileEntity = (IGregTechTileEntity)tileEntity).getMetaTileEntity()) instanceof ILDEndpoint) {
            ILDEndpoint endpoint = (ILDEndpoint)((Object)metaTileEntity);
            LongDistanceNetwork network = LongDistanceNetwork.get(world, pos);
            if (network == null) {
                probeInfo.text(TextStyleClass.ERROR + "{*gregtech.top.ld_pipe_no_network*}");
            } else {
                ILDEndpoint other = endpoint.getLink();
                if (other != null) {
                    probeInfo.text(TextStyleClass.OK + "{*gregtech.top.ld_pipe_connected*}");
                    probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.ld_pipe_length*} " + TextStyleClass.INFOIMP + network.getTotalSize());
                    LDPipeProvider.addIOText(probeInfo, endpoint);
                    if (entityPlayer.func_70093_af()) {
                        BlockPos otherPos = other.pos();
                        String prefix = null;
                        if (other.isInput()) {
                            prefix = "{*gregtech.top.ld_pipe_input_endpoint*}";
                        } else if (other.isOutput()) {
                            prefix = "{*gregtech.top.ld_pipe_output_endpoint*}";
                        }
                        if (prefix != null) {
                            probeInfo.text(TextStyleClass.INFO + prefix + TextStyleClass.INFO + " x: " + TextStyleClass.OK + otherPos.func_177958_n() + TextStyleClass.INFO + " y: " + TextStyleClass.OK + otherPos.func_177956_o() + TextStyleClass.INFO + " z: " + TextStyleClass.OK + otherPos.func_177952_p());
                        }
                    }
                } else {
                    probeInfo.text(TextStyleClass.WARNING + "{*gregtech.top.ld_pipe_incomplete*}");
                    LDPipeProvider.addIOText(probeInfo, endpoint);
                }
            }
        }
    }

    private static void addIOText(@NotNull IProbeInfo probeInfo, @NotNull ILDEndpoint endpoint) {
        if (endpoint.isInput()) {
            probeInfo.text(TextStyleClass.INFOIMP + "{*gregtech.top.ld_pipe_input*}");
        } else if (endpoint.isOutput()) {
            probeInfo.text(TextStyleClass.INFOIMP + "{*gregtech.top.ld_pipe_output*}");
        }
    }
}

