/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.opencomputers.values;

import gregtech.api.cover.Cover;
import gregtech.common.covers.CoverPump;
import gregtech.integration.opencomputers.InputValidator;
import gregtech.integration.opencomputers.values.ValueCoverBehavior;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.util.EnumFacing;

public class ValueCoverPump
extends ValueCoverBehavior {
    protected ValueCoverPump(CoverPump coverBehavior, EnumFacing side, String name) {
        super(coverBehavior, side, name);
    }

    public ValueCoverPump(CoverPump coverBehavior, EnumFacing side) {
        this(coverBehavior, side, "gt_coverPump");
    }

    @Override
    protected CoverPump getCover() {
        Cover cover = super.getCover();
        return cover instanceof CoverPump ? (CoverPump)cover : null;
    }

    @Callback(doc="function():number --  Returns tier.")
    public Object[] getTier(Context context, Arguments args) {
        CoverPump cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        return new Object[]{cover.tier};
    }

    @Callback(doc="function():number --  Returns transfer rate.")
    public Object[] getTransferRate(Context context, Arguments args) {
        CoverPump cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        return new Object[]{cover.getTransferRate()};
    }

    @Callback(doc="function(number) --  Sets transfer rate.")
    public Object[] setTransferRate(Context context, Arguments args) {
        CoverPump cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        int transferRate = InputValidator.getInteger(args, 0, 0, cover.maxFluidTransferRate);
        cover.setTransferRate(transferRate);
        return new Object[0];
    }

    @Callback(doc="function(mode:number) --  Sets pump mode. (0:IMPORT, 1:EXPORT)")
    public Object[] setPumpMode(Context context, Arguments args) {
        CoverPump cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        CoverPump.PumpMode mode = (CoverPump.PumpMode)InputValidator.getEnumArrayIndex((Arguments)args, (int)0, (Enum[])CoverPump.PumpMode.values());
        cover.setPumpMode(mode);
        return new Object[0];
    }

    @Callback(doc="function():number --  Gets pump mode. (0:IMPORT, 1:EXPORT)")
    public Object[] getPumpMode(Context context, Arguments args) {
        CoverPump cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        return new Object[]{cover.getPumpMode().ordinal()};
    }
}

