/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.opencomputers.drivers.specific;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityPowerSubstation;
import gregtech.integration.opencomputers.drivers.EnvironmentMetaTileEntity;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DriverPowerSubstation
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return MetaTileEntityPowerSubstation.class;
    }

    public boolean worksWith(World world, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IGregTechTileEntity) {
            IGregTechTileEntity gtte = (IGregTechTileEntity)tileEntity;
            return gtte.getMetaTileEntity() instanceof MetaTileEntityPowerSubstation;
        }
        return false;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
        IGregTechTileEntity gtte;
        MetaTileEntity metaTileEntity;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IGregTechTileEntity && (metaTileEntity = (gtte = (IGregTechTileEntity)tileEntity).getMetaTileEntity()) instanceof MetaTileEntityPowerSubstation) {
            MetaTileEntityPowerSubstation pss = (MetaTileEntityPowerSubstation)metaTileEntity;
            return new EnvironmentPowerSubstation(gtte, pss);
        }
        return null;
    }

    public static final class EnvironmentPowerSubstation
    extends EnvironmentMetaTileEntity<MetaTileEntityPowerSubstation> {
        public EnvironmentPowerSubstation(IGregTechTileEntity holder, MetaTileEntityPowerSubstation mte) {
            super(holder, mte, "gt_powerSubstation");
        }

        @Callback(doc="function():string -- Returns the stored energy of the machine.")
        public Object[] getStored(Context context, Arguments args) {
            return new Object[]{((MetaTileEntityPowerSubstation)this.tileEntity).getStored()};
        }

        @Callback(doc="function():string -- Returns the total energy capacity of the machine.")
        public Object[] getCapacity(Context context, Arguments args) {
            return new Object[]{((MetaTileEntityPowerSubstation)this.tileEntity).getCapacity()};
        }

        @Callback(doc="function():number -- Returns the passive drain of the machine, in EU/t.")
        public Object[] getPassiveDrain(Context context, Arguments args) {
            return new Object[]{((MetaTileEntityPowerSubstation)this.tileEntity).getPassiveDrain()};
        }

        @Callback(doc="function():number -- Returns the average EU/t in over the last second.")
        public Object[] getAverageInLastSec(Context context, Arguments args) {
            return new Object[]{((MetaTileEntityPowerSubstation)this.tileEntity).getAverageInLastSec()};
        }

        @Callback(doc="function():number -- Returns the average EU/t out over the last second.")
        public Object[] getAverageOutLastSec(Context context, Arguments args) {
            return new Object[]{((MetaTileEntityPowerSubstation)this.tileEntity).getAverageOutLastSec()};
        }
    }
}

