/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.opencomputers.drivers;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverHolder;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.common.covers.CoverConveyor;
import gregtech.common.covers.CoverEnderFluidLink;
import gregtech.common.covers.CoverFluidFilter;
import gregtech.common.covers.CoverFluidRegulator;
import gregtech.common.covers.CoverItemFilter;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.CoverRoboticArm;
import gregtech.integration.opencomputers.InputValidator;
import gregtech.integration.opencomputers.drivers.EnvironmentMetaTileEntity;
import gregtech.integration.opencomputers.values.ValueCoverBehavior;
import gregtech.integration.opencomputers.values.ValueCoverConveyor;
import gregtech.integration.opencomputers.values.ValueCoverEnderFluidLink;
import gregtech.integration.opencomputers.values.ValueCoverFluidFilter;
import gregtech.integration.opencomputers.values.ValueCoverFluidRegulator;
import gregtech.integration.opencomputers.values.ValueCoverItemFilter;
import gregtech.integration.opencomputers.values.ValueCoverPump;
import gregtech.integration.opencomputers.values.ValueCoverRoboticArm;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DriverCoverHolder
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return CoverHolder.class;
    }

    public boolean worksWith(World world, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IGregTechTileEntity) {
            return tileEntity.hasCapability(GregtechTileCapabilities.CAPABILITY_COVER_HOLDER, side);
        }
        return false;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IGregTechTileEntity) {
            return new EnvironmentICoverable((IGregTechTileEntity)tileEntity, (CoverHolder)tileEntity.getCapability(GregtechTileCapabilities.CAPABILITY_COVER_HOLDER, null));
        }
        return null;
    }

    public static final class EnvironmentICoverable
    extends EnvironmentMetaTileEntity<CoverHolder> {
        public EnvironmentICoverable(IGregTechTileEntity holder, CoverHolder capability) {
            super(holder, capability, "gt_coverable");
        }

        @Callback(doc="function(side:number):table --  Returns cover of side!")
        public Object[] getCover(Context context, Arguments args) {
            int index = InputValidator.getInteger(args, 0, 0, 5);
            EnumFacing side = EnumFacing.field_82609_l[index];
            Cover cover = ((CoverHolder)this.tileEntity).getCoverAtSide(side);
            if (cover instanceof CoverRoboticArm) {
                CoverRoboticArm robotArm = (CoverRoboticArm)cover;
                return new Object[]{new ValueCoverRoboticArm(robotArm, side)};
            }
            if (cover instanceof CoverConveyor) {
                CoverConveyor conveyor = (CoverConveyor)cover;
                return new Object[]{new ValueCoverConveyor(conveyor, side)};
            }
            if (cover instanceof CoverFluidRegulator) {
                CoverFluidRegulator regulator = (CoverFluidRegulator)cover;
                return new Object[]{new ValueCoverFluidRegulator(regulator, side)};
            }
            if (cover instanceof CoverPump) {
                CoverPump pump = (CoverPump)cover;
                return new Object[]{new ValueCoverPump(pump, side)};
            }
            if (cover instanceof CoverFluidFilter) {
                CoverFluidFilter filter = (CoverFluidFilter)cover;
                return new Object[]{new ValueCoverFluidFilter(filter, side)};
            }
            if (cover instanceof CoverItemFilter) {
                CoverItemFilter filter = (CoverItemFilter)cover;
                return new Object[]{new ValueCoverItemFilter(filter, side)};
            }
            if (cover instanceof CoverEnderFluidLink) {
                CoverEnderFluidLink efl = (CoverEnderFluidLink)cover;
                return new Object[]{new ValueCoverEnderFluidLink(efl, side)};
            }
            if (cover != null) {
                return new Object[]{new ValueCoverBehavior(cover, side)};
            }
            return new Object[]{null};
        }
    }
}

