/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.utils;

import gregtech.api.util.GTLog;
import gregtech.api.worldgen.config.OreDepositDefinition;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Loader;
import org.jetbrains.annotations.Nullable;

public class JEIResourceDepositCategoryUtils {
    public static List<String> createSpawnPageBiomeTooltip(Function<Biome, Integer> biomeFunction, int originalWeight) {
        if (biomeFunction == OreDepositDefinition.NO_BIOME_INFLUENCE) {
            return Collections.emptyList();
        }
        Object2IntOpenHashMap modifiedBiomeMap = new Object2IntOpenHashMap();
        for (Biome biome : Biome.field_185377_q) {
            int biomeWeight = biomeFunction.apply(biome);
            if (biomeWeight == 0) continue;
            modifiedBiomeMap.put((Object)biome, originalWeight + biomeWeight);
        }
        if (modifiedBiomeMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add("");
        tooltip.add("");
        tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.biome_weighting_title", (Object[])new Object[0]));
        for (Object2IntMap.Entry entry : modifiedBiomeMap.object2IntEntrySet()) {
            String biomeName = ((Biome)entry.getKey()).func_185359_l();
            int weight = entry.getIntValue();
            if (weight <= 0) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.biome_weighting_no_spawn", (Object[])new Object[]{biomeName}));
                continue;
            }
            tooltip.add(I18n.func_135052_a((String)"gregtech.jei.ore.biome_weighting", (Object[])new Object[]{biomeName, weight}));
        }
        return tooltip;
    }

    public static void drawMultiLineCommaSeparatedDimensionList(Int2ObjectMap<String> namedDimensions, int[] dimensionIDs, FontRenderer fontRenderer, int dimStartXPos, int dimStartYPos, int dimDisplayPosX) {
        for (int i = 0; i < dimensionIDs.length; ++i) {
            String fullDimName;
            int dimDisplayLength;
            StringBuilder stb = new StringBuilder().append(dimensionIDs[i]);
            String dimName = (String)namedDimensions.get(dimensionIDs[i]);
            if (dimName != null) {
                stb.append(" (").append(dimName).append(')');
            }
            if (i < dimensionIDs.length - 1) {
                stb.append(", ");
            }
            if ((dimDisplayLength = fontRenderer.func_78256_a(fullDimName = stb.toString())) > 176 - dimDisplayPosX) {
                dimStartYPos += Minecraft.func_71410_x().field_71466_p.field_78288_b;
                dimDisplayPosX = dimStartXPos;
            }
            fontRenderer.func_78276_b(fullDimName, dimDisplayPosX, dimStartYPos, 0x111111);
            dimDisplayPosX += dimDisplayLength;
        }
    }

    public static int[] getAllRegisteredDimensions(@Nullable Predicate<WorldProvider> filter) {
        IntArrayList dims = new IntArrayList();
        Map dimMap = DimensionManager.getRegisteredDimensions();
        DimensionType arSpaceDimensionType = null;
        if (Loader.isModLoaded((String)"advancedrocketry")) {
            try {
                arSpaceDimensionType = DimensionType.func_193417_a((String)"space");
            }
            catch (IllegalArgumentException e) {
                GTLog.logger.error("Something went wrong with AR JEI integration, No DimensionType found");
            }
        }
        for (Map.Entry e : dimMap.entrySet()) {
            if (e.getKey() == arSpaceDimensionType) continue;
            IntBidirectionalIterator intBidirectionalIterator = ((IntSortedSet)e.getValue()).iterator();
            while (intBidirectionalIterator.hasNext()) {
                int num = (Integer)intBidirectionalIterator.next();
                if (filter != null && !filter.test(DimensionManager.createProviderFor((int)num))) continue;
                dims.add(num);
            }
        }
        return dims.toIntArray();
    }
}

