/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.multiblock;

import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.pipeline.IVertexSource;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Translation;
import gregtech.api.gui.GuiTextures;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.pattern.BlockWorldState;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.util.BlockInfo;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GregFakePlayer;
import gregtech.api.util.ItemStackHashStrategy;
import gregtech.client.renderer.scene.ImmediateWorldSceneRenderer;
import gregtech.client.renderer.scene.WorldSceneRenderer;
import gregtech.client.utils.RenderUtil;
import gregtech.client.utils.TrackedDummyWorld;
import gregtech.common.ConfigHolder;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.vecmath.Vector3f;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.gui.recipes.RecipeLayout;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Mouse;

public class MultiblockInfoRecipeWrapper
implements IRecipeWrapper {
    private static final int MAX_PARTS = 18;
    private static final int PARTS_HEIGHT = 36;
    private static final int SLOT_SIZE = 18;
    private static final int SLOTS_PER_ROW = 9;
    private static final int ICON_SIZE = 20;
    private static final int RIGHT_PADDING = 5;
    private final MultiblockControllerBase controller;
    private final MBPattern[] patterns;
    private final Map<GuiButton, Runnable> buttons = new HashMap<GuiButton, Runnable>();
    private RecipeLayout recipeLayout;
    private final List<ItemStack> allItemStackInputs = new ArrayList<ItemStack>();
    private int layerIndex = -1;
    private int currentRendererPage = 0;
    private int lastMouseX;
    private int lastMouseY;
    private Vector3f center;
    private float rotationYaw;
    private float rotationPitch;
    private float zoom;
    private final GuiButton buttonPreviousPattern;
    private final GuiButton buttonNextPattern;
    private final GuiButton nextLayerButton;
    private IDrawable slot;
    private IDrawable infoIcon;
    private boolean drawInfoIcon;
    private static ItemStack tooltipBlockStack;
    private static long lastRender;
    private List<String> predicateTips;
    private BlockPos selected;
    private final List<TraceabilityPredicate.SimplePredicate> predicates;
    private TraceabilityPredicate father;
    private static MultiblockInfoRecipeWrapper lastWrapper;

    public MultiblockInfoRecipeWrapper(@NotNull MultiblockControllerBase controller) {
        this.controller = controller;
        ObjectOpenCustomHashSet drops = new ObjectOpenCustomHashSet((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
        this.patterns = (MBPattern[])controller.getMatchingShapes().stream().map(arg_0 -> this.lambda$new$0((Set)drops, arg_0)).toArray(MBPattern[]::new);
        this.allItemStackInputs.addAll((Collection<ItemStack>)drops);
        this.nextLayerButton = new GuiButton(0, 151, 70, 20, 20, "");
        this.buttonPreviousPattern = new GuiButton(0, 130, 90, 20, 20, "<");
        this.buttonNextPattern = new GuiButton(0, 151, 90, 20, 20, ">");
        this.buttons.put(this.nextLayerButton, this::toggleNextLayer);
        this.buttons.put(this.buttonPreviousPattern, () -> this.switchRenderPage(-1));
        this.buttons.put(this.buttonNextPattern, () -> this.switchRenderPage(1));
        boolean isPagesDisabled = this.patterns.length == 1;
        this.buttonPreviousPattern.field_146125_m = !isPagesDisabled;
        this.buttonNextPattern.field_146125_m = !isPagesDisabled;
        this.predicates = new ArrayList<TraceabilityPredicate.SimplePredicate>();
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, this.allItemStackInputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.controller.getStackForm());
    }

    public void setRecipeLayout(RecipeLayout layout, IGuiHelper guiHelper) {
        this.recipeLayout = layout;
        this.slot = guiHelper.drawableBuilder(GuiTextures.SLOT.imageLocation, 0, 0, 18, 18).setTextureSize(18, 18).build();
        this.infoIcon = guiHelper.drawableBuilder(GuiTextures.INFO_ICON.imageLocation, 0, 0, 20, 20).setTextureSize(20, 20).build();
        IDrawable border = layout.getRecipeCategory().getBackground();
        this.preparePlaceForParts(border.getHeight());
        if (Mouse.getEventDWheel() == 0 || lastWrapper != this) {
            this.selected = null;
            this.predicates.clear();
            this.father = null;
            lastWrapper = this;
            this.nextLayerButton.field_146128_h = border.getWidth() - 25;
            this.buttonPreviousPattern.field_146128_h = border.getWidth() - 46;
            this.buttonNextPattern.field_146128_h = border.getWidth() - 25;
            this.buttonPreviousPattern.field_146124_l = false;
            this.buttonNextPattern.field_146124_l = this.patterns.length > 1;
            Vector3f size = ((TrackedDummyWorld)this.getCurrentRenderer().world).getSize();
            float max = Math.max(Math.max(Math.max(size.x, size.y), size.z), 1.0f);
            this.zoom = (float)(3.5 * Math.sqrt(max));
            this.rotationYaw = 20.0f;
            this.rotationPitch = 50.0f;
            this.currentRendererPage = 0;
            this.setNextLayer(-1);
        } else {
            this.zoom = (float)MathHelper.func_151237_a((double)((double)this.zoom + (Mouse.getEventDWheel() < 0 ? 0.5 : -0.5)), (double)3.0, (double)999.0);
            this.setNextLayer(this.getLayerIndex());
            if (this.predicates != null && this.predicates.size() > 0) {
                this.setItemStackGroup();
            }
        }
        if (this.getCurrentRenderer() != null) {
            TrackedDummyWorld world = (TrackedDummyWorld)this.getCurrentRenderer().world;
            this.resetCenter(world);
        }
        this.updateParts();
    }

    public WorldSceneRenderer getCurrentRenderer() {
        return this.patterns[this.currentRendererPage].sceneRenderer;
    }

    public int getLayerIndex() {
        return this.layerIndex;
    }

    private void toggleNextLayer() {
        WorldSceneRenderer renderer = this.getCurrentRenderer();
        int height = (int)((TrackedDummyWorld)renderer.world).getSize().getY() - 1;
        if (++this.layerIndex > height) {
            this.layerIndex = -1;
        }
        this.setNextLayer(this.layerIndex);
    }

    private void setNextLayer(int newLayer) {
        this.layerIndex = newLayer;
        this.nextLayerButton.field_146126_j = "L:" + (this.layerIndex == -1 ? "A" : Integer.toString(this.layerIndex + 1));
        WorldSceneRenderer renderer = this.getCurrentRenderer();
        if (renderer != null) {
            TrackedDummyWorld world = (TrackedDummyWorld)renderer.world;
            this.resetCenter(world);
            renderer.renderedBlocksMap.clear();
            int minY = (int)world.getMinPos().getY();
            Collection<Object> renderBlocks = newLayer == -1 ? world.renderedBlocks : (Collection)world.renderedBlocks.stream().filter(pos -> pos.func_177956_o() - minY == newLayer).collect(Collectors.toSet());
            renderer.addRenderedBlocks(renderBlocks, null);
        }
    }

    private void resetCenter(TrackedDummyWorld world) {
        Vector3f size = world.getSize();
        Vector3f minPos = world.getMinPos();
        this.center = new Vector3f(minPos.x + size.x / 2.0f, minPos.y + size.y / 2.0f, minPos.z + size.z / 2.0f);
        this.getCurrentRenderer().setCameraLookAt(this.center, this.zoom, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
    }

    private void switchRenderPage(int amount) {
        int maxIndex = this.patterns.length - 1;
        int newIndex = Math.max(0, Math.min(this.currentRendererPage + amount, maxIndex));
        if (this.currentRendererPage != newIndex) {
            this.currentRendererPage = newIndex;
            this.buttonNextPattern.field_146124_l = newIndex < maxIndex;
            this.buttonPreviousPattern.field_146124_l = newIndex > 0;
            this.setNextLayer(-1);
            this.updateParts();
            this.getCurrentRenderer().setCameraLookAt(this.center, this.zoom, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
            if (this.selected != null) {
                this.selected = null;
                for (int i = 0; i < this.predicates.size(); ++i) {
                    this.recipeLayout.getItemStacks().set(i + 18, (Object)ItemStack.field_190927_a);
                }
                this.predicates.clear();
                this.father = null;
            }
        }
    }

    private void preparePlaceForParts(int recipeHeight) {
        GuiItemStackGroup itemStackGroup = this.recipeLayout.getItemStacks();
        for (int i = 0; i < 18; ++i) {
            itemStackGroup.init(i, true, 18 * i - 162 * (i / 9) + 9 - 2, recipeHeight - 36 + 18 * (i / 9));
        }
    }

    private void updateParts() {
        int i;
        GuiItemStackGroup itemStackGroup = this.recipeLayout.getItemStacks();
        List<ItemStack> parts = this.patterns[this.currentRendererPage].parts;
        int limit = Math.min(parts.size(), 18);
        for (i = 0; i < limit; ++i) {
            itemStackGroup.set(i, parts.get(i));
        }
        for (i = parts.size(); i < 18; ++i) {
            itemStackGroup.set(i, (ItemStack)null);
        }
    }

    public void drawInfo(@NotNull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int i;
        WorldSceneRenderer renderer = this.getCurrentRenderer();
        int sceneHeight = recipeHeight - 36;
        renderer.render(this.recipeLayout.getPosX(), this.recipeLayout.getPosY(), recipeWidth, sceneHeight, mouseX + this.recipeLayout.getPosX(), mouseY + this.recipeLayout.getPosY());
        this.drawMultiblockName(recipeWidth);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int iconX = recipeWidth - 25;
        int iconY = 49;
        this.infoIcon.draw(minecraft, iconX, iconY);
        this.drawInfoIcon = iconX <= mouseX && mouseX <= iconX + 20 && iconY <= mouseY && mouseY <= iconY + 20;
        for (i = 0; i < 18; ++i) {
            this.slot.draw(minecraft, 18 * i - 162 * (i / 9) + 9 - 2, sceneHeight + 18 * (i / 9));
        }
        for (i = 0; i < this.predicates.size(); ++i) {
            this.slot.draw(minecraft, 5 + i / 6 * 18, i % 6 * 18 + 10);
        }
        for (GuiButton button : this.buttons.keySet()) {
            button.func_191745_a(minecraft, mouseX, mouseY, 0.0f);
        }
        tooltipBlockStack = null;
        this.predicateTips = null;
        RayTraceResult rayTraceResult = renderer.getLastTraceResult();
        boolean insideView = mouseX >= 0 && mouseY >= 0 && mouseX < recipeWidth && mouseY < sceneHeight;
        boolean leftClickHeld = Mouse.isButtonDown((int)0);
        boolean rightClickHeld = Mouse.isButtonDown((int)1);
        if (insideView) {
            for (GuiButton button : this.buttons.keySet()) {
                if (!button.func_146115_a()) continue;
                insideView = false;
                break;
            }
        }
        if (insideView) {
            int mouseDeltaY;
            if (leftClickHeld) {
                this.rotationPitch += (float)(mouseX - this.lastMouseX + 360);
                this.rotationPitch %= 360.0f;
                this.rotationYaw = (float)MathHelper.func_151237_a((double)(this.rotationYaw + (float)(mouseY - this.lastMouseY)), (double)-89.9, (double)89.9);
            } else if (rightClickHeld && Math.abs(mouseDeltaY = mouseY - this.lastMouseY) > 1) {
                this.zoom = (float)MathHelper.func_151237_a((double)((double)this.zoom + (mouseDeltaY > 0 ? 0.5 : -0.5)), (double)3.0, (double)999.0);
            }
            renderer.setCameraLookAt(this.center, this.zoom, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
        }
        if (!(leftClickHeld || rightClickHeld || rayTraceResult == null || renderer.world.func_175623_d(rayTraceResult.func_178782_a()))) {
            IBlockState blockState = renderer.world.func_180495_p(rayTraceResult.func_178782_a());
            ItemStack itemStack = blockState.func_177230_c().getPickBlock(blockState, rayTraceResult, renderer.world, rayTraceResult.func_178782_a(), (EntityPlayer)minecraft.field_71439_g);
            TraceabilityPredicate predicates = this.patterns[this.currentRendererPage].predicateMap.get(rayTraceResult.func_178782_a());
            if (predicates != null) {
                BlockWorldState worldState = new BlockWorldState();
                worldState.update(renderer.world, rayTraceResult.func_178782_a(), new PatternMatchContext(), new HashMap<TraceabilityPredicate.SimplePredicate, Integer>(), new HashMap<TraceabilityPredicate.SimplePredicate, Integer>(), predicates);
                for (TraceabilityPredicate.SimplePredicate common : predicates.common) {
                    if (!common.test(worldState)) continue;
                    this.predicateTips = common.getToolTips(predicates);
                    break;
                }
                if (this.predicateTips == null) {
                    for (TraceabilityPredicate.SimplePredicate limit : predicates.limited) {
                        if (!limit.test(worldState)) continue;
                        this.predicateTips = limit.getToolTips(predicates);
                        break;
                    }
                }
            }
            if (!itemStack.func_190926_b()) {
                tooltipBlockStack = itemStack;
            }
        }
        lastRender = System.currentTimeMillis();
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        RenderHelper.func_74518_a();
    }

    private void drawMultiblockName(int recipeWidth) {
        String localizedName = I18n.func_135052_a((String)this.controller.getMetaFullName(), (Object[])new Object[0]);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        List lines = fontRenderer.func_78271_c(localizedName, recipeWidth - 10);
        for (int i = 0; i < lines.size(); ++i) {
            fontRenderer.func_78276_b((String)lines.get(i), (recipeWidth - fontRenderer.func_78256_a((String)lines.get(i))) / 2, fontRenderer.field_78288_b * i, ConfigHolder.client.multiblockPreviewFontColor);
        }
    }

    public boolean handleClick(@NotNull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        for (Map.Entry<GuiButton, Runnable> button : this.buttons.entrySet()) {
            if (!button.getKey().func_146116_c(minecraft, mouseX, mouseY)) continue;
            button.getValue().run();
            this.selected = null;
            return true;
        }
        if (mouseButton == 1) {
            if (this.getCurrentRenderer().getLastTraceResult() == null) {
                if (this.selected != null) {
                    this.selected = null;
                    for (int i = 0; i < this.predicates.size(); ++i) {
                        this.recipeLayout.getItemStacks().set(i + 18, (Object)ItemStack.field_190927_a);
                    }
                    this.predicates.clear();
                    this.father = null;
                    return true;
                }
                return false;
            }
            BlockPos selected = this.getCurrentRenderer().getLastTraceResult().func_178782_a();
            if (!Objects.equals(this.selected, selected)) {
                for (int i = 0; i < this.predicates.size(); ++i) {
                    this.recipeLayout.getItemStacks().set(i + 18, (Object)ItemStack.field_190927_a);
                }
                this.predicates.clear();
                this.father = null;
                this.selected = selected;
                TraceabilityPredicate predicate = this.patterns[this.currentRendererPage].predicateMap.get(this.selected);
                if (predicate != null) {
                    this.predicates.addAll(predicate.common);
                    this.predicates.addAll(predicate.limited);
                    this.predicates.removeIf(p -> p.candidates == null);
                    this.father = predicate;
                    this.setItemStackGroup();
                }
                return true;
            }
        }
        return false;
    }

    private void setItemStackGroup() {
        GuiItemStackGroup itemStackGroup = this.recipeLayout.getItemStacks();
        for (int i = 0; i < this.predicates.size(); ++i) {
            itemStackGroup.init(i + 18, true, 5 + i / 6 * 18, i % 6 * 18 + 10);
            itemStackGroup.set(i + 18, this.predicates.get(i).getCandidates());
        }
        itemStackGroup.addTooltipCallback((slotIndex, input, itemStack, tooltip) -> {
            if (slotIndex >= 18 && slotIndex < 18 + this.predicates.size()) {
                tooltip.addAll(this.predicates.get(slotIndex - 18).getToolTips(this.father));
            }
        });
    }

    @NotNull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (this.drawInfoIcon) {
            return Arrays.asList(I18n.func_135052_a((String)"gregtech.multiblock.preview.zoom", (Object[])new Object[0]), I18n.func_135052_a((String)"gregtech.multiblock.preview.rotate", (Object[])new Object[0]), I18n.func_135052_a((String)"gregtech.multiblock.preview.select", (Object[])new Object[0]));
        }
        if (tooltipBlockStack != null && !tooltipBlockStack.func_190926_b() && !Mouse.isButtonDown((int)0)) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ITooltipFlag.TooltipFlags flag = minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            List tooltip = tooltipBlockStack.func_82840_a((EntityPlayer)minecraft.field_71439_g, (ITooltipFlag)flag);
            EnumRarity rarity = tooltipBlockStack.func_77953_t();
            for (int k = 0; k < tooltip.size(); ++k) {
                if (k == 0) {
                    tooltip.set(k, rarity.field_77937_e + (String)tooltip.get(k));
                    continue;
                }
                tooltip.set(k, TextFormatting.GRAY + (String)tooltip.get(k));
            }
            if (this.predicateTips != null) {
                tooltip.addAll(this.predicateTips);
            }
            return tooltip;
        }
        return Collections.emptyList();
    }

    @NotNull
    private static Collection<PartInfo> gatherStructureBlocks(World world, @NotNull Map<BlockPos, BlockInfo> blocks, Set<ItemStack> parts) {
        Object2ObjectOpenCustomHashMap partsMap = new Object2ObjectOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
        for (Map.Entry<BlockPos, BlockInfo> entry : blocks.entrySet()) {
            BlockPos pos = entry.getKey();
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            ItemStack stack = ItemStack.field_190927_a;
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof IGregTechTileEntity) {
                stack = ((IGregTechTileEntity)tileEntity).getMetaTileEntity().getStackForm();
            }
            if (stack.func_190926_b()) {
                stack = GTUtility.toItem(state);
            }
            if (stack.func_190926_b()) {
                ItemStack is;
                NonNullList list = NonNullList.func_191196_a();
                state.func_177230_c().getDrops(list, (IBlockAccess)world, pos, state, 0);
                if (!list.isEmpty() && !(is = (ItemStack)list.get(0)).func_190926_b()) {
                    stack = is;
                }
            }
            if (stack.func_190926_b()) {
                stack = block.getPickBlock(state, new RayTraceResult(Vec3d.field_186680_a, EnumFacing.UP, pos), world, pos, (EntityPlayer)new GregFakePlayer(world));
            }
            if (stack.func_190926_b()) continue;
            parts.add(stack);
            PartInfo partInfo = (PartInfo)partsMap.get(stack);
            if (partInfo == null) {
                partInfo = new PartInfo(stack, entry.getValue());
                partsMap.put(stack, partInfo);
            }
            ++partInfo.amount;
        }
        return partsMap.values();
    }

    @NotNull
    private MBPattern initializePattern(@NotNull MultiblockShapeInfo shapeInfo, @NotNull Set<ItemStack> parts) {
        HashMap<BlockPos, BlockInfo> blockMap = new HashMap<BlockPos, BlockInfo>();
        MultiblockControllerBase controllerBase = null;
        BlockInfo[][][] blocks = shapeInfo.getBlocks();
        for (int x = 0; x < blocks.length; ++x) {
            BlockInfo[][] aisle = blocks[x];
            for (int y = 0; y < aisle.length; ++y) {
                BlockInfo[] column = aisle[y];
                for (int z = 0; z < column.length; ++z) {
                    if (column[z].getTileEntity() instanceof IGregTechTileEntity && ((IGregTechTileEntity)column[z].getTileEntity()).getMetaTileEntity() instanceof MultiblockControllerBase) {
                        controllerBase = (MultiblockControllerBase)((IGregTechTileEntity)column[z].getTileEntity()).getMetaTileEntity();
                    }
                    blockMap.put(new BlockPos(x, y, z), column[z]);
                }
            }
        }
        TrackedDummyWorld world = new TrackedDummyWorld();
        ImmediateWorldSceneRenderer worldSceneRenderer = new ImmediateWorldSceneRenderer(world);
        worldSceneRenderer.setClearColor(ConfigHolder.client.multiblockPreviewColor);
        world.addBlocks(blockMap);
        Vector3f size = world.getSize();
        Vector3f minPos = world.getMinPos();
        this.center = new Vector3f(minPos.x + size.x / 2.0f, minPos.y + size.y / 2.0f, minPos.z + size.z / 2.0f);
        worldSceneRenderer.addRenderedBlocks(world.renderedBlocks, null);
        worldSceneRenderer.setOnLookingAt(ray -> {});
        worldSceneRenderer.setAfterWorldRender(renderer -> {
            BlockPos look;
            BlockPos blockPos = look = worldSceneRenderer.getLastTraceResult() == null ? null : worldSceneRenderer.getLastTraceResult().func_178782_a();
            if (look != null && look.equals((Object)this.selected)) {
                MultiblockInfoRecipeWrapper.renderBlockOverLay(this.selected, 200, 75, 75);
                return;
            }
            MultiblockInfoRecipeWrapper.renderBlockOverLay(look, 150, 150, 150);
            MultiblockInfoRecipeWrapper.renderBlockOverLay(this.selected, 255, 0, 0);
        });
        world.func_72939_s();
        world.setRenderFilter(pos -> worldSceneRenderer.renderedBlocksMap.keySet().stream().anyMatch(c -> c.contains(pos)));
        HashMap<BlockPos, TraceabilityPredicate> predicateMap = new HashMap<BlockPos, TraceabilityPredicate>();
        if (controllerBase != null) {
            if (controllerBase.structurePattern == null) {
                controllerBase.reinitializeStructurePattern();
            }
            if (controllerBase.structurePattern != null) {
                controllerBase.structurePattern.cache.forEach((pos, blockInfo) -> predicateMap.put(BlockPos.func_177969_a((long)pos), (TraceabilityPredicate)blockInfo.getInfo()));
            }
        }
        List<ItemStack> sortedParts = MultiblockInfoRecipeWrapper.gatherStructureBlocks(worldSceneRenderer.world, blockMap, parts).stream().sorted((one, two) -> {
            if (one.isController) {
                return -1;
            }
            if (two.isController) {
                return 1;
            }
            if (one.isTile && !two.isTile) {
                return -1;
            }
            if (two.isTile && !one.isTile) {
                return 1;
            }
            if (one.blockId != two.blockId) {
                return two.blockId - one.blockId;
            }
            return two.amount - one.amount;
        }).map(PartInfo::getItemStack).collect(Collectors.toList());
        return new MBPattern(worldSceneRenderer, sortedParts, predicateMap);
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderBlockOverLay(BlockPos pos, int r, int g, int b) {
        if (pos == null) {
            return;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179137_b((double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5));
        GlStateManager.func_179139_a((double)1.01, (double)1.01, (double)1.01);
        Tessellator tessellator = Tessellator.func_178181_a();
        GlStateManager.func_179090_x();
        CCRenderState renderState = CCRenderState.instance();
        renderState.startDrawing(7, DefaultVertexFormats.field_181706_f, tessellator.func_178180_c());
        ColourMultiplier multiplier = new ColourMultiplier(0);
        renderState.setPipeline(new IVertexOperation[]{new Translation(-0.5, -0.5, -0.5), multiplier});
        BlockRenderer.BlockFace blockFace = new BlockRenderer.BlockFace();
        renderState.setModel((IVertexSource)blockFace);
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            multiplier.colour = RenderUtil.packColor(r, g, b, 255);
            blockFace.loadCuboidFace(Cuboid6.full, renderSide.func_176745_a());
            renderState.render();
        }
        renderState.draw();
        GlStateManager.func_179139_a((double)0.9900990099009901, (double)0.9900990099009901, (double)0.9900990099009901);
        GlStateManager.func_179137_b((double)(-((double)pos.func_177958_n() + 0.5)), (double)(-((double)pos.func_177956_o() + 0.5)), (double)(-((double)pos.func_177952_p() + 0.5)));
        GlStateManager.func_179098_w();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static ItemStack getHoveredItemStack() {
        if (lastRender > System.currentTimeMillis() - 100L) {
            return tooltipBlockStack;
        }
        return null;
    }

    private /* synthetic */ MBPattern lambda$new$0(Set drops, MultiblockShapeInfo it) {
        return this.initializePattern(it, drops);
    }

    private static class MBPattern {
        final WorldSceneRenderer sceneRenderer;
        final List<ItemStack> parts;
        final Map<BlockPos, TraceabilityPredicate> predicateMap;

        public MBPattern(WorldSceneRenderer sceneRenderer, List<ItemStack> parts, Map<BlockPos, TraceabilityPredicate> predicateMap) {
            this.sceneRenderer = sceneRenderer;
            this.parts = parts;
            this.predicateMap = predicateMap;
        }
    }

    private static class PartInfo {
        final ItemStack itemStack;
        boolean isController = false;
        boolean isTile = false;
        final int blockId;
        int amount = 0;

        PartInfo(ItemStack itemStack, BlockInfo blockInfo) {
            this.itemStack = itemStack;
            this.blockId = Block.func_149682_b((Block)blockInfo.getBlockState().func_177230_c());
            TileEntity tileEntity = blockInfo.getTileEntity();
            if (tileEntity != null) {
                this.isTile = true;
                if (tileEntity instanceof IGregTechTileEntity) {
                    IGregTechTileEntity iGregTechTileEntity = (IGregTechTileEntity)tileEntity;
                    MetaTileEntity mte = iGregTechTileEntity.getMetaTileEntity();
                    this.isController = mte instanceof MultiblockControllerBase;
                }
            }
        }

        @NotNull
        ItemStack getItemStack() {
            ItemStack result = this.itemStack.func_77946_l();
            result.func_190920_e(this.amount);
            return result;
        }
    }
}

