/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.hwyla.provider;

import gregtech.api.GTValues;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.metatileentities.electric.MetaTileEntityTransformer;
import gregtech.integration.hwyla.provider.ElectricContainerDataProvider;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.NotNull;

public class TransformerDataProvider
extends ElectricContainerDataProvider {
    public static final TransformerDataProvider INSTANCE = new TransformerDataProvider();

    @Override
    public void register(@NotNull IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.addConfig("gregtech", "gregtech.transformer");
    }

    @Override
    protected NBTTagCompound getNBTData(IEnergyContainer capability, NBTTagCompound tag) {
        NBTTagCompound subTag = new NBTTagCompound();
        subTag.func_74772_a("InputVoltage", capability.getInputVoltage());
        subTag.func_74772_a("OutputVoltage", capability.getOutputVoltage());
        subTag.func_74772_a("InputAmperage", capability.getInputAmperage());
        subTag.func_74772_a("OutputAmperage", capability.getOutputAmperage());
        boolean isTransformUp = capability.getInputVoltage() < capability.getOutputVoltage();
        subTag.func_74757_a("IsTransformUp", isTransformUp);
        EnumFacing frontFace = EnumFacing.UP;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (isTransformUp) {
                if (!capability.outputsEnergy(facing)) continue;
                frontFace = facing;
                break;
            }
            if (!capability.inputsEnergy(facing)) continue;
            frontFace = facing;
            break;
        }
        subTag.func_74768_a("FrontFacing", frontFace.func_176745_a());
        tag.func_74782_a("gregtech.MetaTileEntityTransformer", (NBTBase)subTag);
        return tag;
    }

    @Override
    @NotNull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        IGregTechTileEntity gtte;
        TileEntity tileEntity;
        if (!(config.getConfig("gregtech.transformer") && (tileEntity = accessor.getTileEntity()) instanceof IGregTechTileEntity && (gtte = (IGregTechTileEntity)tileEntity).getMetaTileEntity() instanceof MetaTileEntityTransformer)) {
            return tooltip;
        }
        if (accessor.getNBTData().func_74764_b("gregtech.MetaTileEntityTransformer")) {
            NBTTagCompound tag = accessor.getNBTData().func_74775_l("gregtech.MetaTileEntityTransformer");
            long inputVoltage = tag.func_74763_f("InputVoltage");
            long outputVoltage = tag.func_74763_f("OutputVoltage");
            long inputAmperage = tag.func_74763_f("InputAmperage");
            long outputAmperage = tag.func_74763_f("OutputAmperage");
            boolean isTransformUp = tag.func_74767_n("IsTransformUp");
            EnumFacing frontFacing = EnumFacing.func_82600_a((int)tag.func_74762_e("FrontFacing"));
            StringBuilder input = new StringBuilder().append(" ").append(GTValues.VNF[GTUtility.getTierByVoltage(inputVoltage)]).append(TextFormatting.RESET).append(" (").append(TextFormattingUtil.formatNumbers(inputAmperage)).append("A)");
            StringBuilder output = new StringBuilder().append(" ").append(GTValues.VNF[GTUtility.getTierByVoltage(outputVoltage)]).append(TextFormatting.RESET).append(" (").append(TextFormattingUtil.formatNumbers(outputAmperage)).append("A)");
            tooltip.add((isTransformUp ? I18n.func_135052_a((String)"gregtech.top.transform_up", (Object[])new Object[0]) : I18n.func_135052_a((String)"gregtech.top.transform_down", (Object[])new Object[0])) + input + " -> " + output);
            EnumFacing hitFace = accessor.getSide();
            if (isTransformUp && hitFace != frontFacing || !isTransformUp && hitFace == frontFacing) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.transform_input", (Object[])new Object[0]) + input);
            } else {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.transform_output", (Object[])new Object[0]) + output);
            }
        }
        return tooltip;
    }
}

