/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.hwyla.provider;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IMultiblockController;
import gregtech.integration.hwyla.provider.CapabilityDataProvider;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class MultiblockDataProvider
extends CapabilityDataProvider<IMultiblockController> {
    public static final MultiblockDataProvider INSTANCE = new MultiblockDataProvider();

    @Override
    public void register(@NotNull IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.addConfig("gregtech", "gregtech.multiblock");
    }

    @Override
    @NotNull
    protected Capability<IMultiblockController> getCapability() {
        return GregtechCapabilities.CAPABILITY_MULTIBLOCK_CONTROLLER;
    }

    @Override
    protected NBTTagCompound getNBTData(IMultiblockController capability, NBTTagCompound tag) {
        NBTTagCompound subTag = new NBTTagCompound();
        subTag.func_74757_a("Formed", capability.isStructureFormed());
        subTag.func_74757_a("Obstructed", capability.isStructureObstructed());
        tag.func_74782_a("gregtech.IMultiblockController", (NBTBase)subTag);
        return tag;
    }

    @NotNull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("gregtech.multiblock") || accessor.getTileEntity() == null) {
            return tooltip;
        }
        if (accessor.getNBTData().func_74764_b("gregtech.IMultiblockController")) {
            NBTTagCompound tag = accessor.getNBTData().func_74775_l("gregtech.IMultiblockController");
            boolean formed = tag.func_74767_n("Formed");
            boolean obstructed = tag.func_74767_n("Obstructed");
            if (formed) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.valid_structure", (Object[])new Object[0]));
                if (obstructed) {
                    tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"gregtech.top.obstructed_structure", (Object[])new Object[0]));
                }
            } else {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.invalid_structure", (Object[])new Object[0]));
            }
        }
        return tooltip;
    }
}

