/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.hwyla.provider;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IMultipleRecipeMaps;
import gregtech.api.recipes.RecipeMap;
import gregtech.integration.hwyla.provider.CapabilityDataProvider;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class MultiRecipeMapDataProvider
extends CapabilityDataProvider<IMultipleRecipeMaps> {
    public static final MultiRecipeMapDataProvider INSTANCE = new MultiRecipeMapDataProvider();

    @Override
    public void register(@NotNull IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.addConfig("gregtech", "gregtech.multi_recipemap");
    }

    @Override
    @NotNull
    protected Capability<IMultipleRecipeMaps> getCapability() {
        return GregtechTileCapabilities.CAPABILITY_MULTIPLE_RECIPEMAPS;
    }

    @Override
    protected NBTTagCompound getNBTData(IMultipleRecipeMaps capability, NBTTagCompound tag) {
        return tag;
    }

    @NotNull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("gregtech.multi_recipemap") || accessor.getTileEntity() == null) {
            return tooltip;
        }
        IMultipleRecipeMaps cap = (IMultipleRecipeMaps)accessor.getTileEntity().getCapability(this.getCapability(), null);
        if (cap != null) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.multiple_recipemaps.header", (Object[])new Object[0]));
            for (RecipeMap<?> recipeMap : cap.getAvailableRecipeMaps()) {
                if (recipeMap.equals(cap.getCurrentRecipeMap())) {
                    tooltip.add(" > " + I18n.func_135052_a((String)recipeMap.getTranslationKey(), (Object[])new Object[0]));
                    continue;
                }
                tooltip.add("   " + I18n.func_135052_a((String)recipeMap.getTranslationKey(), (Object[])new Object[0]));
            }
        }
        return tooltip;
    }
}

