/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.hwyla.provider;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.integration.hwyla.provider.CapabilityDataProvider;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class ElectricContainerDataProvider
extends CapabilityDataProvider<IEnergyContainer> {
    public static final ElectricContainerDataProvider INSTANCE = new ElectricContainerDataProvider();

    @Override
    public void register(@NotNull IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.addConfig("gregtech", "gregtech.energy");
    }

    @Override
    @NotNull
    protected Capability<IEnergyContainer> getCapability() {
        return GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER;
    }

    @Override
    protected boolean allowDisplaying(@NotNull IEnergyContainer capability) {
        return !capability.isOneProbeHidden();
    }

    @Override
    protected NBTTagCompound getNBTData(IEnergyContainer capability, NBTTagCompound tag) {
        NBTTagCompound subTag = new NBTTagCompound();
        subTag.func_74772_a("Capacity", capability.getEnergyCapacity());
        subTag.func_74772_a("Stored", capability.getEnergyStored());
        tag.func_74782_a("gregtech.IEnergyContainer", (NBTBase)subTag);
        return tag;
    }

    @NotNull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("gregtech.energy") || accessor.getTileEntity() == null) {
            return tooltip;
        }
        if (accessor.getNBTData().func_74764_b("gregtech.IEnergyContainer")) {
            NBTTagCompound energyTag = accessor.getNBTData().func_74775_l("gregtech.IEnergyContainer");
            long stored = energyTag.func_74763_f("Stored");
            long capacity = energyTag.func_74763_f("Capacity");
            tooltip.add(I18n.func_135052_a((String)"gregtech.waila.energy_stored", (Object[])new Object[]{stored, capacity}));
        }
        return tooltip;
    }
}

