/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.hwyla.provider;

import gregtech.api.GTValues;
import gregtech.api.capability.FeCompat;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.metatileentities.converter.ConverterTrait;
import gregtech.integration.hwyla.provider.CapabilityDataProvider;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class ConverterDataProvider
extends CapabilityDataProvider<ConverterTrait> {
    public static final ConverterDataProvider INSTANCE = new ConverterDataProvider();

    @Override
    public void register(@NotNull IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.addConfig("gregtech", "gregtech.converter");
    }

    @Override
    @NotNull
    protected Capability<ConverterTrait> getCapability() {
        return GregtechCapabilities.CAPABILITY_CONVERTER;
    }

    @Override
    protected NBTTagCompound getNBTData(ConverterTrait capability, NBTTagCompound tag) {
        NBTTagCompound subTag = new NBTTagCompound();
        subTag.func_74757_a("IsFeToEu", capability.isFeToEu());
        subTag.func_74772_a("Voltage", capability.getVoltage());
        subTag.func_74768_a("BaseAmps", capability.getBaseAmps());
        subTag.func_74768_a("FrontFacing", capability.getMetaTileEntity().getFrontFacing().func_176745_a());
        tag.func_74782_a("gregtech.MetaTileEntityConverter", (NBTBase)subTag);
        return tag;
    }

    @NotNull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("gregtech.converter") || accessor.getTileEntity() == null) {
            return tooltip;
        }
        if (accessor.getNBTData().func_74764_b("gregtech.MetaTileEntityConverter")) {
            NBTTagCompound tag = accessor.getNBTData().func_74775_l("gregtech.MetaTileEntityConverter");
            boolean isFeToEu = tag.func_74767_n("IsFeToEu");
            long voltage = tag.func_74763_f("Voltage");
            int amperage = tag.func_74762_e("BaseAmps");
            EnumFacing frontFacing = EnumFacing.func_82600_a((int)tag.func_74762_e("FrontFacing"));
            String voltageName = GTValues.VNF[GTUtility.getTierByVoltage(voltage)];
            if (isFeToEu) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.convert_fe", (Object[])new Object[0]));
                if (accessor.getSide() == frontFacing) {
                    tooltip.add(I18n.func_135052_a((String)"gregtech.top.transform_output", (Object[])new Object[0]) + " " + voltageName + TextFormatting.RESET + " (" + TextFormattingUtil.formatNumbers(amperage) + "A)");
                } else {
                    tooltip.add(I18n.func_135052_a((String)"gregtech.top.transform_input", (Object[])new Object[0]) + " " + TextFormattingUtil.formatNumbers(FeCompat.toFe(voltage * (long)amperage, FeCompat.ratio(true))) + " FE");
                }
            } else {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.convert_eu", (Object[])new Object[0]));
                if (accessor.getSide() == frontFacing) {
                    tooltip.add(I18n.func_135052_a((String)"gregtech.top.transform_output", (Object[])new Object[0]) + " " + TextFormattingUtil.formatNumbers(FeCompat.toFe(voltage * (long)amperage, FeCompat.ratio(false))) + " FE");
                } else {
                    tooltip.add(I18n.func_135052_a((String)"gregtech.top.transform_input", (Object[])new Object[0]) + " " + voltageName + TextFormatting.RESET + " (" + TextFormattingUtil.formatNumbers(amperage) + "A)");
                }
            }
        }
        return tooltip;
    }
}

