/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.groovy;

import com.cleanroommc.groovyscript.GroovyScript;
import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.GroovyPlugin;
import com.cleanroommc.groovyscript.api.IGameObjectHandler;
import com.cleanroommc.groovyscript.compat.mods.GroovyContainer;
import com.cleanroommc.groovyscript.gameobjects.GameObjectHandlerManager;
import com.cleanroommc.groovyscript.sandbox.expand.ExpansionHelper;
import com.google.common.collect.ImmutableList;
import gregtech.api.GregTechAPI;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.modules.GregTechModule;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.registry.MaterialRegistry;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.BlockMaterialBase;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.pipelike.cable.BlockCable;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import gregtech.common.pipelike.itempipe.BlockItemPipe;
import gregtech.integration.IntegrationSubmodule;
import gregtech.integration.crafttweaker.material.MaterialExpansion;
import gregtech.integration.crafttweaker.material.MaterialPropertyExpansion;
import gregtech.integration.groovy.GroovyHandCommand;
import gregtech.integration.groovy.GroovyMaterialBuilderExpansion;
import gregtech.integration.groovy.GroovyRecipeBuilderExpansion;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Optional.Interface(modid="groovyscript", iface="com.cleanroommc.groovyscript.api.GroovyPlugin", striprefs=true)
@GregTechModule(moduleID="grs_integration", containerID="gregtech", modDependencies={"groovyscript"}, name="GregTech GroovyScript Integration", description="GroovyScript Integration Module")
public class GroovyScriptModule
extends IntegrationSubmodule
implements GroovyPlugin {
    private static GroovyContainer<?> modSupportContainer;
    private static final Map<String, Map<String, ItemStack>> metaItems;

    @Override
    @NotNull
    public List<Class<?>> getEventBusSubscribers() {
        return ImmutableList.of(GroovyHandCommand.class, GroovyScriptModule.class);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRecipeEvent(RegistryEvent.Register<IRecipe> event) {
        GroovyScriptModule.loadMetaItemBracketHandler();
    }

    public static boolean isCurrentlyRunning() {
        return GregTechAPI.moduleManager.isModuleEnabled("grs_integration") && GroovyScript.getSandbox().isRunning();
    }

    public static GroovyContainer<?> getInstance() {
        return modSupportContainer;
    }

    public static boolean validateNonNull(Object o, Supplier<String> errorMsg) {
        if (o == null) {
            if (GroovyScriptModule.isCurrentlyRunning()) {
                GroovyLog.get().error((Object)errorMsg.get());
            }
            return false;
        }
        return true;
    }

    @Nullable
    public static ItemStack getMetaItem(String name) {
        ItemStack stack;
        String[] resultName = GroovyScriptModule.splitObjectName(name);
        Map<String, ItemStack> map = metaItems.get(resultName[0]);
        if (map != null && (stack = map.get(resultName[1])) != null) {
            return stack.func_77946_l();
        }
        stack = GroovyScriptModule.getMetaTileEntityItem(resultName);
        if (stack != null) {
            return stack.func_77946_l();
        }
        return null;
    }

    @Nullable
    public static ItemStack getMetaTileEntityItem(String[] split) {
        MetaTileEntity metaTileEntity = (MetaTileEntity)GregTechAPI.MTE_REGISTRY.func_82594_a(new ResourceLocation(split[0], split[1]));
        return metaTileEntity == null ? null : metaTileEntity.getStackForm();
    }

    public static String[] splitObjectName(String toSplit) {
        String[] resultSplit = new String[]{"gregtech", toSplit};
        int i = toSplit.indexOf(58);
        if (i >= 0) {
            resultSplit[1] = toSplit.substring(i + 1);
            if (i > 1) {
                resultSplit[0] = toSplit.substring(0, i);
            }
        }
        return resultSplit;
    }

    public static void loadMetaItemBracketHandler() {
        ItemStack stack;
        Map map;
        String modid;
        metaItems.clear();
        for (Map.Entry<Material, BlockCompressed> entry : MetaBlocks.COMPRESSED.entrySet()) {
            modid = entry.getKey().getModid();
            map = metaItems.computeIfAbsent(modid, k -> new Object2ObjectOpenHashMap());
            String string = "block" + entry.getKey().toCamelCaseString();
            stack = entry.getValue().getItem(entry.getKey());
            map.put(string, stack);
        }
        for (Map.Entry<Material, BlockMaterialBase> entry : MetaBlocks.FRAMES.entrySet()) {
            modid = entry.getKey().getModid();
            map = metaItems.computeIfAbsent(modid, k -> new Object2ObjectOpenHashMap());
            String string = "frame" + entry.getKey().toCamelCaseString();
            stack = ((BlockFrame)entry.getValue()).getItem(entry.getKey());
            map.put(string, stack);
        }
        for (MaterialRegistry materialRegistry : GregTechAPI.materialManager.getRegistries()) {
            ItemStack stack2;
            String name;
            modid = materialRegistry.getModid();
            map = metaItems.computeIfAbsent(modid, k -> new Object2ObjectOpenHashMap());
            for (BlockCable blockCable : MetaBlocks.CABLES.get(modid)) {
                for (Material material : blockCable.getEnabledMaterials()) {
                    String name2 = blockCable.getPrefix().name + material.toCamelCaseString();
                    ItemStack stack22 = blockCable.getItem(material);
                    map.put(name2, stack22);
                }
            }
            for (BlockItemPipe blockItemPipe : MetaBlocks.ITEM_PIPES.get(modid)) {
                for (Material material : blockItemPipe.getEnabledMaterials()) {
                    name = blockItemPipe.getPrefix().name + material.toCamelCaseString();
                    stack2 = blockItemPipe.getItem(material);
                    map.put(name, stack2);
                }
            }
            for (BlockFluidPipe blockFluidPipe : MetaBlocks.FLUID_PIPES.get(modid)) {
                for (Material material : blockFluidPipe.getEnabledMaterials()) {
                    name = blockFluidPipe.getPrefix().name + material.toCamelCaseString();
                    stack2 = blockFluidPipe.getItem(material);
                    map.put(name, stack2);
                }
            }
            metaItems.put(modid, map);
        }
        for (MetaItem metaItem : MetaItem.getMetaItems()) {
            Map map2 = metaItems.computeIfAbsent(Objects.requireNonNull(metaItem.getRegistryName()).func_110624_b(), k -> new Object2ObjectOpenHashMap());
            for (MetaItem.MetaValueItem metaValueItem : metaItem.getAllItems()) {
                if (metaValueItem.unlocalizedName.equals("meta_item")) continue;
                map2.put(metaValueItem.unlocalizedName, metaValueItem.getStackForm());
            }
        }
    }

    @NotNull
    public String getModId() {
        return "gregtech";
    }

    @NotNull
    public String getModName() {
        return "GregTech";
    }

    public void onCompatLoaded(GroovyContainer<?> groovyContainer) {
        modSupportContainer = groovyContainer;
        GameObjectHandlerManager.registerGameObjectHandler((String)"gregtech", (String)"recipemap", (IGameObjectHandler)IGameObjectHandler.wrapStringGetter(RecipeMap::getByName));
        GameObjectHandlerManager.registerGameObjectHandler((String)"gregtech", (String)"material", (IGameObjectHandler)IGameObjectHandler.wrapStringGetter(GregTechAPI.materialManager::getMaterial));
        GameObjectHandlerManager.registerGameObjectHandler((String)"gregtech", (String)"oreprefix", (IGameObjectHandler)IGameObjectHandler.wrapStringGetter(OrePrefix::getPrefix));
        GameObjectHandlerManager.registerGameObjectHandler((String)"gregtech", (String)"metaitem", (IGameObjectHandler)IGameObjectHandler.wrapStringGetter(GroovyScriptModule::getMetaItem), (Object)ItemStack.field_190927_a);
        ExpansionHelper.mixinClass(Material.class, MaterialExpansion.class);
        ExpansionHelper.mixinClass(Material.class, MaterialPropertyExpansion.class);
        ExpansionHelper.mixinClass(Material.Builder.class, GroovyMaterialBuilderExpansion.class);
        ExpansionHelper.mixinClass(RecipeBuilder.class, GroovyRecipeBuilderExpansion.class);
    }

    static {
        metaItems = new Object2ObjectOpenHashMap();
    }
}

