/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.forestry.tools;

import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IEntityButterfly;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.items.toolitem.behavior.IToolBehavior;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Loader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScoopBehavior
implements IToolBehavior {
    public static final ScoopBehavior INSTANCE = new ScoopBehavior();

    private ScoopBehavior() {
    }

    @Override
    public void hitEntity(@NotNull ItemStack stack, @NotNull EntityLivingBase target, @NotNull EntityLivingBase attacker) {
        if (!Loader.isModLoaded((String)"forestry")) {
            return;
        }
        if (!(target instanceof IEntityButterfly)) {
            return;
        }
        IEntityButterfly butterfly = (IEntityButterfly)target;
        if (!(attacker instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)attacker;
        if (attacker.field_70170_p == null || attacker.field_70170_p.field_72995_K) {
            return;
        }
        IAlleleButterflySpecies species = butterfly.getButterfly().getGenome().getPrimary();
        species.getRoot().getBreedingTracker(target.field_70170_p, player.func_146103_bH()).registerCatch(butterfly.getButterfly());
        ItemStack memberStack = species.getRoot().getMemberStack((IIndividual)butterfly.getButterfly().copy(), (ISpeciesType)EnumFlutterType.BUTTERFLY);
        EntityItem entityItem = new EntityItem(player.field_70170_p, target.field_70165_t, target.field_70163_u, target.field_70161_v, memberStack);
        target.func_70106_y();
        NBTTagCompound behaviorTag = ToolHelper.getBehaviorsTag(stack);
        if (behaviorTag.func_74767_n("RelocateMinedBlocks")) {
            if (ForgeEventFactory.onItemPickup((EntityItem)entityItem, (EntityPlayer)player) == -1) {
                return;
            }
            if (player.func_191521_c(memberStack)) {
                return;
            }
        }
        player.field_70170_p.func_72838_d((Entity)entityItem);
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)"item.gt.tool.behavior.scoop", (Object[])new Object[0]));
    }
}

