/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.forestry.recipes;

import forestry.core.fluids.Fluids;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.integration.IntegrationUtil;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;

public class ForestryExtractorRecipes {
    public static void init() {
        ItemStack mulch = IntegrationUtil.getModItem("forestry", "mulch", 0);
        ItemStack propolis = IntegrationUtil.getModItem("forestry", "propolis", 0);
        ForestryExtractorRecipes.addFruitJuiceRecipe(new ItemStack(Items.field_151172_bF), 200, GTUtility.copy(mulch), 2000);
        ForestryExtractorRecipes.addFruitJuiceRecipe(new ItemStack(Items.field_151034_e), 200, GTUtility.copy(mulch), 2000);
        ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("forestry", "fruits", 0), 50, GTUtility.copy(mulch), 500);
        ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("forestry", "fruits", 1), 180, GTUtility.copy(mulch), 500);
        ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("forestry", "fruits", 2), 220, GTUtility.copy(mulch), 200);
        ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("forestry", "fruits", 3), 400, GTUtility.copy(mulch), 1000);
        ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("forestry", "fruits", 4), 100, GTUtility.copy(mulch), 6000);
        ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("forestry", "fruits", 5), 50, GTUtility.copy(mulch), 2000);
        ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("forestry", "fruits", 6), 600, GTUtility.copy(mulch), 1000);
        ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("forestry", "honey_drop", 0), 100, GTUtility.copy(propolis), 0);
        ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("forestry", "honeydew", 0), 100);
        if (Loader.isModLoaded((String)"extrabees")) {
            ForestryExtractorRecipes.addExtractorRecipe(IntegrationUtil.getModItem("extrabees", "propolis", 0), Materials.Water.getFluid(500));
            ForestryExtractorRecipes.addExtractorRecipe(IntegrationUtil.getModItem("extrabees", "propolis", 1), Materials.Oil.getFluid(500));
            ForestryExtractorRecipes.addExtractorRecipe(IntegrationUtil.getModItem("extrabees", "propolis", 2), Materials.Creosote.getFluid(500));
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 3), 200);
            ForestryExtractorRecipes.addExtractorRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 6), Fluids.MILK.getFluid(200));
            ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 13), 200, IntegrationUtil.getModItem("extrabees", "misc", 19), 0);
            ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 14), 200, IntegrationUtil.getModItem("extrabees", "misc", 20), 0);
            ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 15), 200, IntegrationUtil.getModItem("extrabees", "misc", 21), 0);
            ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 16), 200, IntegrationUtil.getModItem("extrabees", "misc", 22), 0);
            ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 17), 200, IntegrationUtil.getModItem("extrabees", "misc", 24), 0);
            ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 18), 200, IntegrationUtil.getModItem("extrabees", "misc", 23), 0);
            ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 19), 200, IntegrationUtil.getModItem("extrabees", "misc", 25), 0);
            ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 20), 200, new ItemStack(Items.field_151100_aR, 1, 14), 0);
            ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 21), 200, new ItemStack(Items.field_151100_aR, 1, 6), 0);
            ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 22), 200, new ItemStack(Items.field_151100_aR, 1, 5), 0);
            ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 23), 200, new ItemStack(Items.field_151100_aR, 1, 8), 0);
            ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 24), 200, new ItemStack(Items.field_151100_aR, 1, 12), 0);
            ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 25), 200, new ItemStack(Items.field_151100_aR, 1, 9), 0);
            ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 26), 200, new ItemStack(Items.field_151100_aR, 1, 10), 0);
            ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 27), 200, new ItemStack(Items.field_151100_aR, 1, 13), 0);
            ForestryExtractorRecipes.addHoneyRecipe(IntegrationUtil.getModItem("extrabees", "honey_drop", 28), 200, new ItemStack(Items.field_151100_aR, 1, 7), 0);
        }
        if (Loader.isModLoaded((String)"extratrees")) {
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 0), 150, GTUtility.copy(mulch), 1000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 1), 400, GTUtility.copy(mulch), 1500);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 2), 300, GTUtility.copy(mulch), 1000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 3), 300, GTUtility.copy(mulch), 1000);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 4), 50, GTUtility.copy(mulch), 500);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 5), 50, GTUtility.copy(mulch), 300);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 6), 50, GTUtility.copy(mulch), 500);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 7), 50, GTUtility.copy(mulch), 500);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 8), 100, GTUtility.copy(mulch), 6000);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 9), 80, GTUtility.copy(mulch), 500);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 10), 150, GTUtility.copy(mulch), 4000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 11), 500, GTUtility.copy(mulch), 1500);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 12), 150, GTUtility.copy(mulch), 4000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 13), 300, GTUtility.copy(mulch), 1000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 14), 400, GTUtility.copy(mulch), 1500);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 15), 400, GTUtility.copy(mulch), 1500);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 16), 300, GTUtility.copy(mulch), 1000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 17), 300, GTUtility.copy(mulch), 1000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 18), 400, GTUtility.copy(mulch), 1000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 19), 150, GTUtility.copy(mulch), 4000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 20), 300, GTUtility.copy(mulch), 1000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 21), 300, GTUtility.copy(mulch), 1000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 22), 300, GTUtility.copy(mulch), 2000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 23), 200, GTUtility.copy(mulch), 1000);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 24), 150, GTUtility.copy(mulch), 500);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 25), 180, GTUtility.copy(mulch), 500);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 26), 100, GTUtility.copy(mulch), 400);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 27), 50, GTUtility.copy(mulch), 200);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 28), 100, GTUtility.copy(mulch), 3000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 29), 100, GTUtility.copy(mulch), 3000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 30), 100, GTUtility.copy(mulch), 4000);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 31), 20, GTUtility.copy(mulch), 200);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 32), 50, GTUtility.copy(mulch), 300);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 33), 50, GTUtility.copy(mulch), 300);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 34), 100, GTUtility.copy(mulch), 500);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 35), 50, GTUtility.copy(mulch), 300);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 36), 50, GTUtility.copy(mulch), 500);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 37), 20, GTUtility.copy(mulch), 200);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 38), 300, GTUtility.copy(mulch), 1500);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 39), 25, GTUtility.copy(mulch), 200);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 46), 50, GTUtility.copy(mulch), 500);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 50), 300, GTUtility.copy(mulch), 2500);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 51), 150, GTUtility.copy(mulch), 1500);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 52), 300, GTUtility.copy(mulch), 1500);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 53), 50, GTUtility.copy(mulch), 1000);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 54), 50, GTUtility.copy(mulch), 1000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 55), 100, GTUtility.copy(mulch), 1000);
            ForestryExtractorRecipes.addSeedOilRecipe(IntegrationUtil.getModItem("extratrees", "food", 56), 100, GTUtility.copy(mulch), 1000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 57), 400, GTUtility.copy(mulch), 2000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 58), 300, GTUtility.copy(mulch), 1000);
            ForestryExtractorRecipes.addFruitJuiceRecipe(IntegrationUtil.getModItem("extratrees", "food", 59), 50, GTUtility.copy(mulch), 1000);
        }
    }

    private static void addSeedOilRecipe(ItemStack inputStack, int outputAmount) {
        ForestryExtractorRecipes.addExtractorRecipe(inputStack, Materials.SeedOil.getFluid(outputAmount), ItemStack.field_190927_a, 0);
    }

    private static void addSeedOilRecipe(ItemStack inputStack, int outputAmount, ItemStack extraOutput, int chance) {
        ForestryExtractorRecipes.addExtractorRecipe(inputStack, Materials.SeedOil.getFluid(outputAmount), extraOutput, chance);
    }

    private static void addHoneyRecipe(ItemStack inputStack, int outputAmount) {
        ForestryExtractorRecipes.addExtractorRecipe(inputStack, Fluids.FOR_HONEY.getFluid(outputAmount), ItemStack.field_190927_a, 0);
    }

    private static void addHoneyRecipe(ItemStack inputStack, int outputAmount, ItemStack extraOutput, int chance) {
        ForestryExtractorRecipes.addExtractorRecipe(inputStack, Fluids.FOR_HONEY.getFluid(outputAmount), extraOutput, chance);
    }

    private static void addFruitJuiceRecipe(ItemStack inputStack, int outputAmount) {
        ForestryExtractorRecipes.addExtractorRecipe(inputStack, Fluids.JUICE.getFluid(outputAmount), ItemStack.field_190927_a, 0);
    }

    private static void addFruitJuiceRecipe(ItemStack inputStack, int outputAmount, ItemStack extraOutput, int chance) {
        ForestryExtractorRecipes.addExtractorRecipe(inputStack, Fluids.JUICE.getFluid(outputAmount), extraOutput, chance);
    }

    private static void addExtractorRecipe(ItemStack inputStack, FluidStack outputFluid) {
        ForestryExtractorRecipes.addExtractorRecipe(inputStack, outputFluid, ItemStack.field_190927_a, 0);
    }

    private static void addExtractorRecipe(ItemStack inputStack, FluidStack outputFluid, ItemStack extraOutput, int chance) {
        Object builder = ((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(inputStack)).fluidOutputs(outputFluid);
        if (extraOutput != ItemStack.field_190927_a) {
            if (chance > 0) {
                ((RecipeBuilder)builder).chancedOutput(extraOutput, chance, 0);
            } else {
                ((RecipeBuilder)builder).outputs(extraOutput);
            }
        }
        ((RecipeBuilder)((RecipeBuilder)((RecipeBuilder)builder).duration(32)).EUt(7)).buildAndRegister();
    }
}

