/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.forestry.bees;

import appeng.core.Api;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeMutationBuilder;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutationBuilder;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.IBeeDefinition;
import forestry.apiculture.genetics.alleles.AlleleEffects;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.core.ModuleCore;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.common.items.MetaItems;
import gregtech.integration.IntegrationUtil;
import gregtech.integration.forestry.ForestryModule;
import gregtech.integration.forestry.ForestryUtil;
import gregtech.integration.forestry.bees.GTAlleleBeeSpecies;
import gregtech.integration.forestry.bees.GTBranchDefinition;
import gregtech.integration.forestry.bees.GTCombType;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;

public enum GTBeeDefinition implements IBeeDefinition
{
    CLAY(GTBranchDefinition.GT_ORGANIC, "Lutum", true, 13158618, 255, beeSpecies -> {
        if (Loader.isModLoaded((String)"extrabees")) {
            beeSpecies.addProduct(GTBeeDefinition.getExtraBeesComb(22), Float.valueOf(0.3f));
        } else {
            beeSpecies.addProduct(GTBeeDefinition.getForestryComb(EnumHoneyComb.HONEY), Float.valueOf(0.3f));
        }
        beeSpecies.addProduct(new ItemStack(Items.field_151119_aD), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        if (Loader.isModLoaded((String)"biomesoplenty")) {
            beeSpecies.addSpecialty(IntegrationUtil.getModItem("biomesoplenty", "mudball", 0), Float.valueOf(0.05f));
        }
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
    }, dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)BeeDefinition.INDUSTRIOUS, (IBeeDefinition)BeeDefinition.DILIGENT, 10);
        mutation.requireResource(new IBlockState[]{Blocks.field_150405_ch.func_176223_P()});
    }),
    SLIMEBALL(GTBranchDefinition.GT_ORGANIC, "Bituminipila", true, 5152341, 65301, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getForestryComb(EnumHoneyComb.MOSSY), Float.valueOf(0.3f));
        beeSpecies.addProduct(new ItemStack(Items.field_151123_aH), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.STICKY), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        if (Loader.isModLoaded((String)"tconstruct")) {
            beeSpecies.addProduct(IntegrationUtil.getModItem("tconstruct", "edible", 1), Float.valueOf(0.1f));
            beeSpecies.addSpecialty(IntegrationUtil.getModItem("tconstruct", "slime_congealed", 2), Float.valueOf(0.01f));
        } else {
            beeSpecies.addSpecialty(new ItemStack(Blocks.field_180399_cE), Float.valueOf(0.01f));
        }
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.MUSHROOMS);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        if (Loader.isModLoaded((String)"extrabees")) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)ForestryUtil.getFlowers("extrabees", "water"));
        }
    }, dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)BeeDefinition.MARSHY, (IBeeDefinition)CLAY, 7);
        mutation.requireResource(new IBlockState[]{Blocks.field_180399_cE.func_176223_P()});
    }),
    PEAT(GTBranchDefinition.GT_ORGANIC, "Limus", true, 9462327, 5779467, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getForestryComb(EnumHoneyComb.HONEY), Float.valueOf(0.15f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.COAL), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(ModuleCore.getItems().peat.getItemStack(), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(ModuleCore.getItems().mulch.getItemStack(), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
    }, dis -> dis.registerMutation((IBeeDefinition)BeeDefinition.RURAL, (IBeeDefinition)CLAY, 10)),
    STICKYRESIN(GTBranchDefinition.GT_ORGANIC, "Lenturesinae", true, 3051355, 14467721, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getForestryComb(EnumHoneyComb.HONEY), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.STICKY), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(MetaItems.STICKY_RESIN.getStackForm(), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
    }, dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)SLIMEBALL, (IBeeDefinition)PEAT, 15);
        mutation.requireResource("logRubber");
    }),
    COAL(GTBranchDefinition.GT_ORGANIC, "Carbo", true, 0x666666, 0x525252, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.COAL), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.COKE), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.CACTI);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectCreeper);
    }, dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)BeeDefinition.INDUSTRIOUS, (IBeeDefinition)PEAT, 9);
        mutation.requireResource("blockCoal");
    }),
    OIL(GTBranchDefinition.GT_ORGANIC, "Oleum", true, 0x4C4C4C, 0x333333, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getForestryComb(EnumHoneyComb.HONEY), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.OIL), Float.valueOf(0.75f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        if (Loader.isModLoaded((String)"extrabees")) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)ForestryUtil.getFlowers("extrabees", "water"));
        }
    }, dis -> dis.registerMutation((IBeeDefinition)COAL, (IBeeDefinition)STICKYRESIN, 4)),
    ASH(GTBranchDefinition.GT_ORGANIC, "Cinis", true, 1972760, 0xC6C6C6, beeSpecies -> {
        if (Loader.isModLoaded((String)"extrabees")) {
            beeSpecies.addProduct(GTBeeDefinition.getExtraBeesComb(9), Float.valueOf(0.3f));
        } else {
            beeSpecies.addProduct(GTBeeDefinition.getForestryComb(EnumHoneyComb.HONEY), Float.valueOf(0.3f));
        }
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.ASH), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGE);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
    }, dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)COAL, (IBeeDefinition)CLAY, 10);
        mutation.restrictTemperature(EnumTemperature.HELLISH);
    }),
    APATITE(GTBranchDefinition.GT_ORGANIC, "Stercorat", true, 8376053, 6636837, beeSpecies -> {
        if (Loader.isModLoaded((String)"extrabees")) {
            beeSpecies.addProduct(GTBeeDefinition.getExtraBeesComb(9), Float.valueOf(0.15f));
        } else {
            beeSpecies.addProduct(GTBeeDefinition.getForestryComb(EnumHoneyComb.HONEY), Float.valueOf(0.15f));
        }
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.APATITE), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
        if (Loader.isModLoaded((String)"extrabees")) {
            AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)ForestryUtil.getFlowers("extrabees", "rock"));
        }
    }, dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)ASH, (IBeeDefinition)COAL, 10);
        mutation.requireResource("blockApatite");
    }),
    BIOMASS(GTBranchDefinition.GT_ORGANIC, "Taeda", true, 2220312, 1552142, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getForestryComb(EnumHoneyComb.MOSSY), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.BIOMASS), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
    }, dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)BeeDefinition.INDUSTRIOUS, (IBeeDefinition)BeeDefinition.RURAL, 10);
        mutation.restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
    }),
    FERTILIZER(GTBranchDefinition.GT_ORGANIC, "Stercorat", true, 8376053, 6636837, beeSpecies -> {
        if (Loader.isModLoaded((String)"extrabees")) {
            beeSpecies.addProduct(GTBeeDefinition.getExtraBeesComb(9), Float.valueOf(0.15f));
        } else {
            beeSpecies.addProduct(GTBeeDefinition.getForestryComb(EnumHoneyComb.MOSSY), Float.valueOf(0.15f));
        }
        beeSpecies.addSpecialty(OreDictUnifier.get(OrePrefix.dustTiny, Materials.Ash), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(OreDictUnifier.get(OrePrefix.dustTiny, Materials.DarkAsh), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(MetaItems.FERTILIZER.getStackForm(), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(IntegrationUtil.getModItem("forestry", "fertilizer_compound", 0), Float.valueOf(0.3f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
    }, dis -> dis.registerMutation((IBeeDefinition)ASH, (IBeeDefinition)APATITE, 8)),
    PHOSPHORUS(GTBranchDefinition.GT_ORGANIC, "Phosphorus", false, 16762918, 12698102, beeSpecies -> {
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.PHOSPHORUS), Float.valueOf(0.35f));
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)APATITE, (IBeeDefinition)ASH, 12);
        mutation.restrictTemperature(EnumTemperature.HOT);
        mutation.requireResource("blockTricalciumPhosphate");
    }),
    SANDWICH(GTBranchDefinition.GT_ORGANIC, "Sandwico", true, 3329330, 14329120, beeSpecies -> {
        beeSpecies.addProduct(IntegrationUtil.getModItem("gregtechfoodoption", "gtfo_meta_item", 81), Float.valueOf(0.05f));
        beeSpecies.addProduct(IntegrationUtil.getModItem("gregtechfoodoption", "gtfo_meta_item", 80), Float.valueOf(0.05f));
        beeSpecies.addProduct(IntegrationUtil.getModItem("gregtechfoodoption", "gtfo_meta_item", 79), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(new ItemStack(Items.field_151157_am), Float.valueOf(0.05f));
        beeSpecies.addSpecialty(new ItemStack(Items.field_151083_be), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(IntegrationUtil.getModItem("gregtechfoodoption", "gtfo_meta_item", 97), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectFertile);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGE);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
    }, dis -> {
        if (Loader.isModLoaded((String)"magicbees")) {
            dis.registerMutation((IBeeDefinition)BeeDefinition.AGRARIAN, ForestryUtil.getSpecies("magicbees", "Batty"), 10);
        } else {
            dis.registerMutation((IBeeDefinition)BeeDefinition.AGRARIAN, (IBeeDefinition)BeeDefinition.IMPERIAL, 10);
        }
    }, () -> Loader.isModLoaded((String)"gregtechfoodoption")),
    REDSTONE(GTBranchDefinition.GT_GEM, "Rubrumlapis", true, 8195855, 0xD11919, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.REDSTONE), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.RAREEARTH), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)BeeDefinition.INDUSTRIOUS, (IBeeDefinition)BeeDefinition.DEMONIC, 10);
        mutation.requireResource("blockRedstone");
    }),
    LAPIS(GTBranchDefinition.GT_GEM, "Lapidi", true, 1656785, 4680922, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.LAPIS), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)BeeDefinition.DEMONIC, (IBeeDefinition)BeeDefinition.IMPERIAL, 10);
        mutation.requireResource("blockLapis");
    }),
    CERTUS(GTBranchDefinition.GT_GEM, "Quarzeus", true, 5754875, 0xBBEEFF, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.CERTUS), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)BeeDefinition.HERMITIC, (IBeeDefinition)LAPIS, 10);
        mutation.requireResource("blockCertusQuartz");
    }),
    FLUIX(GTBranchDefinition.GT_GEM, "", true, 10712575, 11899391, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.FLUIX), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)REDSTONE, (IBeeDefinition)LAPIS, 7);
        Api.INSTANCE.definitions().blocks().fluixBlock().maybeBlock().ifPresent(block -> mutation.requireResource(new IBlockState[]{block.func_176223_P()}));
    }, () -> Loader.isModLoaded((String)"appliedenergistics2")),
    DIAMOND(GTBranchDefinition.GT_GEM, "Adamas", false, 0xCCFFFF, 0xA3CCCC, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.DIAMOND), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)CERTUS, (IBeeDefinition)COAL, 3);
        mutation.requireResource("blockDiamond");
    }),
    RUBY(GTBranchDefinition.GT_GEM, "Rubinus", false, 15073372, 13369426, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.RUBY), Float.valueOf(0.15f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.REDSTONE), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)REDSTONE, (IBeeDefinition)DIAMOND, 5);
        mutation.requireResource("blockRuby");
    }),
    SAPPHIRE(GTBranchDefinition.GT_GEM, "Sapphirus", true, 13260, 9359, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.SAPPHIRE), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)CERTUS, (IBeeDefinition)LAPIS, 5);
        mutation.requireResource("blockSapphire");
    }),
    OLIVINE(GTBranchDefinition.GT_GEM, "Olivinum", true, 2395940, 0xCCFFCC, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.OLIVINE), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.MAGNESIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> dis.registerMutation((IBeeDefinition)CERTUS, (IBeeDefinition)BeeDefinition.ENDED, 5)),
    EMERALD(GTBranchDefinition.GT_GEM, "Smaragdus", false, 2395940, 3061806, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.EMERALD), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.ALUMINIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)OLIVINE, (IBeeDefinition)DIAMOND, 4);
        mutation.requireResource("blockEmerald");
    }),
    SPARKLING(GTBranchDefinition.GT_GEM, "Vesperstella", true, 0x7A007A, 0xFFFFFF, beeSpecies -> {
        beeSpecies.addProduct(IntegrationUtil.getModItem("magicbees", "resource", 3), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.SPARKLING), Float.valueOf(0.125f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.NETHER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectAggressive);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }, dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation(ForestryUtil.getSpecies("magicbees", "Withering"), ForestryUtil.getSpecies("magicbees", "Draconic"), 1);
        mutation.requireResource("blockNetherStar");
        mutation.restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.END});
    }, () -> Loader.isModLoaded((String)"magicbees")),
    COPPER(GTBranchDefinition.GT_METAL, "Cuprum", true, 0xFF6600, 15096832, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.COPPER), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.GOLD), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)BeeDefinition.MAJESTIC, (IBeeDefinition)CLAY, 13);
        mutation.requireResource("blockCopper");
    }),
    TIN(GTBranchDefinition.GT_METAL, "Stannum", true, 0xD4D4D4, 0xDDDDDD, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.TIN), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.ZINC), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)CLAY, (IBeeDefinition)BeeDefinition.DILIGENT, 13);
        mutation.requireResource("blockTin");
    }),
    LEAD(GTBranchDefinition.GT_METAL, "Plumbum", true, 0x666699, 0xA3A3CC, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.LEAD), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.SULFUR), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)COAL, (IBeeDefinition)COPPER, 13);
        mutation.requireResource("blockLead");
    }),
    IRON(GTBranchDefinition.GT_METAL, "Ferrum", true, 14324039, 14589017, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.IRON), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.TIN), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)TIN, (IBeeDefinition)COPPER, 13);
        mutation.requireResource("blockIron");
    }),
    STEEL(GTBranchDefinition.GT_METAL, "Chalybe", true, 0x808080, 0x999999, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.STEEL), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.IRON), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)IRON, (IBeeDefinition)COAL, 10);
        mutation.requireResource("blockSteel");
        mutation.restrictTemperature(EnumTemperature.HOT);
    }),
    NICKEL(GTBranchDefinition.GT_METAL, "Nichelium", true, 8750509, 8750509, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.NICKEL), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.PLATINUM), Float.valueOf(0.02f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)IRON, (IBeeDefinition)COPPER, 13);
        mutation.requireResource("blockNickel");
    }),
    ZINC(GTBranchDefinition.GT_METAL, "Cadmiae", true, 15785712, 15917554, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.ZINC), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.GALLIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)IRON, (IBeeDefinition)TIN, 13);
        mutation.requireResource("blockZinc");
    }),
    SILVER(GTBranchDefinition.GT_METAL, "Argenti", true, 12763862, 0xCECEDE, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SILVER), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.SULFUR), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)LEAD, (IBeeDefinition)TIN, 10);
        mutation.requireResource("blockSilver");
    }),
    GOLD(GTBranchDefinition.GT_METAL, "Aurum", true, 15451699, 15584327, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.GOLD), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.NICKEL), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)LEAD, (IBeeDefinition)COPPER, 13);
        mutation.requireResource("blockGold");
        mutation.restrictTemperature(EnumTemperature.HOT);
    }),
    ARSENIC(GTBranchDefinition.GT_METAL, "Arsenicum", true, 7564370, 2696210, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.ARSENIC), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)ZINC, (IBeeDefinition)SILVER, 10);
        mutation.requireResource("blockArsenic");
    }),
    SILICON(GTBranchDefinition.GT_ORGANIC, "Silex", false, 11379367, 7562869, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getForestryComb(EnumHoneyComb.HONEY), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(OreDictUnifier.get(OrePrefix.dust, Materials.Silicon), Float.valueOf(0.3f));
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TOLERATES_RAIN, true);
    }, dis -> {
        if (Loader.isModLoaded((String)"magicbees") && Loader.isModLoaded((String)"appliedenergistics2")) {
            dis.registerMutation((IBeeDefinition)IRON, ForestryUtil.getSpecies("magicbees", "AESkystone"), 17);
        } else {
            dis.registerMutation((IBeeDefinition)IRON, (IBeeDefinition)BeeDefinition.IMPERIAL, 17);
        }
    }),
    ALUMINIUM(GTBranchDefinition.GT_RAREMETAL, "Alumen", true, 0xB8B8FF, 0xD6D6FF, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.ALUMINIUM), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.BAUXITE), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)NICKEL, (IBeeDefinition)ZINC, 9);
        mutation.requireResource("blockAluminium");
    }),
    TITANIUM(GTBranchDefinition.GT_RAREMETAL, "Titanus", true, 0xCC99FF, 14399743, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.TITANIUM), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.ALMANDINE), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)REDSTONE, (IBeeDefinition)ALUMINIUM, 5);
        mutation.requireResource("blockTitanium");
    }),
    CHROME(GTBranchDefinition.GT_RAREMETAL, "Chroma", true, 15442411, 15909874, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.CHROME), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.MAGNESIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)TITANIUM, (IBeeDefinition)RUBY, 5);
        mutation.requireResource("blockChrome");
    }),
    MANGANESE(GTBranchDefinition.GT_RAREMETAL, "Manganum", true, 0xD5D5D5, 0xAAAAAA, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.MANGANESE), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.IRON), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)TITANIUM, (IBeeDefinition)ALUMINIUM, 5);
        mutation.requireResource("blockManganese");
    }),
    TUNGSTEN(GTBranchDefinition.GT_RAREMETAL, "Wolframium", false, 6053002, 8224161, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.TUNGSTEN), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.MOLYBDENUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)BeeDefinition.HEROIC, (IBeeDefinition)MANGANESE, 5);
        mutation.requireResource("blockTungsten");
    }),
    PLATINUM(GTBranchDefinition.GT_RAREMETAL, "Platina", false, 0xE6E6E6, 0xFFFFCC, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.PLATINUM), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.IRIDIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)DIAMOND, (IBeeDefinition)CHROME, 5);
        mutation.requireResource("blockPlatinum");
    }),
    IRIDIUM(GTBranchDefinition.GT_RAREMETAL, "Iris", false, 0xDADADA, 13750752, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.IRIDIUM), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.OSMIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)TUNGSTEN, (IBeeDefinition)PLATINUM, 5);
        mutation.requireResource("blockIridium");
    }),
    OSMIUM(GTBranchDefinition.GT_RAREMETAL, "Osmia", false, 2829274, 0x8B8B8B, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.OSMIUM), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.IRIDIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)TUNGSTEN, (IBeeDefinition)PLATINUM, 5);
        mutation.requireResource("blockOsmium");
    }),
    SALTY(GTBranchDefinition.GT_RAREMETAL, "Sal", true, 15780040, 0xFAFAFA, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.SALT), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.LITHIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)CLAY, (IBeeDefinition)ALUMINIUM, 5);
        mutation.requireResource("blockSalt");
    }),
    LITHIUM(GTBranchDefinition.GT_RAREMETAL, "Lithos", false, 15741580, 14802175, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.LITHIUM), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.SALT), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)SALTY, (IBeeDefinition)ALUMINIUM, 5);
        mutation.requireResource("blockLithium");
    }),
    ELECTROTINE(GTBranchDefinition.GT_RAREMETAL, "Electrum", false, 2003199, 3978440, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.ELECTROTINE), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.REDSTONE), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)REDSTONE, (IBeeDefinition)GOLD, 5);
        mutation.requireResource("blockElectrotine");
    }),
    SULFUR(GTBranchDefinition.GT_RAREMETAL, "Sulphur", false, 2003199, 3978440, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SULFUR), Float.valueOf(0.7f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL), dis -> dis.registerMutation((IBeeDefinition)ASH, (IBeeDefinition)PEAT, 15)),
    INDIUM(GTBranchDefinition.GT_RAREMETAL, "Indicium", false, 0xFFA9FF, 9395609, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.INDIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)LEAD, (IBeeDefinition)OSMIUM, 1);
        mutation.requireResource("blockIndium");
        mutation.restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.END});
    }),
    ENERGY(GTBranchDefinition.GT_INDUSTRIAL, "Industria", false, 0xC11F1F, 0xEBB9B9, beeSpecies -> {
        if (Loader.isModLoaded((String)"extrabees")) {
            beeSpecies.addProduct(GTBeeDefinition.getExtraBeesComb(14), Float.valueOf(0.3f));
        } else {
            beeSpecies.addProduct(GTBeeDefinition.getForestryComb(EnumHoneyComb.SIMMERING), Float.valueOf(0.3f));
        }
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.ENERGY), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.WARM);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectIgnition);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.NETHER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }, dis -> {
        IBeeMutationBuilder mutation = Loader.isModLoaded((String)"extrabees") ? dis.registerMutation((IBeeDefinition)BeeDefinition.DEMONIC, ForestryUtil.getSpecies("extrabees", "volcanic"), 10) : dis.registerMutation((IBeeDefinition)BeeDefinition.DEMONIC, (IBeeDefinition)BeeDefinition.FIENDISH, 10);
        mutation.requireResource("blockRedstone");
    }),
    LAPOTRON(GTBranchDefinition.GT_INDUSTRIAL, "Azureus", false, 16772036, 14902272, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.LAPIS), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.ENERGY), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.LAPOTRON), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectIgnition);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }, dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)LAPIS, (IBeeDefinition)ENERGY, 6);
        mutation.requireResource("blockLapis");
        mutation.restrictTemperature(EnumTemperature.ICY);
    }),
    EXPLOSIVE(GTBranchDefinition.GT_INDUSTRIAL, "Explosionis", false, 8267535, 0x747474, beeSpecies -> {
        beeSpecies.addProduct(new ItemStack(Blocks.field_150335_W), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectSnowing);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
    }, dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)BeeDefinition.AUSTERE, (IBeeDefinition)COAL, 4);
        mutation.requireResource(new IBlockState[]{Blocks.field_150335_W.func_176223_P()});
    }),
    REDALLOY(GTBranchDefinition.GT_ALLOY, "Rubrum", false, 0xE60000, 0xB80000, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getForestryComb(EnumHoneyComb.PARCHED), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.REDALLOY), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
    }, dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)COPPER, (IBeeDefinition)REDSTONE, 10);
        mutation.requireResource("blockRedAlloy");
    }),
    STAINLESSSTEEL(GTBranchDefinition.GT_ALLOY, "Nonferrugo", false, 0xC8C8DC, 0x778899, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.STEEL), Float.valueOf(0.1f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.STAINLESSSTEEL), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.CHROME), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectIgnition);
    }, dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)CHROME, (IBeeDefinition)STEEL, 9);
        mutation.requireResource("blockStainlessSteel");
    }),
    URANIUM(GTBranchDefinition.GT_RADIOACTIVE, "Ouranos", true, 1683225, 1482262, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.URANIUM), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setNocturnal();
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)BeeDefinition.AVENGING, (IBeeDefinition)PLATINUM, 2);
        mutation.requireResource("blockUranium");
    }),
    PLUTONIUM(GTBranchDefinition.GT_RADIOACTIVE, "Plutos", true, 0x570000, 0x240000, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.LEAD), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.PLUTONIUM), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)URANIUM, (IBeeDefinition)EMERALD, 2);
        mutation.requireResource("blockPlutonium");
    }),
    NAQUADAH(GTBranchDefinition.GT_RADIOACTIVE, "Nasquis", false, 13056, 9216, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.NAQUADAH), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)PLUTONIUM, (IBeeDefinition)IRIDIUM, 1);
        mutation.requireResource("blockNaquadah");
    }),
    NAQUADRIA(GTBranchDefinition.GT_RADIOACTIVE, "Nasquidrius", false, 0, 9216, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.SLAG), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.NAQUADAH), Float.valueOf(0.2f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.NAQUADRIA), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)PLUTONIUM, (IBeeDefinition)IRIDIUM, 1);
        mutation.requireResource("blockNaquadria");
    }),
    TRINIUM(GTBranchDefinition.GT_RADIOACTIVE, "Trinium", false, 11591910, 13158610, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.TRINIUM), Float.valueOf(0.75f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.NAQUADAH), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAllele)GTAlleleBeeSpecies.speedBlinding), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)IRIDIUM, (IBeeDefinition)NAQUADAH, 4);
        mutation.requireResource("blockTrinium");
    }),
    THORIUM(GTBranchDefinition.GT_RADIOACTIVE, "Thorax", false, 20480, 7680, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.THORIUM), Float.valueOf(0.75f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.COLD);
        beeSpecies.setNocturnal();
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IMutationBuilder mutation = dis.registerMutation((IBeeDefinition)COAL, (IBeeDefinition)URANIUM, 2).setIsSecret();
        mutation.requireResource("blockThorium");
    }),
    LUTETIUM(GTBranchDefinition.GT_RADIOACTIVE, "Lutetia", false, 43775, 23039, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.LUTETIUM), Float.valueOf(0.15f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IBeeMutationBuilder mutation = Loader.isModLoaded((String)"extrabees") ? dis.registerMutation((IBeeDefinition)THORIUM, ForestryUtil.getSpecies("extrabees", "rotten"), 1) : dis.registerMutation((IBeeDefinition)THORIUM, (IBeeDefinition)BeeDefinition.IMPERIAL, 1);
        mutation.setIsSecret();
        mutation.requireResource("blockLutetium");
    }),
    AMERICIUM(GTBranchDefinition.GT_RADIOACTIVE, "Libertas", false, 2652265, 804154, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.AMERICIUM), Float.valueOf(0.05f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
    }, dis -> {
        IMutationBuilder mutation = dis.registerMutation((IBeeDefinition)LUTETIUM, (IBeeDefinition)CHROME, 1).setIsSecret();
        mutation.requireResource("blockAmericium");
    }),
    NEUTRONIUM(GTBranchDefinition.GT_RADIOACTIVE, "Media", false, 0xFFF0F0, 0xFAFAFA, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.NEUTRONIUM), Float.valueOf(1.0E-4f));
        beeSpecies.setHumidity(EnumHumidity.DAMP);
        beeSpecies.setTemperature(EnumTemperature.HELLISH);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
    }, dis -> {
        IMutationBuilder mutation = dis.registerMutation((IBeeDefinition)NAQUADRIA, (IBeeDefinition)AMERICIUM, 1).setIsSecret();
        mutation.requireResource(new UnificationEntry(OrePrefix.block, Materials.Neutronium).toString());
    }),
    HELIUM(GTBranchDefinition.GT_NOBLEGAS, "Helium", false, 0xFFA9FF, 13154484, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.HELIUM), Float.valueOf(0.35f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationBuilder mutation = Loader.isModLoaded((String)"magicbees") ? dis.registerMutation((IBeeDefinition)STAINLESSSTEEL, ForestryUtil.getSpecies("magicbees", "Watery"), 10) : dis.registerMutation((IBeeDefinition)STAINLESSSTEEL, (IBeeDefinition)BeeDefinition.INDUSTRIOUS, 10);
        mutation.restrictTemperature(EnumTemperature.ICY);
    }),
    ARGON(GTBranchDefinition.GT_NOBLEGAS, "Argon", false, 9034209, 12428738, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.ARGON), Float.valueOf(0.35f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationBuilder mutation = Loader.isModLoaded((String)"magicbees") ? dis.registerMutation((IBeeDefinition)HELIUM, ForestryUtil.getSpecies("magicbees", "Supernatural"), 8) : dis.registerMutation((IBeeDefinition)HELIUM, (IBeeDefinition)BeeDefinition.IMPERIAL, 8);
        mutation.restrictTemperature(EnumTemperature.ICY);
    }),
    NEON(GTBranchDefinition.GT_NOBLEGAS, "Novum", false, 16762918, 16740864, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.NEON), Float.valueOf(0.35f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)ARGON, (IBeeDefinition)IRON, 6);
        mutation.restrictTemperature(EnumTemperature.ICY);
    }),
    KRYPTON(GTBranchDefinition.GT_NOBLEGAS, "Kryptos", false, 9082800, 1443874, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.KRYPTON), Float.valueOf(0.35f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationBuilder mutation = Loader.isModLoaded((String)"magicbees") ? dis.registerMutation((IBeeDefinition)NEON, ForestryUtil.getSpecies("magicbees", "Supernatural"), 4) : dis.registerMutation((IBeeDefinition)NEON, (IBeeDefinition)BeeDefinition.AVENGING, 4);
        mutation.restrictTemperature(EnumTemperature.ICY);
    }),
    XENON(GTBranchDefinition.GT_NOBLEGAS, "Hostis", false, 9082800, 1443874, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.XENON), Float.valueOf(0.525f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)KRYPTON, (IBeeDefinition)BeeDefinition.EDENIC, 2);
        mutation.restrictTemperature(EnumTemperature.ICY);
    }),
    OXYGEN(GTBranchDefinition.GT_NOBLEGAS, "Oxygeni", false, 0xFFFFFF, 0x8F8FFF, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.OXYGEN), Float.valueOf(0.45f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.HYDROGEN), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)HELIUM, (IBeeDefinition)BeeDefinition.ENDED, 15);
        mutation.restrictTemperature(EnumTemperature.ICY);
    }),
    HYDROGEN(GTBranchDefinition.GT_NOBLEGAS, "Hydrogenium", false, 0xFFFFFF, 16716947, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.HYDROGEN), Float.valueOf(0.45f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.NITROGEN), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationBuilder mutation = Loader.isModLoaded((String)"magicbees") ? dis.registerMutation((IBeeDefinition)OXYGEN, ForestryUtil.getSpecies("magicbees", "Watery"), 15) : dis.registerMutation((IBeeDefinition)OXYGEN, (IBeeDefinition)BeeDefinition.INDUSTRIOUS, 15);
        mutation.restrictTemperature(EnumTemperature.ICY);
    }),
    NITROGEN(GTBranchDefinition.GT_NOBLEGAS, "Nitrogenium", false, 16762930, 0xA52A2A, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.NITROGEN), Float.valueOf(0.45f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.FLUORINE), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)OXYGEN, (IBeeDefinition)HYDROGEN, 15);
        mutation.restrictTemperature(EnumTemperature.ICY);
    }),
    FLUORINE(GTBranchDefinition.GT_NOBLEGAS, "Fluens", false, 8826864, 16739584, beeSpecies -> {
        beeSpecies.addProduct(GTBeeDefinition.getGTComb(GTCombType.FLUORINE), Float.valueOf(0.45f));
        beeSpecies.addSpecialty(GTBeeDefinition.getGTComb(GTCombType.OXYGEN), Float.valueOf(0.2f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.ICY);
        beeSpecies.setNocturnal();
        beeSpecies.setHasEffect();
    }, template -> AlleleHelper.getInstance().set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST), dis -> {
        IBeeMutationBuilder mutation = dis.registerMutation((IBeeDefinition)NITROGEN, (IBeeDefinition)HYDROGEN, 15);
        mutation.restrictTemperature(EnumTemperature.ICY);
    });

    private final GTBranchDefinition branch;
    private final GTAlleleBeeSpecies species;
    private final Consumer<GTAlleleBeeSpecies> speciesProperties;
    private final Consumer<IAllele[]> alleles;
    private final Consumer<GTBeeDefinition> mutations;
    private IAllele[] template;
    private IBeeGenome genome;
    private final Supplier<Boolean> generationCondition;

    private GTBeeDefinition(GTBranchDefinition branch, String binomial, boolean dominant, int primary, int secondary, Consumer<GTAlleleBeeSpecies> speciesProperties, Consumer<IAllele[]> alleles, Consumer<GTBeeDefinition> mutations) {
        this(branch, binomial, dominant, primary, secondary, speciesProperties, alleles, mutations, () -> true);
    }

    private GTBeeDefinition(GTBranchDefinition branch, String binomial, boolean dominant, int primary, int secondary, Consumer<GTAlleleBeeSpecies> speciesProperties, Consumer<IAllele[]> alleles, Consumer<GTBeeDefinition> mutations, Supplier<Boolean> generationCondition) {
        this.alleles = alleles;
        this.mutations = mutations;
        this.speciesProperties = speciesProperties;
        String lowercaseName = this.toString().toLowerCase(Locale.ENGLISH);
        String species = WordUtils.capitalize((String)lowercaseName);
        String uid = "gregtech.bee.species" + species;
        String description = "for.bees.description." + lowercaseName;
        String name = "for.bees.species." + lowercaseName;
        this.branch = branch;
        this.species = new GTAlleleBeeSpecies("gregtech", uid, name, "GregTech", description, dominant, branch.getBranch(), binomial, primary, secondary);
        this.generationCondition = generationCondition;
    }

    public static void initBees() {
        for (GTBeeDefinition bee : GTBeeDefinition.values()) {
            bee.init();
        }
        for (GTBeeDefinition bee : GTBeeDefinition.values()) {
            bee.registerMutations();
        }
    }

    private static ItemStack getForestryComb(EnumHoneyComb type) {
        return ModuleApiculture.getItems().beeComb.get(type, 1);
    }

    @Optional.Method(modid="extrabees")
    private static ItemStack getExtraBeesComb(int meta) {
        return IntegrationUtil.getModItem("extrabees", "honey_comb", meta);
    }

    @Optional.Method(modid="magicbees")
    private static ItemStack getMagicBeesComb(int meta) {
        return IntegrationUtil.getModItem("magicbees", "beecomb", meta);
    }

    private static ItemStack getGTComb(GTCombType type) {
        return new ItemStack((Item)ForestryModule.COMBS, 1, type.ordinal());
    }

    private void setSpeciesProperties(GTAlleleBeeSpecies beeSpecies) {
        this.speciesProperties.accept(beeSpecies);
    }

    private void setAlleles(IAllele[] template) {
        this.alleles.accept(template);
    }

    private void registerMutations() {
        if (this.generationCondition.get().booleanValue()) {
            this.mutations.accept(this);
        }
    }

    private void init() {
        if (this.generationCondition.get().booleanValue()) {
            this.setSpeciesProperties(this.species);
            this.template = this.branch.getTemplate();
            AlleleHelper.getInstance().set(this.template, (Enum)EnumBeeChromosome.SPECIES, (IAllele)this.species);
            this.setAlleles(this.template);
            this.genome = BeeManager.beeRoot.templateAsGenome(this.template);
            BeeManager.beeRoot.registerTemplate(this.template);
        }
    }

    private IBeeMutationBuilder registerMutation(IBeeDefinition parent1, IBeeDefinition parent2, int chance) {
        return this.registerMutation(parent1.getGenome().getPrimary(), parent2.getGenome().getPrimary(), chance);
    }

    private IBeeMutationBuilder registerMutation(IAlleleBeeSpecies parent1, IBeeDefinition parent2, int chance) {
        return this.registerMutation(parent1, parent2.getGenome().getPrimary(), chance);
    }

    private IBeeMutationBuilder registerMutation(IBeeDefinition parent1, IAlleleBeeSpecies parent2, int chance) {
        return this.registerMutation(parent1.getGenome().getPrimary(), parent2, chance);
    }

    private IBeeMutationBuilder registerMutation(IAlleleBeeSpecies parent1, IAlleleBeeSpecies parent2, int chance) {
        return BeeManager.beeMutationFactory.createMutation(parent1, parent2, this.getTemplate(), chance);
    }

    public final IAllele @NotNull [] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    @NotNull
    public final IBeeGenome getGenome() {
        return this.genome;
    }

    @NotNull
    public final IBee getIndividual() {
        return new Bee(this.genome);
    }

    @NotNull
    public final ItemStack getMemberStack(@NotNull EnumBeeType beeType) {
        return BeeManager.beeRoot.getMemberStack((IIndividual)this.getIndividual(), (ISpeciesType)beeType);
    }
}

