/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.forestry.bees;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.arboriculture.ModuleArboriculture;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.core.fluids.Fluids;
import forestry.lepidopterology.ModuleLepidopterology;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.machines.IScannerRecipeMap;
import gregtech.integration.forestry.ForestryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class ForestryScannerLogic
implements IScannerRecipeMap.ICustomScannerLogic {
    private static final int EUT = 2;
    private static final int DURATION = 500;
    private static final int HONEY_AMOUNT = 100;

    @Override
    public Recipe createCustomRecipe(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, boolean exactVoltage) {
        FluidStack fluidStack = fluidInputs.get(0);
        if (fluidStack != null && fluidStack.containsFluid(Fluids.FOR_HONEY.getFluid(100))) {
            for (ItemStack stack : inputs) {
                IIndividual individual;
                if (stack == ItemStack.field_190927_a || (individual = AlleleManager.alleleRegistry.getIndividual(stack)) == null || !individual.analyze()) continue;
                NBTTagCompound outputNBT = new NBTTagCompound();
                individual.writeToNBT(outputNBT);
                ItemStack outputStack = stack.func_77946_l();
                outputStack.func_77982_d(outputNBT);
                return ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SCANNER_RECIPES.recipeBuilder().inputs(stack)).fluidInputs(Fluids.FOR_HONEY.getFluid(100))).outputs(outputStack)).duration(500)).EUt(2)).build().getResult();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public List<Recipe> getRepresentativeRecipes() {
        ItemStack outputStack;
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        if (ForestryUtil.apicultureEnabled()) {
            outputStack = ModuleApiculture.getItems().beeDroneGE.getItemStack();
            outputStack.func_77982_d(BeeDefinition.COMMON.getIndividual().writeToNBT(new NBTTagCompound()));
            outputStack.func_190924_f("gregtech.scanner.forestry.drone");
            recipes.add(((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SCANNER_RECIPES.recipeBuilder().inputs(ModuleApiculture.getItems().beeDroneGE.getWildcard())).fluidInputs(Fluids.FOR_HONEY.getFluid(100))).outputs(outputStack)).duration(500)).EUt(2)).build().getResult());
            outputStack = ModuleApiculture.getItems().beePrincessGE.getItemStack();
            outputStack.func_77982_d(BeeDefinition.COMMON.getIndividual().writeToNBT(new NBTTagCompound()));
            outputStack.func_190924_f("gregtech.scanner.forestry.princess");
            recipes.add(((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SCANNER_RECIPES.recipeBuilder().inputs(ModuleApiculture.getItems().beePrincessGE.getWildcard())).fluidInputs(Fluids.FOR_HONEY.getFluid(100))).outputs(outputStack)).duration(500)).EUt(2)).build().getResult());
            outputStack = ModuleApiculture.getItems().beeQueenGE.getItemStack();
            outputStack.func_77982_d(BeeDefinition.COMMON.getIndividual().writeToNBT(new NBTTagCompound()));
            outputStack.func_190924_f("gregtech.scanner.forestry.queen");
            recipes.add(((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SCANNER_RECIPES.recipeBuilder().inputs(ModuleApiculture.getItems().beeQueenGE.getWildcard())).fluidInputs(Fluids.FOR_HONEY.getFluid(100))).outputs(outputStack)).duration(500)).EUt(2)).build().getResult());
            outputStack = ModuleApiculture.getItems().beeLarvaeGE.getItemStack();
            outputStack.func_77982_d(BeeDefinition.COMMON.getIndividual().writeToNBT(new NBTTagCompound()));
            outputStack.func_190924_f("gregtech.scanner.forestry.larvae");
            recipes.add(((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SCANNER_RECIPES.recipeBuilder().inputs(ModuleApiculture.getItems().beeLarvaeGE.getWildcard())).fluidInputs(Fluids.FOR_HONEY.getFluid(100))).outputs(outputStack)).duration(500)).EUt(2)).build().getResult());
        }
        if (ForestryUtil.arboricultureEnabled()) {
            outputStack = ModuleArboriculture.getItems().sapling.getItemStack();
            outputStack.func_77982_d(TreeDefinition.Oak.getIndividual().writeToNBT(new NBTTagCompound()));
            outputStack.func_190924_f("gregtech.scanner.forestry.sapling");
            recipes.add(((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SCANNER_RECIPES.recipeBuilder().inputs(ModuleArboriculture.getItems().sapling.getWildcard())).fluidInputs(Fluids.FOR_HONEY.getFluid(100))).outputs(outputStack)).duration(500)).EUt(2)).build().getResult());
            outputStack = ModuleArboriculture.getItems().pollenFertile.getItemStack();
            outputStack.func_77982_d(TreeDefinition.Oak.getIndividual().writeToNBT(new NBTTagCompound()));
            outputStack.func_190924_f("gregtech.scanner.forestry.pollen");
            recipes.add(((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SCANNER_RECIPES.recipeBuilder().inputs(ModuleArboriculture.getItems().pollenFertile.getWildcard())).fluidInputs(Fluids.FOR_HONEY.getFluid(100))).outputs(outputStack)).duration(500)).EUt(2)).build().getResult());
        }
        if (ForestryUtil.lepidopterologyEnabled()) {
            outputStack = ModuleLepidopterology.getItems().butterflyGE.getItemStack();
            outputStack.func_77982_d(ButterflyDefinition.CabbageWhite.getIndividual().writeToNBT(new NBTTagCompound()));
            outputStack.func_190924_f("gregtech.scanner.forestry.butterfly");
            recipes.add(((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SCANNER_RECIPES.recipeBuilder().inputs(ModuleLepidopterology.getItems().butterflyGE.getWildcard())).fluidInputs(Fluids.FOR_HONEY.getFluid(100))).outputs(outputStack)).duration(500)).EUt(2)).build().getResult());
            outputStack = ModuleLepidopterology.getItems().serumGE.getItemStack();
            outputStack.func_77982_d(ButterflyDefinition.CabbageWhite.getIndividual().writeToNBT(new NBTTagCompound()));
            outputStack.func_190924_f("gregtech.scanner.forestry.serum");
            recipes.add(((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SCANNER_RECIPES.recipeBuilder().inputs(ModuleLepidopterology.getItems().serumGE.getWildcard())).fluidInputs(Fluids.FOR_HONEY.getFluid(100))).outputs(outputStack)).duration(500)).EUt(2)).build().getResult());
            outputStack = ModuleLepidopterology.getItems().caterpillarGE.getItemStack();
            outputStack.func_77982_d(ButterflyDefinition.CabbageWhite.getIndividual().writeToNBT(new NBTTagCompound()));
            outputStack.func_190924_f("gregtech.scanner.forestry.caterpillar");
            recipes.add(((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.SCANNER_RECIPES.recipeBuilder().inputs(ModuleLepidopterology.getItems().caterpillarGE.getWildcard())).fluidInputs(Fluids.FOR_HONEY.getFluid(100))).outputs(outputStack)).duration(500)).EUt(2)).build().getResult());
        }
        return recipes;
    }
}

