/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.forestry;

import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleFlowers;
import forestry.modules.ModuleHelper;
import gregtech.integration.IntegrationModule;
import gregtech.integration.forestry.ForestryConfig;
import gregtech.integration.forestry.ForestryModule;
import gregtech.integration.forestry.bees.GTCombType;
import gregtech.integration.forestry.bees.GTDropType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForestryUtil {
    public static boolean apicultureEnabled() {
        return ModuleHelper.isEnabled((String)"apiculture");
    }

    public static boolean arboricultureEnabled() {
        return ModuleHelper.isEnabled((String)"arboriculture");
    }

    public static boolean lepidopterologyEnabled() {
        return ModuleHelper.isEnabled((String)"lepidopterology");
    }

    @Nullable
    public static IAlleleBeeEffect getEffect(@NotNull String modid, @NotNull String name) {
        String string;
        switch (modid) {
            case "extrabees": {
                string = "extrabees.effect." + name;
                break;
            }
            case "magicbees": {
                string = "magicbees.effect" + name;
                break;
            }
            case "gregtech": {
                string = "gregtech.effect." + name;
                break;
            }
            default: {
                string = "forestry.effect" + name;
            }
        }
        String s = string;
        return (IAlleleBeeEffect)AlleleManager.alleleRegistry.getAllele(s);
    }

    @Nullable
    public static IAlleleFlowers getFlowers(@NotNull String modid, @NotNull String name) {
        String string;
        switch (modid) {
            case "extrabees": {
                string = "extrabees.flower." + name;
                break;
            }
            case "magicbees": {
                string = "magicbees.flower" + name;
                break;
            }
            case "gregtech": {
                string = "gregtech.flower." + name;
                break;
            }
            default: {
                string = "forestry.flowers" + name;
            }
        }
        String s = string;
        return (IAlleleFlowers)AlleleManager.alleleRegistry.getAllele(s);
    }

    @Nullable
    public static IAlleleBeeSpecies getSpecies(@NotNull String modid, @NotNull String name) {
        String string;
        switch (modid) {
            case "extrabees": {
                string = "extrabees.species." + name;
                break;
            }
            case "magicbees": {
                string = "magicbees.species" + name;
                break;
            }
            case "gregtech": {
                string = "gregtech.species." + name;
                break;
            }
            default: {
                string = "forestry.species" + name;
            }
        }
        String s = string;
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(s);
    }

    @NotNull
    public static ItemStack getCombStack(@NotNull GTCombType type) {
        return ForestryUtil.getCombStack(type, 1);
    }

    @NotNull
    public static ItemStack getCombStack(@NotNull GTCombType type, int amount) {
        if (!ForestryConfig.enableGTBees) {
            IntegrationModule.logger.error("Tried to get GregTech Comb stack, but GregTech Bees config is not enabled!");
            return ItemStack.field_190927_a;
        }
        if (!ForestryUtil.apicultureEnabled()) {
            IntegrationModule.logger.error("Tried to get GregTech Comb stack, but Apiculture module is not enabled!");
            return ItemStack.field_190927_a;
        }
        return new ItemStack((Item)ForestryModule.COMBS, amount, type.ordinal());
    }

    @NotNull
    public static ItemStack getDropStack(@NotNull GTDropType type) {
        return ForestryUtil.getDropStack(type, 1);
    }

    @NotNull
    public static ItemStack getDropStack(@NotNull GTDropType type, int amount) {
        if (!ForestryConfig.enableGTBees) {
            IntegrationModule.logger.error("Tried to get GregTech Drop stack, but GregTech Bees config is not enabled!");
            return ItemStack.field_190927_a;
        }
        if (!ForestryUtil.apicultureEnabled()) {
            IntegrationModule.logger.error("Tried to get GregTech Drop stack, but Apiculture module is not enabled!");
            return ItemStack.field_190927_a;
        }
        return new ItemStack((Item)ForestryModule.DROPS, amount, type.ordinal());
    }
}

