/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.forestry;

import forestry.api.core.ForestryAPI;
import forestry.core.items.IColoredItem;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.StandardMetaItem;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.items.toolitem.ItemGTTool;
import gregtech.api.modules.GregTechModule;
import gregtech.api.recipes.machines.RecipeMapScanner;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.event.MaterialEvent;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.OreProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.items.ToolItems;
import gregtech.integration.IntegrationModule;
import gregtech.integration.IntegrationSubmodule;
import gregtech.integration.forestry.ForestryConfig;
import gregtech.integration.forestry.ForestryUtil;
import gregtech.integration.forestry.bees.BeeRemovals;
import gregtech.integration.forestry.bees.ForestryScannerLogic;
import gregtech.integration.forestry.bees.GTAlleleBeeSpecies;
import gregtech.integration.forestry.bees.GTBeeDefinition;
import gregtech.integration.forestry.bees.GTCombItem;
import gregtech.integration.forestry.bees.GTDropItem;
import gregtech.integration.forestry.frames.GTFrameType;
import gregtech.integration.forestry.frames.GTItemFrame;
import gregtech.integration.forestry.recipes.CombRecipes;
import gregtech.integration.forestry.recipes.ForestryElectrodeRecipes;
import gregtech.integration.forestry.recipes.ForestryExtractorRecipes;
import gregtech.integration.forestry.recipes.ForestryFrameRecipes;
import gregtech.integration.forestry.recipes.ForestryMiscRecipes;
import gregtech.integration.forestry.recipes.ForestryToolRecipes;
import gregtech.integration.forestry.tools.ScoopBehavior;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

@GregTechModule(moduleID="fr_integration", containerID="gregtech", modDependencies={"forestry"}, name="GregTech Forestry Integration", description="Forestry Integration Module")
public class ForestryModule
extends IntegrationSubmodule {
    private static MetaItem<?> forestryMetaItem;
    public static GTItemFrame FRAME_ACCELERATED;
    public static GTItemFrame FRAME_MUTAGENIC;
    public static GTItemFrame FRAME_WORKING;
    public static GTItemFrame FRAME_DECAYING;
    public static GTItemFrame FRAME_SLOWING;
    public static GTItemFrame FRAME_STABILIZING;
    public static GTItemFrame FRAME_ARBORIST;
    public static MetaItem.MetaValueItem ELECTRODE_APATITE;
    public static MetaItem.MetaValueItem ELECTRODE_BLAZE;
    public static MetaItem.MetaValueItem ELECTRODE_BRONZE;
    public static MetaItem.MetaValueItem ELECTRODE_COPPER;
    public static MetaItem.MetaValueItem ELECTRODE_DIAMOND;
    public static MetaItem.MetaValueItem ELECTRODE_EMERALD;
    public static MetaItem.MetaValueItem ELECTRODE_ENDER;
    public static MetaItem.MetaValueItem ELECTRODE_GOLD;
    public static MetaItem.MetaValueItem ELECTRODE_IRON;
    public static MetaItem.MetaValueItem ELECTRODE_LAPIS;
    public static MetaItem.MetaValueItem ELECTRODE_OBSIDIAN;
    public static MetaItem.MetaValueItem ELECTRODE_ORCHID;
    public static MetaItem.MetaValueItem ELECTRODE_RUBBER;
    public static MetaItem.MetaValueItem ELECTRODE_TIN;
    public static IGTTool SCOOP;
    public static GTDropItem DROPS;
    public static GTCombItem COMBS;

    @Override
    @NotNull
    public List<Class<?>> getEventBusSubscribers() {
        return Collections.singletonList(ForestryModule.class);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        forestryMetaItem = new StandardMetaItem();
        forestryMetaItem.setRegistryName("forestry_meta_item");
        if (ForestryConfig.enableGTFrames) {
            if (ForestryUtil.apicultureEnabled()) {
                FRAME_ACCELERATED = new GTItemFrame(GTFrameType.ACCELERATED);
                FRAME_MUTAGENIC = new GTItemFrame(GTFrameType.MUTAGENIC);
                FRAME_WORKING = new GTItemFrame(GTFrameType.WORKING);
                FRAME_DECAYING = new GTItemFrame(GTFrameType.DECAYING);
                FRAME_SLOWING = new GTItemFrame(GTFrameType.SLOWING);
                FRAME_STABILIZING = new GTItemFrame(GTFrameType.STABILIZING);
                FRAME_ARBORIST = new GTItemFrame(GTFrameType.ARBORIST);
            } else {
                this.getLogger().warn("GregTech Frames are enabled, but Forestry Apiculture module is disabled. Skipping...");
            }
        }
        if (ForestryConfig.enableGTScoop) {
            SCOOP = ToolItems.register(ItemGTTool.Builder.of("gregtech", "scoop").toolStats(b -> b.cannotAttack().attackSpeed(-2.4f).behaviors(ScoopBehavior.INSTANCE)).toolClasses("scoop").oreDict("toolScoop"));
        }
        if (ForestryConfig.enableGTBees) {
            if (ForestryUtil.apicultureEnabled()) {
                DROPS = new GTDropItem();
                COMBS = new GTCombItem();
            } else {
                this.getLogger().warn("GregTech Bees are enabled, but Forestry Apiculture module is disabled. Skipping...");
            }
        }
        if (ForestryConfig.disableConflictingBees && ForestryUtil.apicultureEnabled()) {
            BeeRemovals.init();
        }
        RecipeMapScanner.registerCustomScannerLogic(new ForestryScannerLogic());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (ForestryConfig.enableGTElectronTubes) {
            ForestryElectrodeRecipes.onInit();
        }
        if (ForestryUtil.apicultureEnabled()) {
            if (ForestryConfig.harderForestryRecipes) {
                ForestryMiscRecipes.initRemoval();
            }
            if (ForestryConfig.enableGTBees) {
                GTAlleleBeeSpecies.setupAlleles();
                GTBeeDefinition.initBees();
            }
        }
        if (Loader.isModLoaded((String)"extrabees")) {
            ForestryModule.registerAlvearyMutators();
        }
        if (event.getSide() == Side.CLIENT && ForestryUtil.apicultureEnabled() && ForestryConfig.enableGTBees) {
            Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> {
                Item patt7582$temp = stack.func_77973_b();
                if (patt7582$temp instanceof IColoredItem) {
                    IColoredItem coloredItem = (IColoredItem)patt7582$temp;
                    return coloredItem.getColorFromItemstack(stack, tintIndex);
                }
                return 0xFFFFFF;
            }, new Item[]{DROPS, COMBS});
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        if (ForestryUtil.apicultureEnabled()) {
            this.getLogger().info("Copying Forestry Centrifuge recipes to GT Centrifuge");
            CombRecipes.initForestryCombs();
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        if (ForestryUtil.apicultureEnabled() && ForestryConfig.enableGTFrames) {
            registry.register((IForgeRegistryEntry)FRAME_ACCELERATED);
            registry.register((IForgeRegistryEntry)FRAME_MUTAGENIC);
            registry.register((IForgeRegistryEntry)FRAME_WORKING);
            registry.register((IForgeRegistryEntry)FRAME_DECAYING);
            registry.register((IForgeRegistryEntry)FRAME_SLOWING);
            registry.register((IForgeRegistryEntry)FRAME_STABILIZING);
            registry.register((IForgeRegistryEntry)FRAME_ARBORIST);
        }
        if (ForestryConfig.enableGTElectronTubes) {
            ELECTRODE_APATITE = forestryMetaItem.addItem(1, "electrode.apatite");
            ELECTRODE_BLAZE = forestryMetaItem.addItem(2, "electrode.blaze");
            ELECTRODE_BRONZE = forestryMetaItem.addItem(3, "electrode.bronze");
            ELECTRODE_COPPER = forestryMetaItem.addItem(4, "electrode.copper");
            ELECTRODE_DIAMOND = forestryMetaItem.addItem(5, "electrode.diamond");
            ELECTRODE_EMERALD = forestryMetaItem.addItem(6, "electrode.emerald");
            ELECTRODE_ENDER = forestryMetaItem.addItem(7, "electrode.ender");
            ELECTRODE_GOLD = forestryMetaItem.addItem(8, "electrode.gold");
            ELECTRODE_LAPIS = forestryMetaItem.addItem(9, "electrode.lapis");
            ELECTRODE_OBSIDIAN = forestryMetaItem.addItem(10, "electrode.obsidian");
            ELECTRODE_TIN = forestryMetaItem.addItem(11, "electrode.tin");
            if (Loader.isModLoaded((String)"ic2") || Loader.isModLoaded((String)"binniecore")) {
                ELECTRODE_IRON = forestryMetaItem.addItem(12, "electrode.iron");
            }
            if (Loader.isModLoaded((String)"extrautils2")) {
                ELECTRODE_ORCHID = forestryMetaItem.addItem(13, "electrode.orchid");
            }
            if (Loader.isModLoaded((String)"ic2") || Loader.isModLoaded((String)"techreborn") || Loader.isModLoaded((String)"binniecore")) {
                ELECTRODE_RUBBER = forestryMetaItem.addItem(14, "electrode.rubber");
            }
        }
        if (ForestryUtil.apicultureEnabled() && ForestryConfig.enableGTBees) {
            registry.register((IForgeRegistryEntry)DROPS);
            registry.register((IForgeRegistryEntry)COMBS);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        if (ForestryUtil.apicultureEnabled()) {
            if (ForestryConfig.enableGTFrames) {
                FRAME_ACCELERATED.registerModel(FRAME_ACCELERATED, ForestryAPI.modelManager);
                FRAME_MUTAGENIC.registerModel(FRAME_MUTAGENIC, ForestryAPI.modelManager);
                FRAME_WORKING.registerModel(FRAME_WORKING, ForestryAPI.modelManager);
                FRAME_DECAYING.registerModel(FRAME_DECAYING, ForestryAPI.modelManager);
                FRAME_SLOWING.registerModel(FRAME_SLOWING, ForestryAPI.modelManager);
                FRAME_STABILIZING.registerModel(FRAME_STABILIZING, ForestryAPI.modelManager);
                FRAME_ARBORIST.registerModel(FRAME_ARBORIST, ForestryAPI.modelManager);
            }
            if (ForestryConfig.enableGTBees) {
                DROPS.registerModel(DROPS, ForestryAPI.modelManager);
                COMBS.registerModel(COMBS, ForestryAPI.modelManager);
            }
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (ForestryUtil.apicultureEnabled()) {
            if (ForestryConfig.enableGTFrames) {
                ForestryFrameRecipes.init();
            }
            if (ForestryConfig.enableGTBees) {
                CombRecipes.initGTCombs();
            }
        }
        if (ForestryConfig.enableGTElectronTubes) {
            ForestryElectrodeRecipes.onRecipeEvent();
        }
        if (ForestryConfig.enableGTScoop) {
            ForestryToolRecipes.registerHandlers();
        }
        ForestryMiscRecipes.init();
        ForestryExtractorRecipes.init();
    }

    @SubscribeEvent
    public static void registerMaterials(MaterialEvent event) {
        if (ForestryUtil.apicultureEnabled()) {
            if (ForestryConfig.enableGTFrames) {
                Materials.TreatedWood.addFlags(MaterialFlags.GENERATE_LONG_ROD);
                Materials.Uranium235.addFlags(MaterialFlags.GENERATE_LONG_ROD);
                Materials.Plutonium241.addFlags(MaterialFlags.GENERATE_LONG_ROD, MaterialFlags.GENERATE_FOIL);
                Materials.BlueSteel.addFlags(MaterialFlags.GENERATE_LONG_ROD);
            }
            if (ForestryConfig.enableGTElectronTubes) {
                Materials.Copper.addFlags(MaterialFlags.GENERATE_BOLT_SCREW);
                Materials.Emerald.addFlags(MaterialFlags.GENERATE_BOLT_SCREW);
                Materials.Lapis.addFlags(MaterialFlags.GENERATE_BOLT_SCREW);
            }
            if (ForestryConfig.enableGTBees) {
                Materials.Arsenic.addFlags(MaterialFlags.FORCE_GENERATE_BLOCK);
                Materials.Lithium.addFlags(MaterialFlags.FORCE_GENERATE_BLOCK);
                Materials.Electrotine.addFlags(MaterialFlags.FORCE_GENERATE_BLOCK);
                Materials.Lutetium.addFlags(MaterialFlags.FORCE_GENERATE_BLOCK);
                Materials.TricalciumPhosphate.addFlags(MaterialFlags.FORCE_GENERATE_BLOCK);
                ForestryModule.createOreProperty(Materials.Chrome, Materials.Iron, Materials.Magnesium);
                ForestryModule.createOreProperty(Materials.Manganese, Materials.Chrome, Materials.Iron);
                ForestryModule.createOreProperty(Materials.Magnesium, Materials.Olivine);
                ForestryModule.createOreProperty(Materials.Silicon, Materials.SiliconDioxide);
                ForestryModule.createOreProperty(Materials.Tungsten, Materials.Manganese, Materials.Molybdenum);
                ForestryModule.createOreProperty(Materials.Titanium, Materials.Almandine);
                ForestryModule.createOreProperty(Materials.Osmium, Materials.Iridium);
                ForestryModule.createOreProperty(Materials.Iridium, Materials.Platinum, Materials.Osmium);
                ForestryModule.createOreProperty(Materials.Electrum, Materials.Gold, Materials.Silver);
                ForestryModule.createOreProperty(Materials.Uranium238, Materials.Lead, Materials.Uranium235, Materials.Thorium);
                ForestryModule.createOreProperty(Materials.NaquadahEnriched, Materials.Naquadah, Materials.Naquadria);
                ForestryModule.createOreProperty(Materials.Uranium235, new Material[0]);
                ForestryModule.createOreProperty(Materials.Neutronium, new Material[0]);
                ForestryModule.createOreProperty(Materials.Gallium, new Material[0]);
                ForestryModule.createOreProperty(Materials.Niobium, new Material[0]);
                ForestryModule.createOreProperty(Materials.Rutile, new Material[0]);
                ForestryModule.createOreProperty(Materials.Naquadria, new Material[0]);
                ForestryModule.createOreProperty(Materials.Lutetium, new Material[0]);
                ForestryModule.createOreProperty(Materials.Americium, new Material[0]);
                ForestryModule.createOreProperty(Materials.NetherStar, new Material[0]);
                ForestryModule.createOreProperty(Materials.Trinium, new Material[0]);
            }
        }
    }

    private static void createOreProperty(Material material, Material ... byproducts) {
        if (material.hasProperty(PropertyKey.ORE)) {
            IntegrationModule.logger.debug("Material {} already has an ore property, skipping...", (Object)material);
            return;
        }
        OreProperty property = new OreProperty();
        if (byproducts != null && byproducts.length != 0) {
            property.setOreByProducts(byproducts);
        }
        material.setProperty(PropertyKey.ORE, property);
        material.addFlags(MaterialFlags.DISABLE_ORE_BLOCK);
    }

    private static void registerAlvearyMutators() {
        try {
            Class<?> mutationHandler = Class.forName("binnie.extrabees.utils.AlvearyMutationHandler");
            Method method = mutationHandler.getDeclaredMethod("addMutationItem", ItemStack.class, Float.TYPE);
            ForestryModule.registerAlvearyMutator(method, Materials.Uranium238, 2.0f);
            ForestryModule.registerAlvearyMutator(method, Materials.Uranium235, 4.0f);
            ForestryModule.registerAlvearyMutator(method, Materials.Plutonium241, 6.0f);
            ForestryModule.registerAlvearyMutator(method, Materials.Plutonium239, 8.0f);
            ForestryModule.registerAlvearyMutator(method, Materials.NaquadahEnriched, 10.0f);
            ForestryModule.registerAlvearyMutator(method, Materials.Naquadria, 15.0f);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            IntegrationModule.logger.error("Could not register GT Alveary mutators!");
        }
    }

    private static void registerAlvearyMutator(Method method, Material material, float chance) {
        try {
            ItemStack stack = OreDictUnifier.get(OrePrefix.dust, material);
            if (stack != ItemStack.field_190927_a) {
                method.invoke(null, stack, Float.valueOf(chance));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            IntegrationModule.logger.error("Could not register GT Alveary mutators!");
        }
    }
}

