/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.crafttweaker.terminal;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.terminal.hardware.Hardware;
import gregtech.api.util.GTLog;
import gregtech.common.terminal.hardware.BatteryHardware;
import gregtech.common.terminal.hardware.DeviceHardware;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.TerminalRegistry")
@ZenRegister
public class CTTerminalRegistry {
    private static List<CTAppRegistryBuilder> ctAppRegistryBuilders = new LinkedList<CTAppRegistryBuilder>();

    @ZenMethod
    public static CTAppRegistryBuilder createAppRegistryBuilder(String appName) {
        return new CTAppRegistryBuilder(appName);
    }

    @ZenMethod
    public static void registerDevice(IItemStack device, String name) {
        ItemStack itemStack = CraftTweakerMC.getItemStack((IItemStack)device).func_77946_l();
        if (!itemStack.func_190926_b()) {
            itemStack.func_190920_e(1);
            EnumHelper.addEnum(DeviceHardware.DEVICE.class, (String)name.toUpperCase(), (Class[])new Class[]{ItemStack.class, String.class}, (Object[])new Object[]{itemStack, name.toLowerCase()});
        }
    }

    public static void registerAPP(CTAppRegistryBuilder builder) {
        if (TerminalRegistry.APP_REGISTER.containsKey(builder.appName)) {
            int maxTier;
            if (builder.isDefaultApp != null) {
                TerminalRegistry.DEFAULT_APPS.remove(builder.appName);
                if (builder.isDefaultApp.booleanValue()) {
                    TerminalRegistry.DEFAULT_APPS.add(builder.appName);
                }
            }
            if (!builder.hardware.isEmpty()) {
                maxTier = TerminalRegistry.APP_HW_DEMAND.get(builder.appName).length;
                List[] hardware = new List[maxTier];
                for (int i = 0; i < maxTier; ++i) {
                    LinkedList<Hardware> list = new LinkedList<Hardware>();
                    if (builder.battery.containsKey(i)) {
                        list.add(builder.battery.get(i));
                    } else if (builder.battery.containsKey(-1)) {
                        list.add(builder.battery.get(-1));
                    }
                    if (builder.hardware.containsKey(i)) {
                        list.addAll((Collection)builder.hardware.get(i));
                    } else if (builder.hardware.containsKey(-1)) {
                        list.addAll((Collection)builder.hardware.get(-1));
                    }
                    if (list.size() <= 0) continue;
                    hardware[i] = list;
                }
                TerminalRegistry.APP_HW_DEMAND.put(builder.appName, hardware);
            }
            if (!builder.upgrade.isEmpty()) {
                maxTier = TerminalRegistry.APP_UPGRADE_CONDITIONS.get(builder.appName).length;
                Object[] upgrade = new List[maxTier];
                if (builder.upgrade.containsKey(-1)) {
                    Arrays.fill(upgrade, builder.upgrade.get(-1));
                }
                builder.upgrade.forEach((arg_0, arg_1) -> CTTerminalRegistry.lambda$registerAPP$0(maxTier, (List[])upgrade, arg_0, arg_1));
                TerminalRegistry.APP_UPGRADE_CONDITIONS.put(builder.appName, (List<ItemStack>[])upgrade);
            }
        } else {
            GTLog.logger.error("Not found the app {}, while load the CT script", (Object)builder.appName);
        }
    }

    public static void register() {
        ctAppRegistryBuilders.forEach(CTTerminalRegistry::registerAPP);
        ctAppRegistryBuilders = null;
    }

    private static /* synthetic */ void lambda$registerAPP$0(int maxTier, List[] upgrade, Integer tier, List listBuilder) {
        if (tier != -1 && tier < maxTier) {
            upgrade[tier.intValue()] = listBuilder;
        }
    }

    @ZenClass(value="mods.gregtech.AppRegistryBuilder")
    @ZenRegister
    public static class CTAppRegistryBuilder {
        final String appName;
        Boolean isDefaultApp;
        Map<Integer, BatteryHardware> battery;
        Map<Integer, List<Hardware>> hardware;
        Map<Integer, List<ItemStack>> upgrade;

        public CTAppRegistryBuilder(String appName) {
            this.appName = appName;
            this.battery = new HashMap<Integer, BatteryHardware>();
            this.hardware = new HashMap<Integer, List<Hardware>>();
            this.upgrade = new HashMap<Integer, List<ItemStack>>();
        }

        @ZenMethod
        public CTAppRegistryBuilder isDefaultApp(boolean isDefaultApp) {
            this.isDefaultApp = isDefaultApp;
            return this;
        }

        @ZenMethod
        public CTAppRegistryBuilder battery(int batteryTier, long cost) {
            this.battery.put(-1, new BatteryHardware.BatteryDemand(batteryTier, cost));
            return this;
        }

        @ZenMethod
        public CTAppRegistryBuilder battery(int tier, int batteryTier, long cost) {
            this.battery.put(tier, new BatteryHardware.BatteryDemand(batteryTier, cost));
            return this;
        }

        @ZenMethod
        public CTAppRegistryBuilder device(String ... device) {
            Hardware[] hw = (Hardware[])Arrays.stream(device).map(DeviceHardware.DeviceDemand::new).filter(deviceDemand -> deviceDemand.getDevice() != null).toArray(Hardware[]::new);
            this.hardware(hw);
            return this;
        }

        @ZenMethod
        public CTAppRegistryBuilder device(int tier, String ... device) {
            this.hardware(tier, (Hardware[])Arrays.stream(device).map(DeviceHardware.DeviceDemand::new).filter(deviceDemand -> deviceDemand.getDevice() != null).toArray(Hardware[]::new));
            return this;
        }

        private void hardware(Hardware ... hardware) {
            this.hardware(-1, hardware);
        }

        private void hardware(int tier, Hardware ... hardware) {
            this.hardware.put(tier, new LinkedList());
            for (Hardware hw : hardware) {
                this.hardware.get(tier).add(hw);
            }
        }

        @ZenMethod
        public CTAppRegistryBuilder upgrade(IItemStack ... upgrades) {
            this.upgrade(-1, upgrades);
            return this;
        }

        @ZenMethod
        public CTAppRegistryBuilder upgrade(int tier, IItemStack ... upgrades) {
            this.upgrade.put(tier, new LinkedList());
            for (ItemStack up : (ItemStack[])Arrays.stream(upgrades).map(CraftTweakerMC::getItemStack).filter(itemStack -> !itemStack.func_190926_b()).toArray(ItemStack[]::new)) {
                this.upgrade.get(tier).add(up);
            }
            return this;
        }

        @ZenMethod
        public void build() {
            if (ctAppRegistryBuilders == null) {
                CTTerminalRegistry.registerAPP(this);
            } else {
                ctAppRegistryBuilders.add(this);
            }
        }
    }
}

