/*
 * Decompiled with CFR 0.152.
 */
package gregtech.core.unification.material.internal;

import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.registry.MaterialRegistry;
import gregtech.core.CoreModule;
import gregtech.core.unification.material.internal.MaterialRegistryManager;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class MaterialRegistryImpl
extends MaterialRegistry {
    private static int networkIdCounter;
    private final int networkId = networkIdCounter++;
    private final String modid;
    private boolean isRegistryClosed = false;
    private Material fallbackMaterial = null;

    protected MaterialRegistryImpl(@NotNull String modid) {
        this.modid = modid;
    }

    @Override
    public void register(Material material) {
        this.register(material.getId(), material.toString(), material);
    }

    public void register(int id, @NotNull String key, @NotNull Material value) {
        if (this.isRegistryClosed) {
            CoreModule.logger.error("Materials cannot be registered in the PostMaterialEvent (or after)! Must be added in the MaterialEvent. Skipping material {}...", (Object)key);
            return;
        }
        super.func_177775_a(id, key, value);
    }

    @Override
    @NotNull
    public Collection<Material> getAllMaterials() {
        return Collections.unmodifiableCollection(this.field_82596_a.values());
    }

    @Override
    public void setFallbackMaterial(@NotNull Material material) {
        this.fallbackMaterial = material;
    }

    @Override
    @NotNull
    public Material getFallbackMaterial() {
        if (this.fallbackMaterial == null) {
            this.fallbackMaterial = MaterialRegistryManager.getInstance().getDefaultFallback();
        }
        return this.fallbackMaterial;
    }

    @Override
    public int getNetworkId() {
        return this.networkId;
    }

    @Override
    @NotNull
    public String getModid() {
        return this.modid;
    }

    public void closeRegistry() {
        this.isRegistryClosed = true;
    }
}

