/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.worldprospector.matcher;

import gregtech.common.terminal.app.worldprospector.matcher.IMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;

public class BlockStateMatcher
implements IMatcher {
    private final IBlockState reference;
    private final List<IProperty<?>> properties = new ArrayList();
    private final int meta;
    private final int color;

    public BlockStateMatcher(IBlockState state, int color) {
        this.reference = state;
        for (IProperty property : state.func_177227_a()) {
            if (!Objects.equals(property.func_177701_a(), "variant") && !Objects.equals(property.func_177701_a(), "type") && !Objects.equals(property.func_177701_a(), "ore") && !Objects.equals(property.func_177701_a(), "oretype") && !Objects.equals(property.func_177701_a(), "stone_type") && !Objects.equals(property.func_177701_a(), "basictype")) continue;
            this.properties.add(property);
        }
        this.meta = this.reference.func_177230_c().func_176201_c(this.reference);
        this.color = color;
    }

    @Override
    public boolean match(IBlockState state) {
        if (this.reference.func_177230_c() != state.func_177230_c()) {
            return false;
        }
        if (state.func_177230_c().func_176201_c(state) != this.meta) {
            return false;
        }
        if (this.properties.isEmpty()) {
            return true;
        }
        for (IProperty<?> property : this.properties) {
            if (!state.func_177227_a().contains(property) || Objects.equals(state.func_177229_b(property), this.reference.func_177229_b(property))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockStateMatcher) {
            return this.match(((BlockStateMatcher)obj).reference);
        }
        return super.equals(obj);
    }
}

