/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.recipechart.widget;

import gregtech.api.GTValues;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SimpleMachineMetaTileEntity;
import gregtech.api.terminal.gui.widgets.CircleButtonWidget;
import gregtech.api.terminal.os.TerminalDialogWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.util.GTUtility;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.common.terminal.app.recipechart.widget.RGContainer;
import gregtech.common.terminal.app.recipechart.widget.RGNode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec2f;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class RGLine
extends WidgetGroup {
    protected final RGNode parent;
    protected final RGNode child;
    protected final ItemStack catalyst;
    protected int ratio;
    private boolean isSelected;
    private final List<Vec2f> points;
    private final RGContainer container;
    private final WidgetGroup infoGroup;
    private final WidgetGroup toolGroup;

    public RGLine(RGNode parent, RGNode child, RGContainer container) {
        super(0, 0, 0, 0);
        this.parent = parent;
        this.child = child;
        this.container = container;
        this.points = new ArrayList<Vec2f>();
        this.catalyst = parent.catalyst;
        this.infoGroup = new WidgetGroup(0, 0, 0, 0);
        if (this.catalyst != null) {
            ItemStackHandler handler = new ItemStackHandler();
            handler.setStackInSlot(0, this.catalyst);
            this.infoGroup.addWidget(new SlotWidget((IItemHandler)handler, 0, 0, 0, false, false).setBackgroundTexture(new ColorRectTexture(0)));
            MetaTileEntity mte = GTUtility.getMetaTileEntity(this.catalyst);
            if (mte instanceof SimpleMachineMetaTileEntity) {
                this.infoGroup.addWidget(new LabelWidget(9, -10, I18n.func_135052_a((String)"terminal.recipe_chart.tier", (Object[])new Object[0]) + GTValues.VN[((SimpleMachineMetaTileEntity)mte).getTier()], -1).setXCentered(true).setShadow(true));
            }
        }
        this.infoGroup.setVisible(false);
        this.infoGroup.setActive(false);
        this.addWidget(this.infoGroup);
        this.toolGroup = new WidgetGroup(0, 0, 0, 0);
        this.toolGroup.addWidget(new CircleButtonWidget(-8, 0, 8, 1, 12).setColors(0, TerminalTheme.COLOR_7.getColor(), 0).setIcon(GuiTextures.ICON_VISIBLE).setHoverText("terminal.recipe_chart.visible").setClickListener(cd -> {
            this.infoGroup.setActive(!this.infoGroup.isActive());
            this.infoGroup.setVisible(!this.infoGroup.isVisible());
        }));
        this.toolGroup.addWidget(new CircleButtonWidget(8, 0, 8, 1, 12).setColors(0, TerminalTheme.COLOR_7.getColor(), 0).setIcon(GuiTextures.ICON_CALCULATOR).setHoverText("terminal.recipe_chart.ratio").setClickListener(cd -> TerminalDialogWidget.showTextFieldDialog(container.os, "terminal.recipe_chart.ratio", s -> {
            try {
                return Integer.parseInt(s) > 0;
            }
            catch (Exception ignored) {
                return false;
            }
        }, s -> {
            if (s != null) {
                this.ratio = Integer.parseInt(s);
                parent.updateDemand(parent.getHeadDemand());
            }
        }).setClientSide().open()));
        this.toolGroup.addWidget(new SimpleTextWidget(0, -18, "", -1, () -> Integer.toString(this.ratio), true).setShadow(true));
        this.toolGroup.setVisible(false);
        this.addWidget(this.toolGroup);
        this.ratio = 1;
        this.updateLine();
    }

    public static RGLine deserializeLineNBT(NBTTagCompound nbt, RGContainer container) {
        RGLine line = new RGLine(container.nodes.get(nbt.func_74762_e("parent")), container.nodes.get(nbt.func_74762_e("child")), container);
        line.ratio = nbt.func_74762_e("ratio");
        boolean visible = nbt.func_74767_n("visible");
        line.infoGroup.setVisible(visible);
        line.infoGroup.setActive(visible);
        return line;
    }

    public NBTTagCompound serializeLineNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("parent", this.container.nodes.indexOf(this.parent));
        nbt.func_74768_a("child", this.container.nodes.indexOf(this.child));
        nbt.func_74768_a("ratio", this.ratio);
        nbt.func_74757_a("visible", this.infoGroup.isVisible());
        return nbt;
    }

    public RGNode getParent() {
        return this.parent;
    }

    public RGNode getChild() {
        return this.child;
    }

    public List<Vec2f> getPoints() {
        return this.points;
    }

    public ItemStack getCatalyst() {
        return this.catalyst;
    }

    public void updateSelected(boolean isSelected) {
        this.isSelected = isSelected;
        this.toolGroup.setVisible(this.isSelected);
    }

    public void updateLine() {
        int y2;
        int x2;
        int y1;
        int x1;
        this.points.clear();
        Position pos1 = this.parent.getNodePosition(this.child);
        Position pos2 = this.child.getNodePosition(null);
        if (Math.abs(pos1.x - pos2.x) > Math.abs(pos1.y - pos2.y)) {
            if (pos1.x > pos2.x) {
                x1 = pos1.x;
                y1 = pos1.y + 9;
                x2 = pos2.x + 18;
            } else {
                x1 = pos1.x + 18;
                y1 = pos1.y + 9;
                x2 = pos2.x;
            }
            y2 = pos2.y + 9;
            this.points.addAll(RGLine.genBezierPoints(new Vec2f((float)x1, (float)y1), new Vec2f((float)x2, (float)y2), true, 0.01f));
        } else {
            if (pos1.y > pos2.y) {
                x1 = pos1.x + 9;
                y1 = pos1.y;
                y2 = pos2.y + 18;
            } else {
                x1 = pos1.x + 9;
                y1 = pos1.y + 18;
                y2 = pos2.y;
            }
            x2 = pos2.x + 9;
            this.points.addAll(RGLine.genBezierPoints(new Vec2f((float)x1, (float)y1), new Vec2f((float)x2, (float)y2), false, 0.01f));
        }
        Position position = pos2.subtract(this.child.getSelfPosition());
        this.setSelfPosition(new Position(Math.min(x1, x2), Math.min(y1, y2)).subtract(position));
        int width = Math.abs(x1 - x2);
        int height = Math.abs(y1 - y2);
        this.setSize(new Size(width, height));
        this.setVisible(true);
        this.setActive(true);
        this.toolGroup.setSelfPosition(new Position(width / 2, 0));
        this.infoGroup.setSelfPosition(new Position((width - 18) / 2, (height - 18) / 2));
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        if (this.points == null || this.points.size() == 0) {
            return false;
        }
        float x = this.points.get((int)0).field_189982_i;
        float y = this.points.get((int)0).field_189983_j;
        float x2 = this.points.get((int)(this.points.size() - 1)).field_189982_i;
        float y2 = this.points.get((int)(this.points.size() - 1)).field_189983_j;
        if ((float)mouseX >= Math.min(x, x2) && (float)mouseY >= Math.min(y, y2) && Math.max(x, x2) > (float)mouseX && Math.max(y, y2) > (float)mouseY) {
            for (Vec2f point : this.points) {
                if (!(((float)mouseX - point.field_189982_i) * ((float)mouseX - point.field_189982_i) + ((float)mouseY - point.field_189983_j) * ((float)mouseY - point.field_189983_j) < 4.0f)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        if (this.isSelected) {
            RGLine.drawSolidRect(this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height, 0x2FFFFFFF);
            RGLine.drawLines(this.points, 0x2FFF0000, -65536, 2.0f);
        } else {
            RGLine.drawLines(this.points, 0x2FFFFF00, -16711936, 2.0f);
        }
        Vec2f point = this.points.get(this.points.size() - 1);
        RGLine.drawSolidRect((int)((double)point.field_189982_i - 1.5), (int)((double)point.field_189983_j - 1.5), 3, 3, -16711936);
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isMouseOver(mouseX, mouseY)) {
            if (!this.isSelected) {
                this.container.setSelectedLine(this);
            }
        } else if (this.isSelected) {
            this.container.setSelectedLine(null);
        }
        return false;
    }
}

