/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.recipechart;

import gregtech.api.gui.Widget;
import gregtech.common.terminal.app.recipechart.FluidStackHelper;
import gregtech.common.terminal.app.recipechart.ItemStackHelper;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public interface IngredientHelper<T> {
    public static <T> IngredientHelper<T> getFor(Object o) {
        Objects.requireNonNull(o);
        if (o.getClass() == ItemStack.class) {
            return ItemStackHelper.INSTANCE;
        }
        if (o.getClass() == FluidStack.class) {
            return FluidStackHelper.INSTANCE;
        }
        throw new IllegalArgumentException();
    }

    public static IngredientHelper<?> getForTypeId(int type) {
        IngredientHelper<ItemStack> ingredientHelper;
        switch (type) {
            case 1: {
                ingredientHelper = ItemStackHelper.INSTANCE;
                break;
            }
            case 2: {
                ingredientHelper = FluidStackHelper.INSTANCE;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return ingredientHelper;
    }

    public byte getTypeId();

    public int getAmount(T var1);

    public void setAmount(T var1, int var2);

    public boolean areEqual(T var1, T var2);

    public boolean isEmpty(T var1);

    public String getDisplayName(T var1);

    public Widget createWidget(T var1);

    public T deserialize(NBTTagCompound var1);

    public NBTTagCompound serialize(T var1);
}

