/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.prospector.widget;

import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.ore.StoneType;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.FileUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.api.util.TextFormattingUtil;
import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinHandler;
import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.config.WorldGenRegistry;
import gregtech.api.worldgen.filler.FillerEntry;
import gregtech.common.terminal.app.prospector.ProspectingTexture;
import gregtech.common.terminal.app.prospector.ProspectorMode;
import gregtech.common.terminal.app.prospector.widget.WidgetOreList;
import gregtech.core.network.packets.PacketProspecting;
import gregtech.integration.xaero.ColorUtility;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import journeymap.client.model.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;

public class WidgetProspectingMap
extends Widget {
    private final int chunkRadius;
    private final WidgetOreList oreList;
    private final ProspectorMode mode;
    private final int scanTick;
    private boolean darkMode = false;
    private int chunkIndex = 0;
    @SideOnly(value=Side.CLIENT)
    private ProspectingTexture texture;
    @SideOnly(value=Side.CLIENT)
    private Consumer<PacketProspecting> onPacketReceived;
    private final Queue<PacketProspecting> packetQueue = new LinkedBlockingQueue<PacketProspecting>();
    private long lastClicked;
    private final List<String> hoveredNames = new ArrayList<String>();
    private int color;
    private final double[][] xaerosColors = new double[][]{ColorUtility.getLab(new Color(0, 0, 0)), ColorUtility.getLab(new Color(0, 0, 128)), ColorUtility.getLab(new Color(0, 128, 0)), ColorUtility.getLab(new Color(0, 128, 128)), ColorUtility.getLab(new Color(128, 0, 0)), ColorUtility.getLab(new Color(128, 0, 128)), ColorUtility.getLab(new Color(128, 128, 0)), ColorUtility.getLab(new Color(192, 192, 192)), ColorUtility.getLab(new Color(128, 128, 128)), ColorUtility.getLab(new Color(0, 0, 255)), ColorUtility.getLab(new Color(0, 255, 0)), ColorUtility.getLab(new Color(0, 255, 255)), ColorUtility.getLab(new Color(255, 0, 0)), ColorUtility.getLab(new Color(255, 0, 255)), ColorUtility.getLab(new Color(255, 255, 0)), ColorUtility.getLab(new Color(255, 255, 255))};

    public WidgetProspectingMap(int xPosition, int yPosition, int chunkRadius, WidgetOreList widgetOreList, @NotNull ProspectorMode mode, int scanTick) {
        super(new Position(xPosition, yPosition), new Size(16 * (chunkRadius * 2 - 1), 16 * (chunkRadius * 2 - 1)));
        this.chunkRadius = chunkRadius;
        this.mode = mode;
        this.scanTick = scanTick;
        this.oreList = widgetOreList;
        if (this.oreList != null) {
            this.oreList.onSelected = name -> {
                if (this.texture != null) {
                    this.texture.loadTexture(null, (String)name);
                }
            };
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setOnPacketReceived(Consumer<PacketProspecting> onPacketReceived) {
        this.onPacketReceived = onPacketReceived;
    }

    @SideOnly(value=Side.CLIENT)
    public void setDarkMode(boolean mode) {
        if (this.darkMode != mode) {
            this.darkMode = mode;
            if (this.texture != null) {
                this.texture.loadTexture(null, this.darkMode);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getDarkMode() {
        return this.darkMode;
    }

    @Override
    public void detectAndSendChanges() {
        block11: {
            EntityPlayer player = this.gui.entityPlayer;
            World world = player.field_70170_p;
            if (FMLCommonHandler.instance().getMinecraftServerInstance().func_71259_af() % this.scanTick != 0 || this.chunkIndex >= (this.chunkRadius * 2 - 1) * (this.chunkRadius * 2 - 1)) break block11;
            int playerChunkX = player.field_70176_ah;
            int playerChunkZ = player.field_70164_aj;
            int row = this.chunkIndex / (this.chunkRadius * 2 - 1);
            int column = this.chunkIndex % (this.chunkRadius * 2 - 1);
            int ox = column - this.chunkRadius + 1;
            int oz = row - this.chunkRadius + 1;
            Chunk chunk = world.func_72964_e(playerChunkX + ox, playerChunkZ + oz);
            PacketProspecting packet = new PacketProspecting(playerChunkX + ox, playerChunkZ + oz, playerChunkX, playerChunkZ, (int)player.field_70165_t, (int)player.field_70161_v, this.mode);
            switch (this.mode) {
                case ORE: {
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            int ySize = chunk.func_76611_b(x, z);
                            for (int y = 1; y < ySize; ++y) {
                                pos.func_181079_c(x, y, z);
                                IBlockState state = chunk.func_177435_g((BlockPos)pos);
                                ItemStack itemBlock = GTUtility.toItem(state);
                                if (!GTUtility.isOre(itemBlock)) continue;
                                boolean added = false;
                                String oreDictString = OreDictUnifier.getOreDictionaryNames(itemBlock).stream().findFirst().orElse("");
                                OrePrefix prefix = OreDictUnifier.getPrefix(itemBlock);
                                if (prefix != null) {
                                    Iterator iterator = StoneType.STONE_TYPE_REGISTRY.iterator();
                                    while (iterator.hasNext()) {
                                        MaterialStack materialStack;
                                        StoneType type = (StoneType)iterator.next();
                                        if (type.processingPrefix == prefix && type.shouldBeDroppedAsItem) {
                                            packet.addBlock(x, y, z, oreDictString);
                                            added = true;
                                            break;
                                        }
                                        if (type.processingPrefix != prefix || (materialStack = OreDictUnifier.getMaterial(itemBlock)) == null) continue;
                                        String oreDict = "ore" + oreDictString.replaceFirst(prefix.name(), "");
                                        packet.addBlock(x, y, z, oreDict);
                                        added = true;
                                        break;
                                    }
                                }
                                if (added) continue;
                                packet.addBlock(x, y, z, oreDictString);
                            }
                        }
                    }
                    break;
                }
                case FLUID: {
                    BedrockFluidVeinHandler.FluidVeinWorldEntry fStack = BedrockFluidVeinHandler.getFluidVeinWorldEntry(world, chunk.field_76635_g, chunk.field_76647_h);
                    if (fStack == null || fStack.getDefinition() == null) break;
                    packet.addBlock(0, 3, 0, TextFormattingUtil.formatNumbers(100.0 * (double)BedrockFluidVeinHandler.getOperationsRemaining(world, chunk.field_76635_g, chunk.field_76647_h) / 100000.0));
                    packet.addBlock(0, 2, 0, String.valueOf(BedrockFluidVeinHandler.getFluidYield(world, chunk.field_76635_g, chunk.field_76647_h)));
                    Fluid fluid = BedrockFluidVeinHandler.getFluidInChunk(world, chunk.field_76635_g, chunk.field_76647_h);
                    if (fluid != null) {
                        packet.addBlock(0, 1, 0, fluid.getName());
                    }
                    break;
                }
            }
            this.writeUpdateInfo(2, packet::writePacketData);
            ++this.chunkIndex;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        if (this.texture != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.texture.draw(this.getPosition().x, this.getPosition().y);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        PacketProspecting packet;
        super.readUpdateInfo(id, buffer);
        if (id == 2 && (packet = PacketProspecting.readPacketData(buffer)) != null) {
            if (this.onPacketReceived != null) {
                this.onPacketReceived.accept(packet);
            }
            this.addPacketToQueue(packet);
        }
    }

    @Override
    public void updateScreen() {
        if (this.packetQueue != null) {
            int max = 10;
            while (max-- > 0 && !this.packetQueue.isEmpty()) {
                PacketProspecting packet = this.packetQueue.poll();
                if (this.texture == null) {
                    this.texture = new ProspectingTexture(packet.mode, this.chunkRadius, this.darkMode);
                }
                this.texture.updateTexture(packet);
                if (this.oreList == null) continue;
                this.oreList.addOres(packet.ores, packet.mode);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addPacketToQueue(PacketProspecting packet) {
        this.packetQueue.add(packet);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.texture != null) {
            this.hoveredNames.clear();
            ArrayList<String> tooltips = new ArrayList<String>();
            int cX = (mouseX - this.getPosition().x) / 16;
            int cZ = (mouseY - this.getPosition().y) / 16;
            if (cX >= this.chunkRadius * 2 - 1 || cZ >= this.chunkRadius * 2 - 1) {
                return;
            }
            Gui.func_73734_a((int)(cX * 16 + this.getPosition().x), (int)(cZ * 16 + this.getPosition().y), (int)((cX + 1) * 16 + this.getPosition().x), (int)((cZ + 1) * 16 + this.getPosition().y), (int)new Color(1265396844, true).getRGB());
            int[] maxAmount = new int[]{0};
            if (this.mode == ProspectorMode.ORE) {
                tooltips.add(I18n.func_135052_a((String)"terminal.prospector.ore", (Object[])new Object[0]));
                HashMap<String, Integer> oreInfo = new HashMap<String, Integer>();
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 16; ++j) {
                        if (this.texture.map[cX * 16 + i][cZ * 16 + j] == null) continue;
                        this.texture.map[cX * 16 + i][cZ * 16 + j].values().forEach(dict -> {
                            String name = OreDictUnifier.get(dict).func_82833_r();
                            if ("[all]".equals(this.texture.getSelected()) || this.texture.getSelected().equals(dict)) {
                                oreInfo.put(name, oreInfo.getOrDefault(name, 0) + 1);
                                if ((Integer)oreInfo.get(name) > maxAmount[0]) {
                                    maxAmount[0] = (Integer)oreInfo.get(name);
                                    MaterialStack m = OreDictUnifier.getMaterial(OreDictUnifier.get(dict));
                                    if (m != null) {
                                        this.color = m.material.getMaterialRGB();
                                    }
                                }
                            }
                        });
                    }
                }
                oreInfo.forEach((name, count) -> {
                    tooltips.add(name + " --- " + count);
                    this.hoveredNames.add((String)name);
                });
            } else if (this.mode == ProspectorMode.FLUID) {
                FluidStack fluidStack;
                tooltips.add(I18n.func_135052_a((String)"terminal.prospector.fluid", (Object[])new Object[0]));
                if (this.texture.map[cX][cZ] != null && !this.texture.map[cX][cZ].isEmpty() && ("[all]".equals(this.texture.getSelected()) || this.texture.getSelected().equals(this.texture.map[cX][cZ].get((byte)1))) && (fluidStack = FluidRegistry.getFluidStack((String)this.texture.map[cX][cZ].get((byte)1), (int)1)) != null) {
                    tooltips.add(I18n.func_135052_a((String)"terminal.prospector.fluid.info", (Object[])new Object[]{fluidStack.getLocalizedName(), this.texture.map[cX][cZ].get((byte)2), this.texture.map[cX][cZ].get((byte)3)}));
                    this.hoveredNames.add(fluidStack.getLocalizedName());
                    int amount = Integer.parseInt(this.texture.map[cX][cZ].get((byte)2));
                    if (amount > maxAmount[0]) {
                        maxAmount[0] = amount;
                        this.color = fluidStack.getFluid().getColor(fluidStack);
                    }
                }
            }
            if (Loader.isModLoaded((String)"journeymap") || Loader.isModLoaded((String)"voxelmap") || Loader.isModLoaded((String)"xaerominimap")) {
                tooltips.add(I18n.func_135052_a((String)"terminal.prospector.waypoint.add", (Object[])new Object[0]));
            }
            this.drawHoveringText(ItemStack.field_190927_a, tooltips, 300, mouseX, mouseY);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        int cX = (mouseX - this.getPosition().x) / 16;
        int cZ = (mouseY - this.getPosition().y) / 16;
        if (cX >= this.chunkRadius * 2 - 1 || cZ >= this.chunkRadius * 2 - 1) {
            return false;
        }
        int xDiff = cX - (this.chunkRadius - 1);
        int zDiff = cZ - (this.chunkRadius - 1);
        int xPos = (Minecraft.func_71410_x().field_71439_g.field_70176_ah + xDiff << 4) + 8;
        int zPos = (Minecraft.func_71410_x().field_71439_g.field_70164_aj + zDiff << 4) + 8;
        BlockPos b = new BlockPos(xPos, Minecraft.func_71410_x().field_71441_e.func_189649_b(xPos, zPos), zPos);
        if (System.currentTimeMillis() - this.lastClicked < 400L && !this.hoveredNames.isEmpty()) {
            boolean added = false;
            this.trimHoveredNames();
            if (Loader.isModLoaded((String)"journeymap")) {
                added = this.addJourneymapWaypoint(b);
            } else if (Loader.isModLoaded((String)"voxelmap")) {
                added = this.addVoxelMapWaypoint(b);
            } else if (Loader.isModLoaded((String)"xaerominimap")) {
                added = this.addXaeroMapWaypoint(b);
            }
            if (added) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("behavior.prospector.added_waypoint", new Object[0]), true);
            }
        }
        this.lastClicked = System.currentTimeMillis();
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void trimHoveredNames() {
        List<OreDepositDefinition> oreVeins = WorldGenRegistry.getOreDeposits();
        for (OreDepositDefinition odd : oreVeins) {
            for (FillerEntry fillerEntry : odd.getBlockFiller().getAllPossibleStates()) {
                ArrayList<String> matches = new ArrayList<String>();
                Collection<IBlockState> pr = fillerEntry.getPossibleResults();
                for (IBlockState bs : pr) {
                    Set<String> ores = OreDictUnifier.getOreDictionaryNames(new ItemStack(bs.func_177230_c()));
                    for (String dict : ores) {
                        String name = OreDictUnifier.get(dict).func_82833_r();
                        if (!this.hoveredNames.contains(name)) continue;
                        matches.add(name);
                    }
                }
                if (matches.size() <= pr.size() / 2) continue;
                this.hoveredNames.removeAll(matches);
                this.hoveredNames.add(FileUtility.trimFileName(odd.getDepositName()));
            }
        }
    }

    @NotNull
    private String createVeinName() {
        String s = this.hoveredNames.toString();
        return s.substring(1, s.length() - 1);
    }

    @Optional.Method(modid="journeymap")
    private boolean addJourneymapWaypoint(BlockPos b) {
        journeymap.client.model.Waypoint journeyMapWaypoint = new journeymap.client.model.Waypoint(this.createVeinName(), b, new Color(this.color), Waypoint.Type.Normal, Integer.valueOf(Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension()));
        if (!WaypointStore.INSTANCE.getAll().contains(journeyMapWaypoint)) {
            WaypointStore.INSTANCE.save(journeyMapWaypoint);
            return true;
        }
        return false;
    }

    @Optional.Method(modid="voxelmap")
    private boolean addVoxelMapWaypoint(@NotNull BlockPos b) {
        Color c = new Color(this.color);
        TreeSet<Integer> world = new TreeSet<Integer>();
        world.add(Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension());
        IWaypointManager waypointManager = AbstractVoxelMap.getInstance().getWaypointManager();
        com.mamiyaotaru.voxelmap.util.Waypoint voxelMapWaypoint = new com.mamiyaotaru.voxelmap.util.Waypoint(this.createVeinName(), b.func_177958_n(), b.func_177952_p(), Minecraft.func_71410_x().field_71441_e.func_189649_b(b.func_177958_n(), b.func_177952_p()), true, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, Minecraft.func_71410_x().field_71441_e.field_73011_w.func_186058_p().func_186067_c(), Minecraft.func_71410_x().field_71441_e.field_73011_w.func_186058_p().func_186065_b(), world);
        if (!waypointManager.getWaypoints().contains(voxelMapWaypoint)) {
            waypointManager.addWaypoint(voxelMapWaypoint);
            waypointManager.saveWaypoints();
            return true;
        }
        return false;
    }

    @Optional.Method(modid="xaerominimap")
    private boolean addXaeroMapWaypoint(@NotNull BlockPos b) {
        int red = WidgetProspectingMap.clampColor(this.color >> 16 & 0xFF);
        int green = WidgetProspectingMap.clampColor(this.color >> 8 & 0xFF);
        int blue = WidgetProspectingMap.clampColor(this.color & 0xFF);
        Color wpc = new Color(red, green, blue);
        double[] labWPC = ColorUtility.getLab(wpc);
        int bestColorIndex = 0;
        double closestDistance = Double.MAX_VALUE;
        for (int i = 0; i < this.xaerosColors.length; ++i) {
            double diffBInner;
            double diffAInner;
            double[] c = this.xaerosColors[i];
            double diffLInner = Math.abs(c[0] - labWPC[0]);
            double distance = diffLInner * diffLInner + (diffAInner = Math.abs(c[1] - labWPC[1])) * diffAInner + (diffBInner = Math.abs(c[2] - labWPC[2])) * diffBInner;
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            bestColorIndex = i;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointSet wps = minimapSession.getWaypointsManager().getWaypoints();
        WaypointWorld ww = minimapSession.getWaypointsManager().getCurrentWorld();
        Waypoint xaeroWaypoint = new Waypoint(b.func_177958_n(), Minecraft.func_71410_x().field_71441_e.func_189649_b(b.func_177958_n(), b.func_177952_p()), b.func_177952_p(), this.createVeinName(), this.hoveredNames.get(0).substring(0, 1), bestColorIndex);
        for (Waypoint xwp : wps.getList()) {
            if (xwp.getX() != xaeroWaypoint.getX() || xwp.getY() != xaeroWaypoint.getY() || xwp.getZ() != xaeroWaypoint.getZ()) continue;
            return false;
        }
        wps.getList().add(xaeroWaypoint);
        try {
            minimapSession.getModMain().getSettings().saveWaypoints(ww);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static int clampColor(int color) {
        if (color < 32) {
            return 0;
        }
        if (color < 128) {
            return 128;
        }
        if (color < 192) {
            return 192;
        }
        return 255;
    }
}

