/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.prospector.widget;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.Position;
import gregtech.common.terminal.app.prospector.ProspectorMode;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class WidgetOreList
extends DraggableScrollableWidgetGroup {
    protected WidgetGroup selected;
    protected final BiMap<WidgetGroup, String> widgetMap = HashBiMap.create();
    protected Consumer<String> onSelected = null;
    public Map<String, String> ores = new HashMap<String, String>();
    private int tickCounter;

    public WidgetOreList(int xPosition, int yPosition, int width, int slotSize) {
        super(xPosition, yPosition, width, slotSize);
        this.setYScrollBarWidth(5);
        this.setYBarStyle(null, TerminalTheme.COLOR_F_1);
        this.clear();
    }

    public void setSelected(String oreName) {
        WidgetGroup widget = (WidgetGroup)this.widgetMap.inverse().get((Object)oreName);
        if (widget != null) {
            this.selected = widget;
            if (this.onSelected != null) {
                this.onSelected.accept((String)this.widgetMap.get((Object)this.selected));
            }
        }
    }

    public void addOres(Set<String> ores, ProspectorMode mode) {
        switch (mode) {
            case ORE: {
                ores.stream().sorted().forEach(this::addOre);
                break;
            }
            case FLUID: {
                ores.stream().sorted().forEach(this::addOil);
                break;
            }
        }
    }

    private void addOre(String orePrefix) {
        if (this.ores.containsKey(orePrefix)) {
            return;
        }
        ItemStack itemStack = OreDictUnifier.get(orePrefix);
        if (itemStack == null || itemStack.func_190926_b()) {
            return;
        }
        this.ores.put(orePrefix, itemStack.func_82833_r());
        MaterialStack materialStack = OreDictUnifier.getMaterial(OreDictUnifier.get(orePrefix));
        ItemStackHandler itemStackHandler = new ItemStackHandler(1);
        itemStackHandler.insertItem(0, itemStack, false);
        WidgetGroup widgetGroup = new WidgetGroup(0, 0, this.getSize().width - 5, 18);
        widgetGroup.addWidget(new SlotWidget((IItemHandler)itemStackHandler, 0, 0, 0, false, false));
        widgetGroup.addWidget(new LabelWidget(20, 5, itemStack.func_82833_r(), materialStack == null ? orePrefix.hashCode() : materialStack.material.getMaterialRGB() | 0xFF000000));
        this.addOrePrefix(orePrefix, widgetGroup);
    }

    private void addOrePrefix(String orePrefix, WidgetGroup widgetGroup) {
        this.widgetMap.put((Object)widgetGroup, (Object)orePrefix);
        this.addWidget(widgetGroup);
        this.widgets.sort(Comparator.comparing(arg_0 -> this.widgetMap.get(arg_0)));
        int y = 0;
        for (Widget widget : this.widgets) {
            widget.setSelfPosition(new Position(0, y - this.scrollYOffset));
            y += 18;
        }
        this.computeMax();
    }

    private void addOil(String orePrefix) {
        if (this.ores.containsKey(orePrefix)) {
            return;
        }
        FluidStack fluidStack = FluidRegistry.getFluidStack((String)orePrefix, (int)1);
        if (fluidStack == null) {
            return;
        }
        this.ores.put(orePrefix, fluidStack.getLocalizedName());
        FluidTank fluidTank = new FluidTank(1);
        fluidTank.setCanFill(false);
        fluidTank.fillInternal(fluidStack, true);
        WidgetGroup widgetGroup = new WidgetGroup(0, 0, this.getSize().width - 5, 18);
        widgetGroup.addWidget(new TankWidget((IFluidTank)fluidTank, 0, 0, 18, 18).setAlwaysShowFull(true).setClient().setHideTooltip(true).setContainerClicking(false, false));
        widgetGroup.addWidget(new LabelWidget(20, 5, fluidStack.getLocalizedName(), WidgetOreList.getFluidColor(fluidStack.getFluid())));
        this.addOrePrefix(orePrefix, widgetGroup);
    }

    public void clear() {
        this.clearAllWidgets();
        this.widgetMap.clear();
        WidgetGroup widgetGroup = new WidgetGroup(0, 0, this.getSize().width - 5, 18);
        widgetGroup.addWidget(new ImageWidget(0, 0, 18, 18, GuiTextures.LOCK));
        widgetGroup.addWidget(new LabelWidget(20, 9, "terminal.prospector.list", -1));
        this.selected = widgetGroup;
        this.widgetMap.put((Object)widgetGroup, (Object)"[all]");
        this.addWidget(widgetGroup);
    }

    @Override
    protected boolean hookDrawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        if (this.selected != null) {
            WidgetOreList.drawSolidRect(this.selected.getPosition().x, this.selected.getPosition().y, this.selected.getSize().width, 18, 0x4BFFFFFF);
        }
        for (Widget widget : this.widgets) {
            if (!widget.isVisible()) continue;
            widget.drawInBackground(mouseX, mouseY, partialTicks, context);
            GlStateManager.func_179131_c((float)this.gui.getRColorForOverlay(), (float)this.gui.getGColorForOverlay(), (float)this.gui.getBColorForOverlay(), (float)1.0f);
        }
        return true;
    }

    @Override
    protected boolean checkClickedDragged(int mouseX, int mouseY, int button) {
        this.draggedWidget = null;
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = (Widget)this.widgets.get(i);
            if (!widget.isVisible() || !(widget instanceof WidgetGroup) || !widget.isMouseOverElement(mouseX, mouseY)) continue;
            if (this.isMouseOverElement(mouseX, mouseY) && this.selected != widget) {
                this.setSelected((String)this.widgetMap.get((Object)widget));
            }
            return true;
        }
        return false;
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        ++this.tickCounter;
        if (this.tickCounter % 20 == 0) {
            this.widgets.forEach(widget -> {
                Widget widget1;
                if (widget instanceof WidgetGroup && (widget1 = ((WidgetGroup)widget).getContainedWidgets(true).get(0)) instanceof SlotWidget) {
                    SlotWidget slotWidget = (SlotWidget)widget1;
                    List<ItemStack> list = OreDictUnifier.getAllWithOreDictionaryName((String)this.widgetMap.get(widget));
                    if (list.size() > 0) {
                        slotWidget.getHandle().func_75209_a(64);
                        slotWidget.getHandle().func_75215_d(list.get(Math.floorMod(this.tickCounter / 20, list.size())));
                    }
                }
            });
        }
    }

    public static int getFluidColor(Fluid fluid) {
        if (fluid == FluidRegistry.WATER) {
            return 3183823;
        }
        return fluid == FluidRegistry.LAVA ? 16766720 : fluid.getColor();
    }

    @Override
    protected void writeClientAction(int id, Consumer<PacketBuffer> packetBufferWriter) {
    }
}

