/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.multiblockhelper;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.resources.ShaderTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.terminal.app.ARApplication;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.gui.widgets.MachineSceneWidget;
import gregtech.api.terminal.gui.widgets.RectButtonWidget;
import gregtech.api.terminal.os.TerminalDialogWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.client.renderer.handler.MultiblockPreviewRenderer;
import gregtech.client.shader.Shaders;
import gregtech.client.utils.RenderUtil;
import gregtech.common.ConfigHolder;
import gregtech.common.terminal.app.multiblockhelper.MachineBuilderWidget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultiBlockPreviewARApp
extends ARApplication {
    @SideOnly(value=Side.CLIENT)
    int lastMouseX;
    @SideOnly(value=Side.CLIENT)
    int lastMouseY;
    @SideOnly(value=Side.CLIENT)
    float partialTicks;
    @SideOnly(value=Side.CLIENT)
    private static Map<MultiblockControllerBase, MultiblockShapeInfo> controllerList;
    @SideOnly(value=Side.CLIENT)
    private static Set<MultiblockControllerBase> found;
    @SideOnly(value=Side.CLIENT)
    private static BlockPos lastPos;
    private static int opList;

    public MultiBlockPreviewARApp() {
        super("multiblock_ar");
    }

    @Override
    public AbstractApplication initApp() {
        int bW = 120;
        int bH = 120;
        this.addWidget(new ImageWidget(10, 10, 313, 212, new ColorRectTexture(TerminalTheme.COLOR_B_2.getColor())));
        this.addWidget(new ImageWidget(166, 20, 1, 182, new ColorRectTexture(-1)));
        this.addWidget(new LabelWidget(88, 35, "terminal.multiblock_ar.tier.0", -1).setXCentered(true).setYCentered(true));
        this.addWidget(new RectButtonWidget(10 + (156 - bW) / 2, 50, bW, bH).setIcon(TextureArea.fullImage("textures/gui/terminal/multiblock_ar/profile.png")).setColors(-1, -16711936, 0).setHoverText("terminal.ar.open").setClickListener(clickData -> this.openAR()));
        this.addWidget(new LabelWidget(244, 35, "terminal.multiblock_ar.tier.1", this.getAppTier() == 0 ? -65536 : -1).setXCentered(true).setYCentered(true));
        this.addWidget(new RectButtonWidget(166 + (156 - bW) / 2, 50, bW, bH).setIcon(this::drawBuilderButton).setColors(this.getAppTier() == 0 ? -65536 : -1, this.getAppTier() == 0 ? -65536 : -16711936, 0).setHoverText(this.getAppTier() > 0 ? "terminal.multiblock_ar.builder.hover" : "terminal.multiblock_ar.unlock").setClickListener(clickData -> this.buildMode()));
        return this;
    }

    private void drawBuilderButton(double x, double y, int width, int height) {
        if (Shaders.allowedShader()) {
            int color;
            float time = ((float)this.gui.entityPlayer.field_70173_aa + this.partialTicks) / 20.0f;
            MultiblockControllerBase controllerBase = this.getController();
            int n = color = controllerBase == null ? -1 : controllerBase.getPaintingColorForRendering();
            if (controllerBase != null) {
                GlStateManager.func_179138_g((int)33984);
                GlStateManager.func_179098_w();
                RenderUtil.bindTextureAtlasSprite(controllerBase.getFrontDefaultTexture());
                GlStateManager.func_179138_g((int)33985);
                GlStateManager.func_179098_w();
                RenderUtil.bindTextureAtlasSprite(controllerBase.getBaseTexture(null).getParticleSprite());
            }
            ShaderTexture.createShader("showcube.frag").draw(x, y, width, height, uniformCache -> {
                uniformCache.glUniform1I("faceTexture", 0);
                uniformCache.glUniform1I("baseTexture", 1);
                uniformCache.glUniform1F("u_time", time);
                uniformCache.glUniform3F("f_color", (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
                uniformCache.glUniformBoolean("block", controllerBase != null);
                if (MultiBlockPreviewARApp.isMouseOver((int)x, (int)y, width, height, this.lastMouseX, this.lastMouseY)) {
                    uniformCache.glUniform2F("u_mouse", (float)((((double)this.lastMouseX - x) / 2.0 + (double)(width / 3)) * ConfigHolder.client.resolution), (float)((double)(height / 2) * ConfigHolder.client.resolution));
                }
            });
            GlStateManager.func_179138_g((int)33985);
            GlStateManager.func_179144_i((int)0);
            GlStateManager.func_179138_g((int)33984);
            GlStateManager.func_179144_i((int)0);
        } else {
            GuiTextures.MULTIBLOCK_CATEGORY.draw(x, y, width, height);
        }
    }

    @Override
    public int getMaxTier() {
        return 1;
    }

    private MultiblockControllerBase getController() {
        TileEntity te;
        if (this.os.clickPos != null && (te = this.gui.entityPlayer.field_70170_p.func_175625_s(this.os.clickPos)) instanceof IGregTechTileEntity && ((IGregTechTileEntity)te).getMetaTileEntity() instanceof MultiblockControllerBase) {
            return (MultiblockControllerBase)((IGregTechTileEntity)te).getMetaTileEntity();
        }
        return null;
    }

    private void buildMode() {
        if (this.getAppTier() == 0) {
            TerminalDialogWidget.showInfoDialog(this.getOs(), "terminal.dialog.notice", "terminal.multiblock_ar.unlock").open();
        } else if (this.getController() != null) {
            this.widgets.forEach(this::waitToRemoved);
            MultiblockControllerBase controllerBase = this.getController();
            MachineBuilderWidget builderWidget = new MachineBuilderWidget(200, 16, 133, 200, controllerBase, this.getOs());
            this.addWidget(builderWidget);
            builderWidget.addPlayerInventory();
            if (this.isClient) {
                MachineSceneWidget sceneWidget = new MachineSceneWidget(0, 16, 200, 200, controllerBase);
                builderWidget.setSceneWidget(sceneWidget);
                this.addWidget(0, sceneWidget);
                this.addWidget(new ImageWidget(0, 0, 333, 16, GuiTextures.UI_FRAME_SIDE_UP));
                this.addWidget(new ImageWidget(0, 216, 333, 16, GuiTextures.UI_FRAME_SIDE_DOWN));
            } else {
                this.addWidget(0, new WidgetGroup());
            }
        } else {
            TerminalDialogWidget.showInfoDialog(this.getOs(), "terminal.dialog.notice", "terminal.console.notice").open();
        }
    }

    @Override
    protected void hookDrawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.partialTicks = partialTicks;
        super.hookDrawInBackground(mouseX, mouseY, partialTicks, context);
    }

    @Override
    public void onAROpened() {
        controllerList = new HashMap<MultiblockControllerBase, MultiblockShapeInfo>();
        found = new HashSet<MultiblockControllerBase>();
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean inRange(BlockPos playerPos, BlockPos controllerPos) {
        return Math.abs(playerPos.func_177958_n() - controllerPos.func_177958_n()) < 30 && Math.abs(playerPos.func_177956_o() - controllerPos.func_177956_o()) < 30 && Math.abs(playerPos.func_177952_p() - controllerPos.func_177952_p()) < 30;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void tickAR(EntityPlayer player) {
        World world = player.field_70170_p;
        int tick = Math.abs(player.field_70173_aa % 27);
        if (tick == 0) {
            Object controller2;
            boolean reRender = false;
            Iterator<MultiblockControllerBase> iterator = controllerList.keySet().iterator();
            if (iterator.hasNext() && (!((MetaTileEntity)(controller2 = iterator.next())).isValid() || ((MultiblockControllerBase)controller2).isStructureFormed() || !MultiBlockPreviewARApp.inRange(player.func_180425_c(), ((MetaTileEntity)controller2).getPos()))) {
                iterator.remove();
                reRender = true;
            }
            for (MultiblockControllerBase controllerBase : found) {
                List<MultiblockShapeInfo> shapeInfos;
                if (controllerList.containsKey(controllerBase) || (shapeInfos = controllerBase.getMatchingShapes()).isEmpty()) continue;
                controllerList.put(controllerBase, shapeInfos.get(0));
                reRender = true;
            }
            found.clear();
            lastPos = player.func_180425_c();
            if (reRender) {
                opList = GLAllocation.func_74526_a((int)1);
                GlStateManager.func_187423_f((int)opList, (int)4864);
                controllerList.forEach((controller, shapes) -> MultiblockPreviewRenderer.renderControllerInList(controller, shapes, 0));
                GlStateManager.func_187415_K();
            }
        }
        if (lastPos == null) {
            lastPos = player.func_180425_c();
        }
        for (int i = tick * 1000; i < (tick + 1) * 1000; ++i) {
            int x = i % 30 - 15;
            int y = i / 30 % 30 - 15;
            int z = i / 900 - 15;
            TileEntity tileEntity = world.func_175625_s(lastPos.func_177982_a(x, y, z));
            if (!(tileEntity instanceof IGregTechTileEntity) || !(((IGregTechTileEntity)tileEntity).getMetaTileEntity() instanceof MultiblockControllerBase)) continue;
            found.add((MultiblockControllerBase)((IGregTechTileEntity)tileEntity).getMetaTileEntity());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawARScreen(RenderWorldLastEvent event) {
        if (opList != -1) {
            MultiblockPreviewRenderer.resetMultiblockRender();
            Minecraft mc = Minecraft.func_71410_x();
            Entity entity = mc.func_175606_aa();
            if (entity == null) {
                entity = mc.field_71439_g;
            }
            float partialTicks = event.getPartialTicks();
            double tx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double ty = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double tz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-tx), (double)(-ty), (double)(-tz));
            GlStateManager.func_179147_l();
            GlStateManager.func_179148_o((int)opList);
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        }
    }

    static {
        opList = -1;
    }
}

