/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.optical.net;

import gregtech.api.pipenet.Node;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.common.pipelike.optical.OpticalPipeProperties;
import gregtech.common.pipelike.optical.net.OpticalNetWalker;
import gregtech.common.pipelike.optical.net.OpticalRoutePath;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.Nullable;

public class OpticalPipeNet
extends PipeNet<OpticalPipeProperties> {
    private final Map<BlockPos, OpticalRoutePath> NET_DATA = new Object2ObjectOpenHashMap();

    public OpticalPipeNet(WorldPipeNet<OpticalPipeProperties, ? extends PipeNet<OpticalPipeProperties>> world) {
        super(world);
    }

    @Nullable
    public OpticalRoutePath getNetData(BlockPos pipePos, EnumFacing facing) {
        if (this.NET_DATA.containsKey(pipePos)) {
            return this.NET_DATA.get(pipePos);
        }
        OpticalRoutePath data = OpticalNetWalker.createNetData(this.getWorldData(), pipePos, facing);
        if (data == OpticalNetWalker.FAILED_MARKER) {
            return null;
        }
        this.NET_DATA.put(pipePos, data);
        return data;
    }

    @Override
    public void onNeighbourUpdate(BlockPos fromPos) {
        this.NET_DATA.clear();
    }

    @Override
    public void onPipeConnectionsUpdate() {
        this.NET_DATA.clear();
    }

    @Override
    public void onChunkUnload() {
        this.NET_DATA.clear();
    }

    @Override
    protected void transferNodeData(Map<BlockPos, Node<OpticalPipeProperties>> transferredNodes, PipeNet<OpticalPipeProperties> parentNet) {
        super.transferNodeData(transferredNodes, parentNet);
        this.NET_DATA.clear();
        ((OpticalPipeNet)parentNet).NET_DATA.clear();
    }

    @Override
    protected void writeNodeData(OpticalPipeProperties nodeData, NBTTagCompound tagCompound) {
    }

    @Override
    protected OpticalPipeProperties readNodeData(NBTTagCompound tagCompound) {
        return OpticalPipeProperties.INSTANCE;
    }
}

