/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.optical;

import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.client.renderer.pipe.OpticalPipeRenderer;
import gregtech.common.pipelike.optical.ItemBlockOpticalPipe;
import gregtech.common.pipelike.optical.OpticalPipeProperties;
import gregtech.common.pipelike.optical.OpticalPipeType;
import gregtech.common.pipelike.optical.net.WorldOpticalPipeNet;
import gregtech.common.pipelike.optical.tile.TileEntityOpticalPipe;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockOpticalPipe
extends BlockPipe<OpticalPipeType, OpticalPipeProperties, WorldOpticalPipeNet> {
    private final OpticalPipeType pipeType;
    private final OpticalPipeProperties properties;

    public BlockOpticalPipe(@NotNull OpticalPipeType pipeType) {
        this.pipeType = pipeType;
        this.properties = OpticalPipeProperties.INSTANCE;
        this.func_149647_a(GregTechAPI.TAB_GREGTECH_PIPES);
        this.setHarvestLevel("wirecutter", 1);
    }

    @Override
    protected Pair<TextureAtlasSprite, Integer> getParticleTexture(@NotNull World world, BlockPos blockPos) {
        return OpticalPipeRenderer.INSTANCE.getParticleTexture((TileEntityOpticalPipe)world.func_175625_s(blockPos));
    }

    @Override
    public Class<OpticalPipeType> getPipeTypeClass() {
        return OpticalPipeType.class;
    }

    @Override
    public WorldOpticalPipeNet getWorldPipeNet(World world) {
        return WorldOpticalPipeNet.getWorldPipeNet(world);
    }

    @Override
    public TileEntityPipeBase<OpticalPipeType, OpticalPipeProperties> createNewTileEntity(boolean supportsTicking) {
        return new TileEntityOpticalPipe();
    }

    @Override
    public OpticalPipeProperties createProperties(@NotNull IPipeTile<OpticalPipeType, OpticalPipeProperties> pipeTile) {
        OpticalPipeType pipeType = pipeTile.getPipeType();
        if (pipeType == null) {
            return this.getFallbackType();
        }
        return this.pipeType.modifyProperties(this.properties);
    }

    @Override
    public OpticalPipeProperties createItemProperties(@NotNull ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemBlockOpticalPipe) {
            ItemBlockOpticalPipe pipe = (ItemBlockOpticalPipe)item;
            return ((BlockOpticalPipe)pipe.func_179223_d()).properties;
        }
        return null;
    }

    @Override
    public ItemStack getDropItem(IPipeTile<OpticalPipeType, OpticalPipeProperties> pipeTile) {
        return new ItemStack((Block)this, 1, this.pipeType.ordinal());
    }

    @Override
    protected OpticalPipeProperties getFallbackType() {
        return OpticalPipeProperties.INSTANCE;
    }

    @Override
    public OpticalPipeType getItemPipeType(@NotNull ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemBlockOpticalPipe) {
            ItemBlockOpticalPipe pipe = (ItemBlockOpticalPipe)item;
            return ((BlockOpticalPipe)pipe.func_179223_d()).pipeType;
        }
        return null;
    }

    @Override
    public void setTileEntityData(@NotNull TileEntityPipeBase<OpticalPipeType, OpticalPipeProperties> pipeTile, ItemStack itemStack) {
        pipeTile.setPipeData(this, this.pipeType);
    }

    @Override
    public void func_149666_a(@NotNull CreativeTabs itemIn, @NotNull NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, this.pipeType.ordinal()));
    }

    @Override
    protected boolean isPipeTool(@NotNull ItemStack stack) {
        return ToolHelper.isTool(stack, "wirecutter");
    }

    @Override
    public boolean canPipesConnect(IPipeTile<OpticalPipeType, OpticalPipeProperties> selfTile, EnumFacing side, IPipeTile<OpticalPipeType, OpticalPipeProperties> sideTile) {
        return selfTile instanceof TileEntityOpticalPipe && sideTile instanceof TileEntityOpticalPipe;
    }

    @Override
    public boolean canPipeConnectToBlock(IPipeTile<OpticalPipeType, OpticalPipeProperties> selfTile, EnumFacing side, @Nullable TileEntity tile) {
        if (tile == null) {
            return false;
        }
        if (tile.hasCapability(GregtechTileCapabilities.CAPABILITY_DATA_ACCESS, side.func_176734_d())) {
            return true;
        }
        return tile.hasCapability(GregtechTileCapabilities.CABABILITY_COMPUTATION_PROVIDER, side.func_176734_d());
    }

    @Override
    public boolean isHoldingPipe(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.func_184614_ca();
        return stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof ItemBlockOpticalPipe;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public EnumBlockRenderType func_149645_b(@NotNull IBlockState state) {
        return OpticalPipeRenderer.INSTANCE.getBlockRenderType();
    }
}

