/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.cable.net;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.pipenet.PipeNetWalker;
import gregtech.api.unification.material.properties.WireProperties;
import gregtech.common.pipelike.cable.net.EnergyRoutePath;
import gregtech.common.pipelike.cable.tile.TileEntityCable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class EnergyNetWalker
extends PipeNetWalker<TileEntityCable> {
    private final List<EnergyRoutePath> routes;
    private TileEntityCable[] pipes = new TileEntityCable[0];
    private int loss;

    public static List<EnergyRoutePath> createNetData(World world, BlockPos sourcePipe) {
        if (!(world.func_175625_s(sourcePipe) instanceof TileEntityCable)) {
            return null;
        }
        EnergyNetWalker walker = new EnergyNetWalker(world, sourcePipe, 1, new ArrayList<EnergyRoutePath>());
        walker.traversePipeNet();
        return walker.isFailed() ? null : walker.routes;
    }

    protected EnergyNetWalker(World world, BlockPos sourcePipe, int walkedBlocks, List<EnergyRoutePath> routes) {
        super(world, sourcePipe, walkedBlocks);
        this.routes = routes;
    }

    @Override
    protected PipeNetWalker<TileEntityCable> createSubWalker(World world, EnumFacing facingToNextPos, BlockPos nextPos, int walkedBlocks) {
        EnergyNetWalker walker = new EnergyNetWalker(world, nextPos, walkedBlocks, this.routes);
        walker.loss = this.loss;
        walker.pipes = this.pipes;
        return walker;
    }

    @Override
    protected void checkPipe(TileEntityCable pipeTile, BlockPos pos) {
        this.pipes = (TileEntityCable[])ArrayUtils.add((Object[])this.pipes, (Object)pipeTile);
        this.loss += ((WireProperties)pipeTile.getNodeData()).getLossPerBlock();
    }

    @Override
    protected void checkNeighbour(TileEntityCable pipeTile, BlockPos pipePos, EnumFacing faceToNeighbour, @Nullable TileEntity neighbourTile) {
        IEnergyContainer container;
        if (pipeTile != this.pipes[this.pipes.length - 1]) {
            throw new IllegalStateException("The current pipe is not the last added pipe. Something went seriously wrong!");
        }
        if (neighbourTile != null && (container = (IEnergyContainer)neighbourTile.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, faceToNeighbour.func_176734_d())) != null) {
            this.routes.add(new EnergyRoutePath(faceToNeighbour, this.pipes, this.getWalkedBlocks(), this.loss));
        }
    }

    @Override
    protected Class<TileEntityCable> getBasePipeClass() {
        return TileEntityCable.class;
    }
}

