/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IActiveOutputSide;
import gregtech.api.capability.IFilter;
import gregtech.api.capability.IFilteredFluidContainer;
import gregtech.api.capability.impl.FilteredItemHandler;
import gregtech.api.capability.impl.FluidHandlerProxy;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.GTFluidHandlerItemStack;
import gregtech.api.cover.CoverRayTracer;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.gui.widgets.FluidContainerSlotWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.PhantomTankWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.custom.QuantumStorageRenderer;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityQuantumTank
extends MetaTileEntity
implements ITieredMetaTileEntity,
IActiveOutputSide,
IFastRenderMetaTileEntity {
    private final int tier;
    private final int maxFluidCapacity;
    protected FluidTank fluidTank;
    private boolean autoOutputFluids;
    @Nullable
    private EnumFacing outputFacing;
    private boolean allowInputFromOutputSide = false;
    protected IFluidHandler outputFluidInventory;
    @Nullable
    protected FluidStack previousFluid;
    protected boolean locked;
    protected boolean voiding;
    @Nullable
    private FluidStack lockedFluid;

    public MetaTileEntityQuantumTank(ResourceLocation metaTileEntityId, int tier, int maxFluidCapacity) {
        super(metaTileEntityId);
        this.tier = tier;
        this.maxFluidCapacity = maxFluidCapacity;
        this.initializeInventory();
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.fluidTank = new QuantumFluidTank(this.maxFluidCapacity);
        this.fluidInventory = this.fluidTank;
        this.importFluids = new FluidTankList(false, new IFluidTank[]{this.fluidTank});
        this.exportFluids = new FluidTankList(false, new IFluidTank[]{this.fluidTank});
        this.outputFluidInventory = new FluidHandlerProxy(new FluidTankList(false, new IFluidTank[0]), this.exportFluids);
    }

    @Override
    public void update() {
        super.update();
        EnumFacing currentOutputFacing = this.getOutputFacing();
        if (!this.getWorld().field_72995_K) {
            this.fillContainerFromInternalTank();
            this.fillInternalTankFromFluidContainer();
            if (this.isAutoOutputFluids()) {
                this.pushFluidsIntoNearbyHandlers(currentOutputFacing);
            }
            FluidStack currentFluid = this.fluidTank.getFluid();
            if (this.previousFluid == null) {
                if (currentFluid != null) {
                    this.updatePreviousFluid(currentFluid);
                }
            } else if (currentFluid == null) {
                this.updatePreviousFluid(null);
            } else if (this.previousFluid.getFluid().equals(currentFluid.getFluid()) && this.previousFluid.amount != currentFluid.amount) {
                this.previousFluid.amount = currentFluid.amount;
                this.writeCustomData(GregtechDataCodes.UPDATE_FLUID_AMOUNT, buf -> buf.writeInt(currentFluid.amount));
            } else if (!this.previousFluid.equals((Object)currentFluid)) {
                this.updatePreviousFluid(currentFluid);
            }
        }
    }

    protected void updatePreviousFluid(FluidStack currentFluid) {
        this.previousFluid = currentFluid == null ? null : currentFluid.copy();
        this.writeCustomData(GregtechDataCodes.UPDATE_FLUID, buf -> buf.func_150786_a(currentFluid == null ? null : currentFluid.writeToNBT(new NBTTagCompound())));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("FluidInventory", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        data.func_74757_a("AutoOutputFluids", this.autoOutputFluids);
        data.func_74768_a("OutputFacing", this.getOutputFacing().func_176745_a());
        data.func_74757_a("IsVoiding", this.voiding);
        data.func_74757_a("IsLocked", this.locked);
        if (this.locked && this.lockedFluid != null) {
            data.func_74782_a("LockedFluid", (NBTBase)this.lockedFluid.writeToNBT(new NBTTagCompound()));
        }
        data.func_74757_a("AllowInputFromOutputSideF", this.allowInputFromOutputSide);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("ContainerInventory")) {
            MetaTileEntityQuantumTank.legacyTankItemHandlerNBTReading(this, data.func_74775_l("ContainerInventory"), 0, 1);
        }
        this.fluidTank.readFromNBT(data.func_74775_l("FluidInventory"));
        this.autoOutputFluids = data.func_74767_n("AutoOutputFluids");
        this.outputFacing = EnumFacing.field_82609_l[data.func_74762_e("OutputFacing")];
        this.voiding = data.func_74767_n("IsVoiding") || data.func_74767_n("IsPartiallyVoiding");
        this.locked = data.func_74767_n("IsLocked");
        this.lockedFluid = this.locked ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)data.func_74775_l("LockedFluid")) : null;
        this.allowInputFromOutputSide = data.func_74767_n("AllowInputFromOutputSideF");
    }

    public static void legacyTankItemHandlerNBTReading(MetaTileEntity mte, NBTTagCompound nbt, int inputSlot, int outputSlot) {
        if (mte == null || nbt == null) {
            return;
        }
        NBTTagList items = nbt.func_150295_c("Items", 10);
        if (mte.getExportItems().getSlots() < 1 || mte.getImportItems().getSlots() < 1 || inputSlot < 0 || outputSlot < 0 || inputSlot == outputSlot) {
            return;
        }
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound itemTags = items.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot == inputSlot) {
                mte.getImportItems().setStackInSlot(0, new ItemStack(itemTags));
                continue;
            }
            if (slot != outputSlot) continue;
            mte.getExportItems().setStackInSlot(0, new ItemStack(itemTags));
        }
    }

    @Override
    public void initFromItemStackData(NBTTagCompound tag) {
        super.initFromItemStackData(tag);
        if (tag.func_150297_b("Fluid", 10)) {
            this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("Fluid")));
        }
        if (tag.func_74767_n("IsVoiding") || tag.func_74767_n("IsPartialVoiding")) {
            this.setVoiding(true);
        }
        this.lockedFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("LockedFluid"));
        this.locked = this.lockedFluid != null;
    }

    @Override
    public void writeItemStackData(NBTTagCompound tag) {
        super.writeItemStackData(tag);
        FluidStack stack = this.fluidTank.getFluid();
        if (stack != null && stack.amount > 0) {
            tag.func_74782_a("Fluid", (NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        if (this.voiding) {
            tag.func_74757_a("IsVoiding", true);
        }
        if (this.locked && this.lockedFluid != null) {
            tag.func_74782_a("LockedFluid", (NBTBase)this.lockedFluid.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityQuantumTank(this.metaTileEntityId, this.tier, this.maxFluidCapacity);
    }

    @Override
    protected FluidTankList createImportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[]{this.fluidTank});
    }

    @Override
    protected FluidTankList createExportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[]{this.fluidTank});
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new FilteredItemHandler((MetaTileEntity)this, 1).setFillPredicate(FilteredItemHandler.getCapabilityFilter(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY));
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new GTItemStackHandler((MetaTileEntity)this, 1);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        Textures.QUANTUM_STORAGE_RENDERER.renderMachine(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()))), this.getFrontFacing(), this.tier);
        Textures.QUANTUM_TANK_OVERLAY.renderSided(EnumFacing.UP, renderState, translation, pipeline);
        if (this.outputFacing != null) {
            Textures.PIPE_OUT_OVERLAY.renderSided(this.outputFacing, renderState, translation, pipeline);
            if (this.isAutoOutputFluids()) {
                Textures.FLUID_OUTPUT_OVERLAY.renderSided(this.outputFacing, renderState, translation, pipeline);
            }
        }
        QuantumStorageRenderer.renderTankFluid(renderState, translation, pipeline, this.fluidTank, (IBlockAccess)this.getWorld(), this.getPos(), this.getFrontFacing());
    }

    @Override
    public void renderMetaTileEntity(double x, double y, double z, float partialTicks) {
        if (this.fluidTank.getFluid() == null || this.fluidTank.getFluid().amount == 0) {
            return;
        }
        QuantumStorageRenderer.renderTankAmount(x, y, z, this.getFrontFacing(), this.fluidTank.getFluid().amount);
    }

    @Override
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.VOLTAGE_CASINGS[this.tier].getParticleSprite(), (Object)this.getPaintingColorForRendering());
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.quantum_tank.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.maxFluidCapacity}));
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            FluidStack fluidStack;
            if (tag.func_150297_b("Fluid", 10) && (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("Fluid"))) != null) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_stored", (Object[])new Object[]{fluidStack.getLocalizedName(), fluidStack.amount}));
            }
            if (tag.func_74767_n("IsVoiding") || tag.func_74767_n("IsPartialVoiding")) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.machine.quantum_tank.tooltip.voiding_enabled", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.auto_output_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        TankWidget tankWidget = new PhantomTankWidget((IFluidTank)this.fluidTank, 69, 43, 18, 18, () -> this.lockedFluid, f -> {
            if (this.fluidTank.getFluidAmount() != 0) {
                return;
            }
            if (f == null) {
                this.setLocked(false);
                this.lockedFluid = null;
            } else {
                this.setLocked(true);
                this.lockedFluid = f.copy();
                this.lockedFluid.amount = 1;
            }
        }).setAlwaysShowFull(true).setDrawHoveringText(false);
        return ModularUI.defaultBuilder().widget(new ImageWidget(7, 16, 81, 46, GuiTextures.DISPLAY)).widget(new LabelWidget(11, 20, "gregtech.gui.fluid_amount", 0xFFFFFF)).widget(tankWidget).widget(new AdvancedTextWidget(11, 30, this.getFluidAmountText(tankWidget), 0xFFFFFF)).widget(new AdvancedTextWidget(11, 40, this.getFluidNameText(tankWidget), 0xFFFFFF)).label(6, 6, this.getMetaFullName()).widget(new FluidContainerSlotWidget(this.importItems, 0, 90, 17, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.IN_SLOT_OVERLAY)).widget(new SlotWidget((IItemHandler)this.exportItems, 0, 90, 44, true, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.OUT_SLOT_OVERLAY)).widget(new ToggleButtonWidget(7, 64, 18, 18, GuiTextures.BUTTON_FLUID_OUTPUT, this::isAutoOutputFluids, this::setAutoOutputFluids).setTooltipText("gregtech.gui.fluid_auto_output.tooltip", new Object[0]).shouldUseBaseBackground()).widget(new ToggleButtonWidget(25, 64, 18, 18, GuiTextures.BUTTON_LOCK, this::isLocked, this::setLocked).setTooltipText("gregtech.gui.fluid_lock.tooltip", new Object[0]).shouldUseBaseBackground()).widget(new ToggleButtonWidget(43, 64, 18, 18, GuiTextures.BUTTON_FLUID_VOID, this::isVoiding, this::setVoiding).setTooltipText("gregtech.gui.fluid_voiding.tooltip", new Object[0]).shouldUseBaseBackground()).bindPlayerInventory(entityPlayer.field_71071_by).build(this.getHolder(), entityPlayer);
    }

    private Consumer<List<ITextComponent>> getFluidNameText(TankWidget tankWidget) {
        return list -> {
            TextComponentTranslation translation = tankWidget.getFluidTextComponent();
            if (translation == null) {
                translation = GTUtility.getFluidTranslation(this.lockedFluid);
            }
            if (translation != null) {
                list.add(translation);
            }
        };
    }

    private Consumer<List<ITextComponent>> getFluidAmountText(TankWidget tankWidget) {
        return list -> {
            String fluidAmount = "";
            if (tankWidget.getFormattedFluidAmount().equals("0")) {
                if (this.lockedFluid != null) {
                    fluidAmount = "0";
                }
            } else {
                fluidAmount = tankWidget.getFormattedFluidAmount();
            }
            if (!fluidAmount.isEmpty()) {
                list.add(new TextComponentString(fluidAmount));
            }
        };
    }

    public EnumFacing getOutputFacing() {
        return this.outputFacing == null ? this.frontFacing.func_176734_d() : this.outputFacing;
    }

    @Override
    public void setFrontFacing(EnumFacing frontFacing) {
        if (frontFacing == EnumFacing.UP) {
            if (this.outputFacing == null || this.outputFacing == EnumFacing.DOWN) {
                super.setFrontFacing(EnumFacing.NORTH);
            } else {
                super.setFrontFacing(this.outputFacing.func_176734_d());
            }
        } else {
            super.setFrontFacing(frontFacing);
        }
        if (this.outputFacing == null) {
            this.setOutputFacing(frontFacing.func_176734_d());
        }
    }

    @Override
    public boolean isAutoOutputItems() {
        return false;
    }

    @Override
    public boolean isAutoOutputFluids() {
        return this.autoOutputFluids;
    }

    @Override
    public boolean isAllowInputFromOutputSideItems() {
        return false;
    }

    @Override
    public boolean isAllowInputFromOutputSideFluids() {
        return this.allowInputFromOutputSide;
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_OUTPUT_FACING) {
            this.outputFacing = EnumFacing.field_82609_l[buf.readByte()];
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.UPDATE_AUTO_OUTPUT_FLUIDS) {
            this.autoOutputFluids = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.UPDATE_FLUID) {
            try {
                this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)buf.func_150793_b()));
            }
            catch (IOException ignored) {
                GTLog.logger.warn("Failed to load fluid from NBT in a quantum tank at " + this.getPos() + " on a routine fluid update");
            }
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.UPDATE_FLUID_AMOUNT) {
            FluidStack stack = this.fluidTank.getFluid();
            if (stack != null) {
                stack.amount = Math.min(buf.readInt(), this.fluidTank.getCapacity());
                this.scheduleRenderUpdate();
            }
        } else if (dataId == GregtechDataCodes.UPDATE_IS_VOIDING) {
            this.setVoiding(buf.readBoolean());
        }
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return super.isValidFrontFacing(facing) && facing != this.outputFacing;
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeByte(this.getOutputFacing().func_176745_a());
        buf.writeBoolean(this.autoOutputFluids);
        buf.writeBoolean(this.locked);
        buf.func_150786_a(this.fluidTank.getFluid() == null ? null : this.fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        buf.writeBoolean(this.voiding);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.outputFacing = EnumFacing.field_82609_l[buf.readByte()];
        if (this.frontFacing == EnumFacing.UP) {
            this.frontFacing = this.outputFacing != EnumFacing.DOWN ? this.outputFacing.func_176734_d() : EnumFacing.NORTH;
        }
        this.autoOutputFluids = buf.readBoolean();
        this.locked = buf.readBoolean();
        try {
            this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)buf.func_150793_b()));
        }
        catch (IOException e) {
            GTLog.logger.warn("Failed to load fluid from NBT in a quantum tank at " + this.getPos() + " on initial server/client sync");
        }
        this.voiding = buf.readBoolean();
    }

    public void setOutputFacing(EnumFacing outputFacing) {
        this.outputFacing = outputFacing;
        if (!this.getWorld().field_72995_K) {
            this.notifyBlockUpdate();
            this.writeCustomData(GregtechDataCodes.UPDATE_OUTPUT_FACING, buf -> buf.writeByte(outputFacing.func_176745_a()));
            this.markDirty();
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_ACTIVE_OUTPUT_SIDE) {
            if (side == this.getOutputFacing()) {
                return (T)GregtechTileCapabilities.CAPABILITY_ACTIVE_OUTPUT_SIDE.cast((Object)this);
            }
            return null;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            IFluidHandler fluidHandler;
            IFluidHandler iFluidHandler = fluidHandler = side == this.getOutputFacing() && !this.isAllowInputFromOutputSideFluids() ? this.outputFluidInventory : this.fluidInventory;
            if (fluidHandler.getTankProperties().length > 0) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)fluidHandler);
            }
            return null;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public ICapabilityProvider initItemStackCapabilities(ItemStack itemStack) {
        return new GTFluidHandlerItemStack(itemStack, this.maxFluidCapacity);
    }

    @Override
    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!playerIn.func_70093_af()) {
            if (this.getOutputFacing() == facing || this.getFrontFacing() == facing) {
                return false;
            }
            if (!this.getWorld().field_72995_K) {
                this.setOutputFacing(facing);
            }
            return true;
        }
        return super.onWrenchClick(playerIn, hand, facing, hitResult);
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        EnumFacing hitFacing = CoverRayTracer.determineGridSideHit((RayTraceResult)hitResult);
        if (facing == this.getOutputFacing() || hitFacing == this.getOutputFacing() && playerIn.func_70093_af()) {
            if (!this.getWorld().field_72995_K) {
                if (this.isAllowInputFromOutputSideFluids()) {
                    this.setAllowInputFromOutputSide(false);
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.basic.input_from_output_side.disallow", new Object[0]), true);
                } else {
                    this.setAllowInputFromOutputSide(true);
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.basic.input_from_output_side.allow", new Object[0]), true);
                }
            }
            return true;
        }
        return super.onScrewdriverClick(playerIn, hand, facing, hitResult);
    }

    public void setAllowInputFromOutputSide(boolean allowInputFromOutputSide) {
        if (this.allowInputFromOutputSide == allowInputFromOutputSide) {
            return;
        }
        this.allowInputFromOutputSide = allowInputFromOutputSide;
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    public void setAutoOutputFluids(boolean autoOutputFluids) {
        if (this.autoOutputFluids == autoOutputFluids) {
            return;
        }
        this.autoOutputFluids = autoOutputFluids;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.UPDATE_AUTO_OUTPUT_FLUIDS, buf -> buf.writeBoolean(autoOutputFluids));
            this.markDirty();
        }
    }

    protected boolean isLocked() {
        return this.locked;
    }

    protected void setLocked(boolean locked) {
        if (this.locked == locked) {
            return;
        }
        this.locked = locked;
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
        if (locked && this.fluidTank.getFluid() != null) {
            this.lockedFluid = this.fluidTank.getFluid().copy();
            this.lockedFluid.amount = 1;
            return;
        }
        this.lockedFluid = null;
    }

    protected boolean isVoiding() {
        return this.voiding;
    }

    protected void setVoiding(boolean isPartialVoid) {
        this.voiding = isPartialVoid;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.UPDATE_IS_VOIDING, buf -> buf.writeBoolean(this.voiding));
            this.markDirty();
        }
    }

    @Override
    public ItemStack getPickItem(EntityPlayer player) {
        if (!player.func_184812_l_()) {
            return super.getPickItem(player);
        }
        ItemStack baseItemStack = this.getStackForm();
        NBTTagCompound tag = new NBTTagCompound();
        this.writeItemStackData(tag);
        if (!tag.func_82582_d()) {
            baseItemStack.func_77982_d(tag);
        }
        return baseItemStack;
    }

    @Override
    public boolean needsSneakToRotate() {
        return true;
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.getPos());
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    private class QuantumFluidTank
    extends FluidTank
    implements IFilteredFluidContainer,
    IFilter<FluidStack> {
        public QuantumFluidTank(int capacity) {
            super(capacity);
        }

        public int fillInternal(FluidStack resource, boolean doFill) {
            int accepted = super.fillInternal(resource, doFill);
            if (accepted == 0 && !resource.isFluidEqual(this.getFluid())) {
                return 0;
            }
            if (doFill && MetaTileEntityQuantumTank.this.locked && MetaTileEntityQuantumTank.this.lockedFluid == null) {
                MetaTileEntityQuantumTank.this.lockedFluid = resource.copy();
                ((MetaTileEntityQuantumTank)MetaTileEntityQuantumTank.this).lockedFluid.amount = 1;
            }
            return MetaTileEntityQuantumTank.this.voiding ? resource.amount : accepted;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return this.test(fluid);
        }

        @Override
        public IFilter<FluidStack> getFilter() {
            return this;
        }

        @Override
        public boolean test(@NotNull FluidStack fluidStack) {
            return !MetaTileEntityQuantumTank.this.locked || MetaTileEntityQuantumTank.this.lockedFluid == null || fluidStack.isFluidEqual(MetaTileEntityQuantumTank.this.lockedFluid);
        }

        @Override
        public int getPriority() {
            return !MetaTileEntityQuantumTank.this.locked || MetaTileEntityQuantumTank.this.lockedFluid == null ? IFilter.noPriority() : IFilter.whitelistPriority(1);
        }
    }
}

