/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.PhantomSlotWidget;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.custom.QuantumStorageRenderer;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumChest;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityCreativeChest
extends MetaTileEntityQuantumChest {
    private int itemsPerCycle = 1;
    private int ticksPerCycle = 1;
    private final GTItemStackHandler handler = new GTItemStackHandler(this, 1){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.validateSlotIndex(slot);
            stack.func_190920_e(1);
            this.stacks.set(slot, (Object)stack);
            this.onContentsChanged(slot);
        }
    };
    private boolean active;

    public MetaTileEntityCreativeChest(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, 14, 0L);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        Textures.QUANTUM_STORAGE_RENDERER.renderMachine(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()))), this.getFrontFacing(), this.getTier());
        Textures.CREATIVE_CONTAINER_OVERLAY.renderSided(EnumFacing.UP, renderState, translation, pipeline);
        Textures.PIPE_OUT_OVERLAY.renderSided(this.getOutputFacing(), renderState, translation, pipeline);
        Textures.ITEM_OUTPUT_OVERLAY.renderSided(this.getOutputFacing(), renderState, translation, pipeline);
    }

    @Override
    public void renderMetaTileEntity(double x, double y, double z, float partialTicks) {
        QuantumStorageRenderer.renderChestStack(x, y, z, this, this.virtualItemStack, 420L, partialTicks);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityCreativeChest(this.metaTileEntityId);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 209).bindPlayerInventory(entityPlayer.field_71071_by, 126);
        builder.widget(new PhantomSlotWidget((IItemHandlerModifiable)this.handler, 0, 36, 6).setClearSlotOnRightClick(true).setBackgroundTexture(GuiTextures.SLOT).setChangeListener(this::markDirty));
        builder.label(7, 9, "gregtech.creative.chest.item");
        builder.widget(new ImageWidget(7, 48, 154, 14, GuiTextures.DISPLAY));
        builder.widget(new TextFieldWidget2(9, 50, 152, 10, () -> String.valueOf(this.itemsPerCycle), value -> {
            if (!value.isEmpty()) {
                this.itemsPerCycle = Integer.parseInt(value);
            }
        }).setMaxLength(11).setNumbersOnly(1, Integer.MAX_VALUE));
        builder.label(7, 28, "gregtech.creative.chest.ipc");
        builder.widget(new ImageWidget(7, 85, 154, 14, GuiTextures.DISPLAY));
        builder.widget(new TextFieldWidget2(9, 87, 152, 10, () -> String.valueOf(this.ticksPerCycle), value -> {
            if (!value.isEmpty()) {
                this.ticksPerCycle = Integer.parseInt(value);
            }
        }).setMaxLength(11).setNumbersOnly(1, Integer.MAX_VALUE));
        builder.label(7, 65, "gregtech.creative.chest.tpc");
        builder.widget(new CycleButtonWidget(7, 101, 162, 20, () -> this.active, value -> {
            this.active = value;
        }, "gregtech.creative.activity.off", "gregtech.creative.activity.on"));
        return builder.build(this.getHolder(), entityPlayer);
    }

    @Override
    public void update() {
        ItemStack stack;
        this.virtualItemStack = stack = this.handler.getStackInSlot(0).func_77946_l();
        super.update();
        if (this.ticksPerCycle == 0 || this.getOffsetTimer() % (long)this.ticksPerCycle != 0L) {
            return;
        }
        if (this.getWorld().field_72995_K || !this.active || stack.func_190926_b()) {
            return;
        }
        TileEntity tile = this.getNeighbor(this.getOutputFacing());
        if (tile != null) {
            IItemHandler container = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getOutputFacing().func_176734_d());
            if (container == null || container.getSlots() == 0) {
                return;
            }
            stack.func_190920_e(this.itemsPerCycle);
            ItemStack remainder = GTTransferUtils.insertItem(container, stack, true);
            int amountToInsert = stack.func_190916_E() - remainder.func_190916_E();
            if (amountToInsert > 0) {
                GTTransferUtils.insertItem(container, stack, false);
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("ItemStackHandler", (NBTBase)this.handler.serializeNBT());
        data.func_74768_a("ItemsPerCycle", this.itemsPerCycle);
        data.func_74768_a("TicksPerCycle", this.ticksPerCycle);
        data.func_74757_a("Active", this.active);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.handler.deserializeNBT(data.func_74775_l("ItemStackHandler"));
        this.virtualItemStack = this.handler.getStackInSlot(0);
        this.itemsPerCycle = data.func_74762_e("ItemsPerCycle");
        this.ticksPerCycle = data.func_74762_e("TicksPerCycle");
        this.active = data.func_74767_n("Active");
    }

    @Override
    public void initFromItemStackData(NBTTagCompound itemStack) {
        super.initFromItemStackData(itemStack);
        if (itemStack.func_150297_b("id", 8)) {
            this.handler.setStackInSlot(0, new ItemStack(itemStack));
        }
        this.itemsPerCycle = itemStack.func_74762_e("mBPerCycle");
        this.ticksPerCycle = itemStack.func_74762_e("ticksPerCycle");
    }

    @Override
    public void writeItemStackData(NBTTagCompound tag) {
        super.writeItemStackData(tag);
        ItemStack stack = this.handler.getStackInSlot(0);
        if (!stack.func_190926_b()) {
            stack.func_77955_b(tag);
        }
        tag.func_74768_a("mBPerCycle", this.itemsPerCycle);
        tag.func_74768_a("ticksPerCycle", this.ticksPerCycle);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.creative_tooltip.1", (Object[])new Object[0]) + TooltipHelper.RAINBOW + I18n.func_135052_a((String)"gregtech.creative_tooltip.2", (Object[])new Object[0]) + I18n.func_135052_a((String)"gregtech.creative_tooltip.3", (Object[])new Object[0]));
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.handler.setStackInSlot(0, this.virtualItemStack);
    }
}

