/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.Material;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.items.MetaItems;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityCrate
extends MetaTileEntity {
    private final Material material;
    private final int inventorySize;
    protected ItemStackHandler inventory;
    private boolean isTaped;
    private final String TAPED_NBT = "Taped";

    public MetaTileEntityCrate(ResourceLocation metaTileEntityId, Material material, int inventorySize) {
        super(metaTileEntityId);
        this.material = material;
        this.inventorySize = inventorySize;
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityCrate(this.metaTileEntityId, this.material, this.inventorySize);
    }

    @Override
    public boolean hasFrontFacing() {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    public String getHarvestTool() {
        return ModHandler.isMaterialWood(this.material) ? "axe" : "wrench";
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.inventory = new GTItemStackHandler((MetaTileEntity)this, this.inventorySize);
        this.itemInventory = this.inventory;
    }

    @Override
    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        if (!this.isTaped) {
            MetaTileEntityCrate.clearInventory(itemBuffer, (IItemHandlerModifiable)this.inventory);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        if (ModHandler.isMaterialWood(this.material)) {
            return Pair.of((Object)Textures.WOODEN_CRATE.getParticleTexture(), (Object)this.getPaintingColorForRendering());
        }
        int color = ColourRGBA.multiply((int)GTUtility.convertRGBtoOpaqueRGBA_CL(this.material.getMaterialRGB()), (int)GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()));
        color = GTUtility.convertOpaqueRGBA_CLtoRGB(color);
        return Pair.of((Object)Textures.METAL_CRATE.getParticleTexture(), (Object)color);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        NBTTagCompound tag;
        if (this.material.toString().contains("wood")) {
            Textures.WOODEN_CRATE.render(renderState, translation, GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()), pipeline);
        } else {
            int baseColor = ColourRGBA.multiply((int)GTUtility.convertRGBtoOpaqueRGBA_CL(this.material.getMaterialRGB()), (int)GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()));
            Textures.METAL_CRATE.render(renderState, translation, baseColor, pipeline);
        }
        boolean taped = this.isTaped;
        if (this.renderContextStack != null && this.renderContextStack.func_77978_p() != null && (tag = this.renderContextStack.func_77978_p()).func_74764_b("Taped") && tag.func_74767_n("Taped")) {
            taped = true;
        }
        if (taped) {
            Textures.TAPED_OVERLAY.render(renderState, translation, pipeline);
        }
    }

    @Override
    public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        int factor = this.inventorySize / 9 > 8 ? 18 : 9;
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176 + (factor == 18 ? 176 : 0), 8 + this.inventorySize / factor * 18 + 104).label(5, 5, this.getMetaFullName());
        for (int i = 0; i < this.inventorySize; ++i) {
            builder.slot((IItemHandlerModifiable)this.inventory, i, 7 * (factor == 18 ? 2 : 1) + i % factor * 18, 18 + i / factor * 18, GuiTextures.SLOT);
        }
        builder.bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT, 7 + (factor == 18 ? 88 : 0), 18 + this.inventorySize / factor * 18 + 11);
        return builder.build(this.getHolder(), entityPlayer);
    }

    @Override
    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (playerIn.func_70093_af() && !this.isTaped && (stack.func_77969_a(MetaItems.DUCT_TAPE.getStackForm()) || stack.func_77969_a(MetaItems.BASIC_TAPE.getStackForm()))) {
            if (!playerIn.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            this.isTaped = true;
            if (!this.getWorld().field_72995_K) {
                this.writeCustomData(GregtechDataCodes.IS_TAPED, buf -> buf.writeBoolean(this.isTaped));
                this.markDirty();
            }
            return true;
        }
        return super.onRightClick(playerIn, hand, facing, hitResult);
    }

    @Override
    public int getItemStackLimit(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74767_n("Taped")) {
            return 1;
        }
        return super.getItemStackLimit(stack);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("Inventory", (NBTBase)this.inventory.serializeNBT());
        data.func_74757_a("Taped", this.isTaped);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inventory.deserializeNBT(data.func_74775_l("Inventory"));
        if (data.func_74764_b("Taped")) {
            this.isTaped = data.func_74767_n("Taped");
        }
    }

    @Override
    public void initFromItemStackData(NBTTagCompound data) {
        super.initFromItemStackData(data);
        if (data.func_74764_b("PaintingColor")) {
            this.setPaintingColor(data.func_74762_e("PaintingColor"));
        }
        this.isTaped = data.func_74767_n("Taped");
        if (this.isTaped) {
            this.inventory.deserializeNBT(data.func_74775_l("Inventory"));
        }
        data.func_82580_o("Taped");
        data.func_82580_o("PaintingColor");
        this.isTaped = false;
    }

    @Override
    public void writeItemStackData(NBTTagCompound data) {
        super.writeItemStackData(data);
        if (this.isPainted()) {
            data.func_74768_a("PaintingColor", this.getPaintingColor());
        }
        if (this.isTaped) {
            data.func_74757_a("Taped", this.isTaped);
            data.func_74782_a("Inventory", (NBTBase)this.inventory.serializeNBT());
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.IS_TAPED) {
            this.isTaped = buf.readBoolean();
            this.scheduleRenderUpdate();
            this.markDirty();
        }
    }

    @Override
    protected boolean shouldSerializeInventories() {
        return false;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.item_storage_capacity", (Object[])new Object[]{this.inventorySize}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.crate.tooltip.taped_movement", (Object[])new Object[0]));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }
}

