/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class CraftingRecipeMemory {
    private final MemorizedRecipe[] memorizedRecipes;

    public CraftingRecipeMemory(int memorySize) {
        this.memorizedRecipes = new MemorizedRecipe[memorySize];
    }

    public void loadRecipe(int index, IItemHandlerModifiable craftingGrid) {
        MemorizedRecipe recipe = this.memorizedRecipes[index];
        if (recipe != null) {
            CraftingRecipeMemory.copyInventoryItems((IItemHandler)recipe.craftingMatrix, craftingGrid);
        }
    }

    @Nullable
    public MemorizedRecipe getRecipeAtIndex(int index) {
        return this.memorizedRecipes[index];
    }

    @Nullable
    private MemorizedRecipe offsetRecipe(int startIndex) {
        MemorizedRecipe previousRecipe = this.memorizedRecipes[startIndex];
        for (int i = startIndex + 1; i < this.memorizedRecipes.length; ++i) {
            MemorizedRecipe recipe = this.memorizedRecipes[i];
            if (recipe != null && recipe.recipeLocked) continue;
            this.memorizedRecipes[i] = previousRecipe;
            if (recipe == null) {
                return null;
            }
            previousRecipe = recipe;
        }
        return previousRecipe;
    }

    @Nullable
    private MemorizedRecipe findOrCreateRecipe(ItemStack resultItemStack) {
        for (MemorizedRecipe memorizedRecipe : this.memorizedRecipes) {
            if (memorizedRecipe == null || !ItemStack.func_77989_b((ItemStack)memorizedRecipe.recipeResult, (ItemStack)resultItemStack)) continue;
            return memorizedRecipe;
        }
        for (int i = 0; i < this.memorizedRecipes.length; ++i) {
            MemorizedRecipe memorizedRecipe;
            if (this.memorizedRecipes[i] == null) {
                memorizedRecipe = new MemorizedRecipe();
            } else {
                if (this.memorizedRecipes[i].recipeLocked) continue;
                memorizedRecipe = this.offsetRecipe(i);
                if (memorizedRecipe == null) {
                    memorizedRecipe = new MemorizedRecipe();
                }
            }
            memorizedRecipe.initialize(resultItemStack);
            this.memorizedRecipes[i] = memorizedRecipe;
            return memorizedRecipe;
        }
        return null;
    }

    public void notifyRecipePerformed(IItemHandler craftingGrid, ItemStack resultStack) {
        MemorizedRecipe recipe = this.findOrCreateRecipe(resultStack);
        if (recipe != null) {
            recipe.updateCraftingMatrix(craftingGrid);
            recipe.timesUsed++;
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        NBTTagList resultList = new NBTTagList();
        tagCompound.func_74782_a("Memory", (NBTBase)resultList);
        for (int i = 0; i < this.memorizedRecipes.length; ++i) {
            MemorizedRecipe recipe = this.memorizedRecipes[i];
            if (recipe == null) continue;
            NBTTagCompound entryComponent = new NBTTagCompound();
            entryComponent.func_74768_a("Slot", i);
            entryComponent.func_74782_a("Recipe", (NBTBase)recipe.serializeNBT());
            resultList.func_74742_a((NBTBase)entryComponent);
        }
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound tagCompound) {
        NBTTagList resultList = tagCompound.func_150295_c("Memory", 10);
        for (int i = 0; i < resultList.func_74745_c(); ++i) {
            MemorizedRecipe recipe;
            NBTTagCompound entryComponent = resultList.func_150305_b(i);
            int slotIndex = entryComponent.func_74762_e("Slot");
            this.memorizedRecipes[slotIndex] = recipe = MemorizedRecipe.deserializeNBT(entryComponent.func_74775_l("Recipe"));
        }
    }

    private static void copyInventoryItems(IItemHandler src, IItemHandlerModifiable dest) {
        for (int i = 0; i < src.getSlots(); ++i) {
            ItemStack itemStack = src.getStackInSlot(i);
            dest.setStackInSlot(i, itemStack.func_190926_b() ? ItemStack.field_190927_a : itemStack.func_77946_l());
        }
    }

    public static class MemorizedRecipe {
        private final ItemStackHandler craftingMatrix = new ItemStackHandler(9);
        private ItemStack recipeResult;
        private boolean recipeLocked = false;
        private int timesUsed = 0;

        private MemorizedRecipe() {
        }

        private NBTTagCompound serializeNBT() {
            NBTTagCompound result = new NBTTagCompound();
            result.func_74782_a("Result", (NBTBase)this.recipeResult.serializeNBT());
            result.func_74782_a("Matrix", (NBTBase)this.craftingMatrix.serializeNBT());
            result.func_74757_a("Locked", this.recipeLocked);
            result.func_74768_a("TimesUsed", this.timesUsed);
            return result;
        }

        private static MemorizedRecipe deserializeNBT(NBTTagCompound tagCompound) {
            MemorizedRecipe recipe = new MemorizedRecipe();
            recipe.recipeResult = new ItemStack(tagCompound.func_74775_l("Result"));
            recipe.craftingMatrix.deserializeNBT(tagCompound.func_74775_l("Matrix"));
            recipe.recipeLocked = tagCompound.func_74767_n("Locked");
            recipe.timesUsed = tagCompound.func_74762_e("TimesUsed");
            return recipe;
        }

        private void initialize(ItemStack recipeResult) {
            this.recipeResult = recipeResult.func_77946_l();
            for (int i = 0; i < this.craftingMatrix.getSlots(); ++i) {
                this.craftingMatrix.setStackInSlot(i, ItemStack.field_190927_a);
            }
            this.recipeLocked = false;
            this.timesUsed = 0;
        }

        private void updateCraftingMatrix(IItemHandler craftingGrid) {
            if (!this.recipeLocked) {
                CraftingRecipeMemory.copyInventoryItems(craftingGrid, (IItemHandlerModifiable)this.craftingMatrix);
            }
        }

        public ItemStack getRecipeResult() {
            return this.recipeResult;
        }

        public boolean isRecipeLocked() {
            return this.recipeLocked;
        }

        public void setRecipeLocked(boolean recipeLocked) {
            this.recipeLocked = recipeLocked;
        }
    }
}

