/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.hpca;

import gregtech.api.GTValues;
import gregtech.api.capability.IHPCACoolantProvider;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.common.metatileentities.multi.multiblockpart.hpca.MetaTileEntityHPCAComponent;
import net.minecraft.util.ResourceLocation;

public class MetaTileEntityHPCACooler
extends MetaTileEntityHPCAComponent
implements IHPCACoolantProvider {
    private final boolean advanced;

    public MetaTileEntityHPCACooler(ResourceLocation metaTileEntityId, boolean advanced) {
        super(metaTileEntityId);
        this.advanced = advanced;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityHPCACooler(this.metaTileEntityId, this.advanced);
    }

    @Override
    public boolean isAdvanced() {
        return this.advanced;
    }

    @Override
    public SimpleOverlayRenderer getFrontOverlay() {
        return this.advanced ? Textures.HPCA_ACTIVE_COOLER_OVERLAY : Textures.HPCA_HEAT_SINK_OVERLAY;
    }

    @Override
    public TextureArea getComponentIcon() {
        return this.advanced ? GuiTextures.HPCA_ICON_ACTIVE_COOLER_COMPONENT : GuiTextures.HPCA_ICON_HEAT_SINK_COMPONENT;
    }

    @Override
    public SimpleOverlayRenderer getFrontActiveOverlay() {
        return this.advanced ? Textures.HPCA_ACTIVE_COOLER_ACTIVE_OVERLAY : this.getFrontOverlay();
    }

    @Override
    public int getUpkeepEUt() {
        return this.advanced ? GTValues.VA[5] : 0;
    }

    @Override
    public boolean canBeDamaged() {
        return false;
    }

    @Override
    public int getCoolingAmount() {
        return this.advanced ? 2 : 1;
    }

    @Override
    public boolean isActiveCooler() {
        return this.advanced;
    }

    @Override
    public int getMaxCoolantPerTick() {
        return this.advanced ? 8 : 0;
    }
}

