/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.appeng.stack;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.Api;
import appeng.util.item.AEItemStack;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrappedItemStack
implements IAEItemStack {
    @NotNull
    ItemStack delegate;

    private WrappedItemStack(@NotNull ItemStack itemStack) {
        this.delegate = itemStack;
    }

    @Nullable
    public static WrappedItemStack fromItemStack(@NotNull ItemStack stack) {
        return stack.func_190926_b() ? null : new WrappedItemStack(stack);
    }

    public static WrappedItemStack fromNBT(NBTTagCompound i) {
        if (i == null) {
            return null;
        }
        ItemStack itemstack = new ItemStack(i);
        return WrappedItemStack.fromItemStack(itemstack);
    }

    public static WrappedItemStack fromPacket(ByteBuf data) {
        return WrappedItemStack.fromNBT(ByteBufUtils.readTag((ByteBuf)data));
    }

    public AEItemStack getAEStack() {
        return AEItemStack.fromItemStack((ItemStack)this.delegate);
    }

    public ItemStack createItemStack() {
        return this.delegate.func_77946_l();
    }

    public boolean hasTagCompound() {
        return this.delegate.func_77942_o();
    }

    public void add(IAEItemStack iaeItemStack) {
        this.delegate.func_190917_f((int)iaeItemStack.getStackSize());
    }

    public long getStackSize() {
        return this.delegate.func_190916_E();
    }

    public IAEItemStack setStackSize(long l) {
        this.delegate.func_190920_e((int)l);
        return this;
    }

    public long getCountRequestable() {
        return 0L;
    }

    public IAEItemStack setCountRequestable(long l) {
        return this;
    }

    public boolean isCraftable() {
        return false;
    }

    public IAEItemStack setCraftable(boolean b) {
        return this;
    }

    public IAEItemStack reset() {
        this.delegate.func_190920_e(0);
        return this;
    }

    public boolean isMeaningful() {
        return !this.delegate.func_190926_b();
    }

    public void incStackSize(long l) {
        this.delegate.func_190917_f((int)l);
    }

    public void decStackSize(long l) {
        this.delegate.func_190918_g((int)l);
    }

    public void incCountRequestable(long l) {
    }

    public void decCountRequestable(long l) {
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        this.delegate.func_77955_b(nbtTagCompound);
    }

    public boolean fuzzyComparison(IAEItemStack stack, FuzzyMode fuzzyMode) {
        return stack.createItemStack().func_77969_a(this.delegate);
    }

    public void writeToPacket(ByteBuf byteBuf) {
        ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)this.delegate.serializeNBT());
    }

    public IAEItemStack copy() {
        return new WrappedItemStack(this.delegate.func_77946_l());
    }

    public IAEItemStack empty() {
        IAEItemStack copy = this.copy();
        copy.reset();
        return copy;
    }

    public boolean isItem() {
        return true;
    }

    public boolean isFluid() {
        return false;
    }

    public IStorageChannel<IAEItemStack> getChannel() {
        return Api.INSTANCE.storage().getStorageChannel(IItemStorageChannel.class);
    }

    public ItemStack asItemStackRepresentation() {
        return this.delegate;
    }

    public Item getItem() {
        return this.delegate.func_77973_b();
    }

    public int getItemDamage() {
        return this.delegate.func_77952_i();
    }

    public boolean sameOre(IAEItemStack iaeItemStack) {
        return false;
    }

    public boolean isSameType(IAEItemStack iaeItemStack) {
        return false;
    }

    public boolean isSameType(ItemStack itemStack) {
        return false;
    }

    public ItemStack getDefinition() {
        return this.delegate;
    }

    public boolean equals(ItemStack itemStack) {
        return this.delegate.func_77969_a(itemStack);
    }

    public boolean equals(Object other) {
        if (other instanceof IAEItemStack) {
            return this.delegate.func_77969_a(((IAEItemStack)other).createItemStack());
        }
        if (other instanceof ItemStack) {
            return this.delegate.func_77969_a((ItemStack)other);
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.delegate.func_77973_b().hashCode();
        result = 31 * result + this.delegate.func_77952_i();
        result = 31 * result + (this.delegate.func_77978_p() == null ? 0 : this.delegate.func_77978_p().hashCode());
        return result;
    }

    public ItemStack getCachedItemStack(long l) {
        ItemStack copy = this.delegate.func_77946_l();
        copy.func_190920_e((int)l);
        return copy;
    }

    public void setCachedItemStack(ItemStack itemStack) {
        this.delegate = itemStack;
    }
}

