/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.appeng;

import appeng.api.config.Actionable;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.INotifiableHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.gui.widget.appeng.AEFluidConfigWidget;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.ExportOnlyAESlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.MetaTileEntityAEHostablePart;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.stack.WrappedFluidStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityMEInputHatch
extends MetaTileEntityAEHostablePart
implements IMultiblockAbilityPart<IFluidTank> {
    public static final String FLUID_BUFFER_TAG = "FluidTanks";
    public static final String WORKING_TAG = "WorkingEnabled";
    private static final int CONFIG_SIZE = 16;
    private boolean workingEnabled = true;
    private ExportOnlyAEFluid[] aeFluidTanks;

    public MetaTileEntityMEInputHatch(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, 9, false);
    }

    @Override
    protected void initializeInventory() {
        this.aeFluidTanks = new ExportOnlyAEFluid[16];
        for (int i = 0; i < 16; ++i) {
            this.aeFluidTanks[i] = new ExportOnlyAEFluid(this, null, null, this.getController());
        }
        super.initializeInventory();
    }

    @Override
    protected FluidTankList createImportFluidHandler() {
        return new FluidTankList(false, this.aeFluidTanks);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.workingEnabled && this.shouldSyncME() && this.updateMEStatus()) {
            try {
                IMEMonitor aeNetwork = this.getProxy().getStorage().getInventory(FLUID_NET);
                for (ExportOnlyAEFluid aeTank : this.aeFluidTanks) {
                    IAEFluidStack extracted;
                    IAEFluidStack reqFluid;
                    IAEFluidStack exceedFluid = aeTank.exceedStack();
                    if (exceedFluid != null) {
                        long total = exceedFluid.getStackSize();
                        IAEFluidStack notInserted = (IAEFluidStack)aeNetwork.injectItems((IAEStack)exceedFluid, Actionable.MODULATE, this.getActionSource());
                        if (notInserted != null && notInserted.getStackSize() > 0L) {
                            aeTank.drain((int)(total - notInserted.getStackSize()), true);
                            continue;
                        }
                        aeTank.drain((int)total, true);
                    }
                    if ((reqFluid = aeTank.requestStack()) == null || (extracted = (IAEFluidStack)aeNetwork.extractItems((IAEStack)reqFluid, Actionable.MODULATE, this.getActionSource())) == null) continue;
                    aeTank.addStack(extracted);
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onRemoval() {
        try {
            IMEMonitor aeNetwork = this.getProxy().getStorage().getInventory(FLUID_NET);
            for (ExportOnlyAEFluid aeTank : this.aeFluidTanks) {
                IAEFluidStack stock = (IAEFluidStack)aeTank.stock;
                if (stock instanceof WrappedFluidStack) {
                    stock = ((WrappedFluidStack)stock).getAEStack();
                }
                if (stock == null) continue;
                aeNetwork.injectItems((IAEStack)stock, Actionable.MODULATE, this.getActionSource());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        super.onRemoval();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityMEInputHatch(this.metaTileEntityId);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 184).label(10, 5, this.getMetaFullName());
        builder.dynamicLabel(10, 15, () -> this.isOnline ? I18n.func_135052_a((String)"gregtech.gui.me_network.online", (Object[])new Object[0]) : I18n.func_135052_a((String)"gregtech.gui.me_network.offline", (Object[])new Object[0]), -1);
        builder.widget(new AEFluidConfigWidget(16, 25, this.aeFluidTanks));
        builder.bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT, 7, 102);
        return builder.build(this.getHolder(), entityPlayer);
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        World world = this.getWorld();
        if (world != null && !world.field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(workingEnabled));
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.workingEnabled);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.workingEnabled = buf.readBoolean();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a(WORKING_TAG, this.workingEnabled);
        NBTTagList tanks = new NBTTagList();
        for (int i = 0; i < 16; ++i) {
            ExportOnlyAEFluid tank = this.aeFluidTanks[i];
            NBTTagCompound tankTag = new NBTTagCompound();
            tankTag.func_74768_a("slot", i);
            tankTag.func_74782_a("tank", (NBTBase)tank.serializeNBT());
            tanks.func_74742_a((NBTBase)tankTag);
        }
        data.func_74782_a(FLUID_BUFFER_TAG, (NBTBase)tanks);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(WORKING_TAG)) {
            this.workingEnabled = data.func_74767_n(WORKING_TAG);
        }
        if (data.func_150297_b(FLUID_BUFFER_TAG, 9)) {
            NBTTagList tanks = (NBTTagList)data.func_74781_a(FLUID_BUFFER_TAG);
            for (NBTBase nbtBase : tanks) {
                NBTTagCompound tankTag = (NBTTagCompound)nbtBase;
                ExportOnlyAEFluid tank = this.aeFluidTanks[tankTag.func_74762_e("slot")];
                tank.deserializeNBT(tankTag.func_74775_l("tank"));
            }
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            Textures.ME_INPUT_HATCH.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_hatch.import.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.fluid_import.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    @Override
    public MultiblockAbility<IFluidTank> getAbility() {
        return MultiblockAbility.IMPORT_FLUIDS;
    }

    @Override
    public void registerAbilities(List<IFluidTank> list) {
        list.addAll(Arrays.asList(this.aeFluidTanks));
    }

    public static class ExportOnlyAEFluid
    extends ExportOnlyAESlot<IAEFluidStack>
    implements IFluidTank,
    INotifiableHandler,
    IFluidHandler {
        private final List<MetaTileEntity> notifiableEntities = new ArrayList<MetaTileEntity>();
        private MetaTileEntity holder;

        public ExportOnlyAEFluid(MetaTileEntity holder, IAEFluidStack config, IAEFluidStack stock, MetaTileEntity mte) {
            super(config, stock);
            this.holder = holder;
            this.notifiableEntities.add(mte);
        }

        public ExportOnlyAEFluid() {
        }

        @Override
        public IAEFluidStack requestStack() {
            IAEFluidStack result = (IAEFluidStack)super.requestStack();
            if (result instanceof WrappedFluidStack) {
                return ((WrappedFluidStack)result).getAEStack();
            }
            return result;
        }

        @Override
        public IAEFluidStack exceedStack() {
            IAEFluidStack result = (IAEFluidStack)super.exceedStack();
            if (result instanceof WrappedFluidStack) {
                return ((WrappedFluidStack)result).getAEStack();
            }
            return result;
        }

        @Override
        public void addStack(IAEFluidStack stack) {
            if (this.stock == null) {
                this.stock = WrappedFluidStack.fromFluidStack(stack.getFluidStack());
            } else {
                ((IAEFluidStack)this.stock).add(stack);
            }
            this.trigger();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("config")) {
                this.config = WrappedFluidStack.fromNBT(nbt.func_74775_l("config"));
            }
            if (nbt.func_74764_b("stock")) {
                this.stock = WrappedFluidStack.fromNBT(nbt.func_74775_l("stock"));
            }
        }

        @Nullable
        public FluidStack getFluid() {
            if (this.stock != null && this.stock instanceof WrappedFluidStack) {
                return ((WrappedFluidStack)this.stock).getDelegate();
            }
            return null;
        }

        public int getFluidAmount() {
            return this.stock != null ? (int)((IAEFluidStack)this.stock).getStackSize() : 0;
        }

        public int getCapacity() {
            return 0;
        }

        public FluidTankInfo getInfo() {
            return new FluidTankInfo((IFluidTank)this);
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new FluidTankProperties(this.getFluid(), 0)};
        }

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (this.getFluid() != null && this.getFluid().isFluidEqual(resource)) {
                return this.drain(resource.amount, doDrain);
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.stock == null) {
                return null;
            }
            int drained = (int)Math.min(((IAEFluidStack)this.stock).getStackSize(), (long)maxDrain);
            FluidStack result = new FluidStack(((IAEFluidStack)this.stock).getFluid(), drained);
            if (doDrain) {
                ((IAEFluidStack)this.stock).decStackSize((long)drained);
                if (((IAEFluidStack)this.stock).getStackSize() == 0L) {
                    this.stock = null;
                }
                this.trigger();
            }
            return result;
        }

        @Override
        public void addNotifiableMetaTileEntity(MetaTileEntity metaTileEntity) {
            this.notifiableEntities.add(metaTileEntity);
        }

        @Override
        public void removeNotifiableMetaTileEntity(MetaTileEntity metaTileEntity) {
            this.notifiableEntities.remove(metaTileEntity);
        }

        private void trigger() {
            for (MetaTileEntity metaTileEntity : this.notifiableEntities) {
                if (metaTileEntity == null || !metaTileEntity.isValid()) continue;
                this.addToNotifiedList(metaTileEntity, this, false);
            }
            if (this.holder != null) {
                this.holder.markDirty();
            }
        }

        public ExportOnlyAEFluid copy() {
            return new ExportOnlyAEFluid(this.holder, this.config == null ? null : ((IAEFluidStack)this.config).copy(), this.stock == null ? null : ((IAEFluidStack)this.stock).copy(), null);
        }
    }
}

