/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.appeng;

import appeng.api.config.Actionable;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.gui.widget.appeng.AEItemConfigWidget;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.ExportOnlyAESlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.MetaTileEntityAEHostablePart;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.stack.WrappedItemStack;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityMEInputBus
extends MetaTileEntityAEHostablePart
implements IMultiblockAbilityPart<IItemHandlerModifiable> {
    public static final String ITEM_BUFFER_TAG = "ItemSlots";
    public static final String WORKING_TAG = "WorkingEnabled";
    private static final int CONFIG_SIZE = 16;
    private boolean workingEnabled = true;
    private ExportOnlyAEItemList aeItemHandler;

    public MetaTileEntityMEInputBus(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, 9, false);
    }

    @Override
    protected void initializeInventory() {
        this.aeItemHandler = new ExportOnlyAEItemList(this, 16, this.getController());
        super.initializeInventory();
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return this.aeItemHandler;
    }

    @Override
    public IItemHandlerModifiable getImportItems() {
        this.importItems = this.aeItemHandler;
        return super.getImportItems();
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.workingEnabled && this.shouldSyncME() && this.updateMEStatus()) {
            try {
                IMEMonitor aeNetwork = this.getProxy().getStorage().getInventory(ITEM_NET);
                for (ExportOnlyAEItem aeSlot : this.aeItemHandler.inventory) {
                    IAEItemStack extracted;
                    IAEItemStack reqItem;
                    IAEItemStack exceedItem = aeSlot.exceedStack();
                    if (exceedItem != null) {
                        long total = exceedItem.getStackSize();
                        IAEItemStack notInserted = (IAEItemStack)aeNetwork.injectItems((IAEStack)exceedItem, Actionable.MODULATE, this.getActionSource());
                        if (notInserted != null && notInserted.getStackSize() > 0L) {
                            aeSlot.extractItem(0, (int)(total - notInserted.getStackSize()), false);
                            continue;
                        }
                        aeSlot.extractItem(0, (int)total, false);
                    }
                    if ((reqItem = aeSlot.requestStack()) == null || (extracted = (IAEItemStack)aeNetwork.extractItems((IAEStack)reqItem, Actionable.MODULATE, this.getActionSource())) == null) continue;
                    aeSlot.addStack(extracted);
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onRemoval() {
        try {
            IMEMonitor aeNetwork = this.getProxy().getStorage().getInventory(ITEM_NET);
            for (ExportOnlyAEItem aeSlot : this.aeItemHandler.inventory) {
                IAEItemStack stock = (IAEItemStack)aeSlot.stock;
                if (stock instanceof WrappedItemStack) {
                    stock = ((WrappedItemStack)stock).getAEStack();
                }
                if (stock == null) continue;
                aeNetwork.injectItems((IAEStack)stock, Actionable.MODULATE, this.getActionSource());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        super.onRemoval();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityMEInputBus(this.metaTileEntityId);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 184).label(10, 5, this.getMetaFullName());
        builder.dynamicLabel(10, 15, () -> this.isOnline ? I18n.func_135052_a((String)"gregtech.gui.me_network.online", (Object[])new Object[0]) : I18n.func_135052_a((String)"gregtech.gui.me_network.offline", (Object[])new Object[0]), -1);
        builder.widget(new AEItemConfigWidget(16, 25, this.aeItemHandler.inventory));
        builder.bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT, 7, 102);
        return builder.build(this.getHolder(), entityPlayer);
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        World world = this.getWorld();
        if (world != null && !world.field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(workingEnabled));
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.workingEnabled);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.workingEnabled = buf.readBoolean();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a(WORKING_TAG, this.workingEnabled);
        NBTTagList slots = new NBTTagList();
        for (int i = 0; i < 16; ++i) {
            ExportOnlyAEItem slot = this.aeItemHandler.inventory[i];
            NBTTagCompound slotTag = new NBTTagCompound();
            slotTag.func_74768_a("slot", i);
            slotTag.func_74782_a("stack", (NBTBase)slot.serializeNBT());
            slots.func_74742_a((NBTBase)slotTag);
        }
        data.func_74782_a(ITEM_BUFFER_TAG, (NBTBase)slots);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(WORKING_TAG)) {
            this.workingEnabled = data.func_74767_n(WORKING_TAG);
        }
        if (data.func_150297_b(ITEM_BUFFER_TAG, 9)) {
            NBTTagList slots = (NBTTagList)data.func_74781_a(ITEM_BUFFER_TAG);
            for (NBTBase nbtBase : slots) {
                NBTTagCompound slotTag = (NBTTagCompound)nbtBase;
                ExportOnlyAEItem slot = this.aeItemHandler.inventory[slotTag.func_74762_e("slot")];
                slot.deserializeNBT(slotTag.func_74775_l("stack"));
            }
        }
        this.importItems = this.createImportItemHandler();
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            Textures.ME_INPUT_BUS.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.item_bus.import.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.item_import.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    @Override
    public MultiblockAbility<IItemHandlerModifiable> getAbility() {
        return MultiblockAbility.IMPORT_ITEMS;
    }

    @Override
    public void registerAbilities(List<IItemHandlerModifiable> list) {
        list.add(this.aeItemHandler);
    }

    private static class ExportOnlyAEItemList
    extends NotifiableItemStackHandler {
        ExportOnlyAEItem[] inventory = new ExportOnlyAEItem[16];

        public ExportOnlyAEItemList(MetaTileEntity holder, int slots, MetaTileEntity entityToNotify) {
            super(holder, slots, entityToNotify, false);
            for (int i = 0; i < 16; ++i) {
                this.inventory[i] = new ExportOnlyAEItem(null, null);
            }
            for (ExportOnlyAEItem slot : this.inventory) {
                slot.trigger = this::onContentsChanged;
            }
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            for (int index = 0; index < 16; ++index) {
                if (!nbt.func_74764_b("#" + index)) continue;
                NBTTagCompound slotTag = nbt.func_74775_l("#" + index);
                this.inventory[index].deserializeNBT(slotTag);
            }
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            for (int index = 0; index < 16; ++index) {
                NBTTagCompound slot = this.inventory[index].serializeNBT();
                nbt.func_74782_a("#" + index, (NBTBase)slot);
            }
            return nbt;
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        }

        public int getSlots() {
            return 16;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (slot >= 0 && slot < 16) {
                return this.inventory[slot].getStackInSlot(0);
            }
            return ItemStack.field_190927_a;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot >= 0 && slot < 16) {
                return this.inventory[slot].extractItem(0, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return Integer.MAX_VALUE;
        }
    }

    public static class ExportOnlyAEItem
    extends ExportOnlyAESlot<IAEItemStack>
    implements IItemHandlerModifiable {
        private Consumer<Integer> trigger;

        public ExportOnlyAEItem(IAEItemStack config, IAEItemStack stock) {
            super(config, stock);
        }

        public ExportOnlyAEItem() {
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("config")) {
                this.config = WrappedItemStack.fromNBT(nbt.func_74775_l("config"));
            }
            if (nbt.func_74764_b("stock")) {
                this.stock = WrappedItemStack.fromNBT(nbt.func_74775_l("stock"));
            }
        }

        public ExportOnlyAEItem copy() {
            return new ExportOnlyAEItem(this.config == null ? null : ((IAEItemStack)this.config).copy(), this.stock == null ? null : ((IAEItemStack)this.stock).copy());
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        }

        public int getSlots() {
            return 1;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (slot == 0 && this.stock != null) {
                return ((IAEItemStack)this.stock).getDefinition();
            }
            return ItemStack.field_190927_a;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0 && this.stock != null) {
                int extracted = (int)Math.min(((IAEItemStack)this.stock).getStackSize(), (long)amount);
                ItemStack result = ((IAEItemStack)this.stock).createItemStack();
                result.func_190920_e(extracted);
                if (!simulate) {
                    ((IAEItemStack)this.stock).decStackSize((long)extracted);
                    if (((IAEItemStack)this.stock).getStackSize() == 0L) {
                        this.stock = null;
                    }
                }
                if (this.trigger != null) {
                    this.trigger.accept(0);
                }
                return result;
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public IAEItemStack requestStack() {
            IAEItemStack result = (IAEItemStack)super.requestStack();
            if (result instanceof WrappedItemStack) {
                return ((WrappedItemStack)result).getAEStack();
            }
            return result;
        }

        @Override
        public IAEItemStack exceedStack() {
            IAEItemStack result = (IAEItemStack)super.exceedStack();
            if (result instanceof WrappedItemStack) {
                return ((WrappedItemStack)result).getAEStack();
            }
            return result;
        }

        @Override
        public void addStack(IAEItemStack stack) {
            if (this.stock == null) {
                this.stock = WrappedItemStack.fromItemStack(stack.createItemStack());
            } else {
                ((IAEItemStack)this.stock).add(stack);
            }
            this.trigger.accept(0);
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }
    }
}

