/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.appeng;

import appeng.api.AEApi;
import appeng.api.networking.GridFlags;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.BaseActionSource;
import appeng.me.helpers.IGridProxyable;
import appeng.me.helpers.MachineSource;
import gregtech.api.capability.IControllable;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockNotifiablePart;
import java.io.IOException;
import java.util.EnumSet;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetaTileEntityAEHostablePart
extends MetaTileEntityMultiblockNotifiablePart
implements IControllable {
    protected static final IStorageChannel<IAEItemStack> ITEM_NET = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    protected static final IStorageChannel<IAEFluidStack> FLUID_NET = AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    private static final int ME_UPDATE_INTERVAL = ConfigHolder.compat.ae2.updateIntervals;
    private AENetworkProxy aeProxy;
    private int meUpdateTick = 0;
    protected boolean isOnline;
    private static final int ONLINE_ID = 6666;

    public MetaTileEntityAEHostablePart(ResourceLocation metaTileEntityId, int tier, boolean isExportHatch) {
        super(metaTileEntityId, tier, isExportHatch);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            ++this.meUpdateTick;
        }
    }

    @Override
    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        if (this.aeProxy != null) {
            buf.writeBoolean(true);
            NBTTagCompound proxy = new NBTTagCompound();
            this.aeProxy.writeToNBT(proxy);
            buf.func_150786_a(proxy);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.meUpdateTick);
        buf.writeBoolean(this.isOnline);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        if (buf.readBoolean()) {
            NBTTagCompound nbtTagCompound;
            try {
                nbtTagCompound = buf.func_150793_b();
            }
            catch (IOException ignored) {
                nbtTagCompound = null;
            }
            if (this.aeProxy != null && nbtTagCompound != null) {
                this.aeProxy.readFromNBT(nbtTagCompound);
            }
        }
        this.meUpdateTick = buf.readInt();
        this.isOnline = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 6666) {
            this.isOnline = buf.readBoolean();
        }
    }

    @Override
    public ICubeRenderer getBaseTexture() {
        MultiblockControllerBase controller = this.getController();
        if (controller != null) {
            this.hatchTexture = controller.getBaseTexture(this);
            return this.hatchTexture;
        }
        if (this.hatchTexture != null) {
            if (this.hatchTexture != Textures.getInactiveTexture(this.hatchTexture)) {
                this.hatchTexture = Textures.getInactiveTexture(this.hatchTexture);
                return this.hatchTexture;
            }
            return this.hatchTexture;
        }
        return Textures.VOLTAGE_CASINGS[4];
    }

    @Override
    @NotNull
    public AECableType getCableConnectionType(@NotNull AEPartLocation part) {
        if (part.getFacing() != this.frontFacing) {
            return AECableType.NONE;
        }
        return AECableType.SMART;
    }

    @Override
    @Nullable
    public AENetworkProxy getProxy() {
        if (this.aeProxy == null) {
            this.aeProxy = this.createProxy();
            return this.aeProxy;
        }
        if (!this.aeProxy.isReady() && this.getWorld() != null) {
            this.aeProxy.onReady();
        }
        return this.aeProxy;
    }

    @Override
    public void setFrontFacing(EnumFacing frontFacing) {
        super.setFrontFacing(frontFacing);
        if (this.aeProxy != null) {
            this.aeProxy.setValidSides(EnumSet.of(this.getFrontFacing()));
        }
    }

    @Override
    public void gridChanged() {
    }

    public boolean updateMEStatus() {
        this.isOnline = this.aeProxy != null ? this.aeProxy.isActive() && this.aeProxy.isPowered() : false;
        this.writeCustomData(6666, buf -> buf.writeBoolean(this.isOnline));
        return this.isOnline;
    }

    protected boolean shouldSyncME() {
        return this.meUpdateTick % ME_UPDATE_INTERVAL == 0;
    }

    protected IActionSource getActionSource() {
        if (this.getHolder() instanceof IActionHost) {
            return new MachineSource((IActionHost)this.getHolder());
        }
        return new BaseActionSource();
    }

    @Nullable
    private AENetworkProxy createProxy() {
        if (this.getHolder() instanceof IGridProxyable) {
            AENetworkProxy proxy = new AENetworkProxy((IGridProxyable)this.getHolder(), "mte_proxy", this.getStackForm(), true);
            proxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            proxy.setIdlePowerUsage(ConfigHolder.compat.ae2.meHatchEnergyUsage);
            proxy.setValidSides(EnumSet.of(this.getFrontFacing()));
            return proxy;
        }
        return null;
    }
}

