/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IDataAccessHatch;
import gregtech.api.capability.IOpticalDataAccessHatch;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.recipes.Recipe;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockNotifiablePart;
import gregtech.common.pipelike.optical.tile.TileEntityOpticalPipe;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class MetaTileEntityOpticalDataHatch
extends MetaTileEntityMultiblockNotifiablePart
implements IMultiblockAbilityPart<IOpticalDataAccessHatch>,
IOpticalDataAccessHatch {
    private final boolean isTransmitter;

    public MetaTileEntityOpticalDataHatch(ResourceLocation metaTileEntityId, boolean isTransmitter) {
        super(metaTileEntityId, 6, false);
        this.isTransmitter = isTransmitter;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityOpticalDataHatch(this.metaTileEntityId, this.isTransmitter);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            if (this.isTransmitter()) {
                Textures.OPTICAL_DATA_ACCESS_HATCH.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            } else {
                Textures.OPTICAL_DATA_ACCESS_HATCH.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            }
        }
    }

    @Override
    public boolean isRecipeAvailable(@NotNull Recipe recipe, @NotNull Collection<IDataAccessHatch> seen) {
        seen.add(this);
        if (this.isAttachedToMultiBlock()) {
            if (this.isTransmitter()) {
                MultiblockControllerBase controller = this.getController();
                if (!controller.isActive()) {
                    return false;
                }
                return MetaTileEntityOpticalDataHatch.isRecipeAvailable(controller.getAbilities(MultiblockAbility.DATA_ACCESS_HATCH), seen, recipe) || MetaTileEntityOpticalDataHatch.isRecipeAvailable(controller.getAbilities(MultiblockAbility.OPTICAL_DATA_RECEPTION), seen, recipe);
            }
            TileEntity tileEntity = this.getNeighbor(this.getFrontFacing());
            if (tileEntity == null) {
                return false;
            }
            if (tileEntity instanceof TileEntityOpticalPipe) {
                IDataAccessHatch cap = (IDataAccessHatch)tileEntity.getCapability(GregtechTileCapabilities.CAPABILITY_DATA_ACCESS, this.getFrontFacing().func_176734_d());
                return cap != null && cap.isRecipeAvailable(recipe, seen);
            }
        }
        return false;
    }

    private static boolean isRecipeAvailable(@NotNull Iterable<? extends IDataAccessHatch> hatches, @NotNull Collection<IDataAccessHatch> seen, @NotNull Recipe recipe) {
        for (IDataAccessHatch iDataAccessHatch : hatches) {
            if (seen.contains(iDataAccessHatch) || !iDataAccessHatch.isRecipeAvailable(recipe, seen)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCreative() {
        return false;
    }

    @Override
    public boolean isTransmitter() {
        return this.isTransmitter;
    }

    @Override
    public boolean canPartShare() {
        return false;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (side == this.getFrontFacing() && capability == GregtechTileCapabilities.CAPABILITY_DATA_ACCESS) {
            return (T)GregtechTileCapabilities.CAPABILITY_DATA_ACCESS.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public MultiblockAbility<IOpticalDataAccessHatch> getAbility() {
        return this.isTransmitter() ? MultiblockAbility.OPTICAL_DATA_TRANSMISSION : MultiblockAbility.OPTICAL_DATA_RECEPTION;
    }

    @Override
    public void registerAbilities(@NotNull List<IOpticalDataAccessHatch> abilityList) {
        abilityList.add(this);
    }
}

