/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IObjectHolder;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.BlockableSlotWidget;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IDataItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockNotifiablePart;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class MetaTileEntityObjectHolder
extends MetaTileEntityMultiblockNotifiablePart
implements IMultiblockAbilityPart<IObjectHolder>,
IObjectHolder {
    private final ObjectHolderHandler heldItems = new ObjectHolderHandler(this);
    private boolean isLocked;

    public MetaTileEntityObjectHolder(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, 7, false);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityObjectHolder(this.metaTileEntityId);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return ModularUI.defaultBuilder().label(5, 5, this.getMetaFullName()).image(46, 18, 84, 60, GuiTextures.PROGRESS_BAR_RESEARCH_STATION_BASE).widget(new BlockableSlotWidget(this.heldItems, 0, 79, 39).setIsBlocked(this::isSlotBlocked).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.RESEARCH_STATION_OVERLAY)).widget(new BlockableSlotWidget(this.heldItems, 1, 15, 39).setIsBlocked(this::isSlotBlocked).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.DATA_ORB_OVERLAY)).bindPlayerInventory(entityPlayer.field_71071_by).build(this.getHolder(), entityPlayer);
    }

    private boolean isSlotBlocked() {
        return this.isLocked;
    }

    @Override
    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        MetaTileEntityObjectHolder.clearInventory(itemBuffer, this.heldItems);
    }

    @Override
    public MultiblockAbility<IObjectHolder> getAbility() {
        return MultiblockAbility.OBJECT_HOLDER;
    }

    @Override
    public void registerAbilities(List<IObjectHolder> abilityList) {
        abilityList.add(this);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        SimpleOverlayRenderer renderer = Textures.OBJECT_HOLDER_OVERLAY;
        MultiblockControllerBase controller = this.getController();
        if (controller != null && controller.isActive()) {
            renderer = Textures.OBJECT_HOLDER_ACTIVE_OVERLAY;
        }
        renderer.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
    }

    @Override
    public void setFrontFacing(EnumFacing frontFacing) {
        super.setFrontFacing(frontFacing);
        MultiblockControllerBase controller = this.getController();
        if (controller != null && controller.isStructureFormed()) {
            controller.checkStructurePattern();
        }
    }

    @Override
    @NotNull
    public ItemStack getHeldItem(boolean remove) {
        return this.getHeldItem(0, remove);
    }

    @Override
    public void setHeldItem(@NotNull ItemStack heldItem) {
        this.heldItems.setStackInSlot(0, heldItem);
    }

    @Override
    @NotNull
    public ItemStack getDataItem(boolean remove) {
        return this.getHeldItem(1, remove);
    }

    @Override
    public void setDataItem(@NotNull ItemStack dataItem) {
        this.heldItems.setStackInSlot(1, dataItem);
    }

    @Override
    public void setLocked(boolean locked) {
        if (this.isLocked != locked) {
            this.isLocked = locked;
            this.markDirty();
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                this.writeCustomData(GregtechDataCodes.LOCK_OBJECT_HOLDER, buf -> buf.writeBoolean(this.isLocked));
            }
        }
    }

    @Override
    @NotNull
    public IItemHandler getAsHandler() {
        return this.heldItems;
    }

    @NotNull
    private ItemStack getHeldItem(int slot, boolean remove) {
        ItemStack stackInSlot = this.heldItems.getStackInSlot(slot);
        if (remove && stackInSlot != ItemStack.field_190927_a) {
            this.heldItems.setStackInSlot(slot, ItemStack.field_190927_a);
        }
        return stackInSlot;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("IsLocked", this.isLocked);
        data.func_74782_a("Inventory", (NBTBase)this.heldItems.serializeNBT());
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isLocked = data.func_74767_n("IsLocked");
        this.heldItems.deserializeNBT(data.func_74775_l("Inventory"));
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isLocked);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isLocked = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.LOCK_OBJECT_HOLDER) {
            this.isLocked = buf.readBoolean();
        }
    }

    @Override
    protected boolean shouldSerializeInventories() {
        return false;
    }

    @Override
    public void addToMultiBlock(MultiblockControllerBase controllerBase) {
        super.addToMultiBlock(controllerBase);
        this.heldItems.addNotifiableMetaTileEntity(controllerBase);
        this.heldItems.addToNotifiedList(this, this.heldItems, false);
    }

    @Override
    public void removeFromMultiBlock(MultiblockControllerBase controllerBase) {
        super.removeFromMultiBlock(controllerBase);
        this.heldItems.removeNotifiableMetaTileEntity(controllerBase);
    }

    private class ObjectHolderHandler
    extends NotifiableItemStackHandler {
        public ObjectHolderHandler(MetaTileEntity metaTileEntity) {
            super(metaTileEntity, 2, null, false);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!MetaTileEntityObjectHolder.this.isSlotBlocked()) {
                return super.extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (stack.func_190926_b()) {
                return true;
            }
            boolean isDataItem = false;
            Item item = stack.func_77973_b();
            if (item instanceof MetaItem) {
                MetaItem metaItem = (MetaItem)item;
                for (IItemBehaviour behaviour : metaItem.getBehaviours(stack)) {
                    if (!(behaviour instanceof IDataItem)) continue;
                    isDataItem = true;
                    break;
                }
            }
            if (slot == 0 && !isDataItem) {
                return true;
            }
            return slot == 1 && isDataItem;
        }
    }
}

