/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.ILaserContainer;
import gregtech.api.capability.impl.LaserContainerHandler;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.IDataInfoProvider;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityLaserHatch
extends MetaTileEntityMultiblockPart
implements IMultiblockAbilityPart<ILaserContainer>,
IDataInfoProvider {
    private final boolean isOutput;
    private final int tier;
    private final int amperage;
    private final ILaserContainer buffer;

    public MetaTileEntityLaserHatch(ResourceLocation metaTileEntityId, boolean isOutput, int tier, int amperage) {
        super(metaTileEntityId, tier);
        this.isOutput = isOutput;
        this.tier = tier;
        this.amperage = amperage;
        if (isOutput) {
            this.buffer = LaserContainerHandler.emitterContainer(this, GTValues.V[tier] * 64L * (long)amperage, GTValues.V[tier], amperage);
            ((LaserContainerHandler)this.buffer).setSideOutputCondition(s -> s == this.getFrontFacing());
        } else {
            this.buffer = LaserContainerHandler.receiverContainer(this, GTValues.V[tier] * 64L * (long)amperage, GTValues.V[tier], amperage);
            ((LaserContainerHandler)this.buffer).setSideInputCondition(s -> s == this.getFrontFacing());
        }
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLaserHatch(this.metaTileEntityId, this.isOutput, this.tier, this.amperage);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    public boolean canPartShare() {
        return false;
    }

    @Override
    public MultiblockAbility<ILaserContainer> getAbility() {
        return this.isOutput ? MultiblockAbility.OUTPUT_LASER : MultiblockAbility.INPUT_LASER;
    }

    @Override
    public void registerAbilities(List<ILaserContainer> abilityList) {
        abilityList.add(this.buffer);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            if (this.isOutput) {
                Textures.LASER_SOURCE.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            } else {
                Textures.LASER_TARGET.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            }
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)(this.isOutput ? "gregtech.machine.laser_hatch.source.tooltip1" : "gregtech.machine.laser_hatch.target.tooltip1"), (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.laser_hatch.tooltip2", (Object[])new Object[0]));
        if (this.isOutput) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_out", (Object[])new Object[]{GTValues.V[this.tier], GTValues.VN[this.tier]}));
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.amperage_out_till", (Object[])new Object[]{this.amperage}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{GTValues.V[this.tier], GTValues.VN[this.tier]}));
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.amperage_in_till", (Object[])new Object[]{this.amperage}));
        }
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.buffer.getEnergyCapacity()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.disabled", (Object[])new Object[0]));
    }

    @Override
    @NotNull
    public List<ITextComponent> getDataInfo() {
        return Collections.singletonList(new TextComponentString(String.format("%d/%d EU", this.buffer.getEnergyStored(), this.buffer.getEnergyCapacity())));
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        return super.getCapability(capability, side);
    }
}

