/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IFilter;
import gregtech.api.capability.IFilteredFluidContainer;
import gregtech.api.capability.impl.FilteredItemHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.NotifiableFluidTank;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.gui.widgets.FluidContainerSlotWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.PhantomTankWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockNotifiablePart;
import gregtech.common.metatileentities.storage.MetaTileEntityQuantumTank;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityFluidHatch
extends MetaTileEntityMultiblockNotifiablePart
implements IMultiblockAbilityPart<IFluidTank>,
IControllable {
    private static final int INITIAL_INVENTORY_SIZE = 8000;
    private final HatchFluidTank fluidTank;
    private boolean workingEnabled;
    private boolean locked;
    @Nullable
    private FluidStack lockedFluid;

    public MetaTileEntityFluidHatch(ResourceLocation metaTileEntityId, int tier, boolean isExportHatch) {
        super(metaTileEntityId, tier, isExportHatch);
        this.fluidTank = new HatchFluidTank(this.getInventorySize(), this, isExportHatch);
        this.workingEnabled = true;
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityFluidHatch(this.metaTileEntityId, this.getTier(), this.isExportHatch);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("workingEnabled", this.workingEnabled);
        if (this.isExportHatch) {
            data.func_74757_a("IsLocked", this.locked);
            if (this.locked && this.lockedFluid != null) {
                data.func_74782_a("LockedFluid", (NBTBase)this.lockedFluid.writeToNBT(new NBTTagCompound()));
            }
        }
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("workingEnabled")) {
            this.workingEnabled = data.func_74767_n("workingEnabled");
        }
        if (data.func_74764_b("ContainerInventory")) {
            MetaTileEntityQuantumTank.legacyTankItemHandlerNBTReading(this, data.func_74775_l("ContainerInventory"), 0, 1);
        }
        if (this.isExportHatch) {
            this.locked = data.func_74767_n("IsLocked");
            this.lockedFluid = this.locked ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)data.func_74775_l("LockedFluid")) : null;
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.workingEnabled) {
            this.fillContainerFromInternalTank((IFluidHandler)this.fluidTank);
            if (this.isExportHatch) {
                this.pushFluidsIntoNearbyHandlers(this.getFrontFacing());
            } else {
                this.fillInternalTankFromFluidContainer((IFluidHandler)this.fluidTank);
                this.pullFluidsFromNearbyHandlers(this.getFrontFacing());
            }
        }
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        World world = this.getWorld();
        if (world != null && !world.field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(workingEnabled));
        }
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.workingEnabled);
        if (this.isExportHatch) {
            buf.writeBoolean(this.locked);
        }
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.workingEnabled = buf.readBoolean();
        if (this.isExportHatch) {
            this.locked = buf.readBoolean();
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.workingEnabled = buf.readBoolean();
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            SimpleOverlayRenderer renderer = this.isExportHatch ? Textures.PIPE_OUT_OVERLAY : Textures.PIPE_IN_OVERLAY;
            renderer.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            SimpleOverlayRenderer overlay = this.isExportHatch ? Textures.FLUID_HATCH_OUTPUT_OVERLAY : Textures.FLUID_HATCH_INPUT_OVERLAY;
            overlay.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        }
    }

    private int getInventorySize() {
        return 8000 * (1 << Math.min(9, this.getTier()));
    }

    @Override
    protected FluidTankList createImportFluidHandler() {
        return this.isExportHatch ? new FluidTankList(false, new IFluidTank[0]) : new FluidTankList(false, new IFluidTank[]{this.fluidTank});
    }

    @Override
    protected FluidTankList createExportFluidHandler() {
        return this.isExportHatch ? new FluidTankList(false, new IFluidTank[]{this.fluidTank}) : new FluidTankList(false, new IFluidTank[0]);
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new FilteredItemHandler((MetaTileEntity)this, 1).setFillPredicate(FilteredItemHandler.getCapabilityFilter(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY));
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new GTItemStackHandler((MetaTileEntity)this, 1);
    }

    @Override
    public MultiblockAbility<IFluidTank> getAbility() {
        return this.isExportHatch ? MultiblockAbility.EXPORT_FLUIDS : MultiblockAbility.IMPORT_FLUIDS;
    }

    @Override
    public void registerAbilities(List<IFluidTank> abilityList) {
        abilityList.add((IFluidTank)this.fluidTank);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return this.createTankUI((IFluidTank)this.fluidTank, this.getMetaFullName(), entityPlayer).build(this.getHolder(), entityPlayer);
    }

    public ModularUI.Builder createTankUI(IFluidTank fluidTank, String title, EntityPlayer entityPlayer) {
        TankWidget tankWidget;
        ModularUI.Builder builder = ModularUI.defaultBuilder();
        if (this.isExportHatch) {
            tankWidget = new PhantomTankWidget(fluidTank, 69, 43, 18, 18, () -> this.lockedFluid, f -> {
                if (this.fluidTank.getFluidAmount() != 0) {
                    return;
                }
                if (f == null) {
                    this.setLocked(false);
                    this.lockedFluid = null;
                } else {
                    this.setLocked(true);
                    this.lockedFluid = f.copy();
                    this.lockedFluid.amount = 1;
                }
            }).setAlwaysShowFull(true).setDrawHoveringText(false);
            builder.image(7, 16, 81, 46, GuiTextures.DISPLAY).widget(new SlotWidget((IItemHandler)this.exportItems, 0, 90, 44, true, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.OUT_SLOT_OVERLAY)).widget(new ToggleButtonWidget(7, 64, 18, 18, GuiTextures.BUTTON_LOCK, this::isLocked, this::setLocked).setTooltipText("gregtech.gui.fluid_lock.tooltip", new Object[0]).shouldUseBaseBackground());
        } else {
            tankWidget = new TankWidget(fluidTank, 69, 52, 18, 18).setAlwaysShowFull(true).setDrawHoveringText(false);
            builder.image(7, 16, 81, 55, GuiTextures.DISPLAY).widget(new ImageWidget(91, 36, 14, 15, GuiTextures.TANK_ICON)).widget(new SlotWidget((IItemHandler)this.exportItems, 0, 90, 53, true, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.OUT_SLOT_OVERLAY));
        }
        return builder.label(6, 6, title).label(11, 20, "gregtech.gui.fluid_amount", 0xFFFFFF).widget(new AdvancedTextWidget(11, 30, this.getFluidAmountText(tankWidget), 0xFFFFFF)).widget(new AdvancedTextWidget(11, 40, this.getFluidNameText(tankWidget), 0xFFFFFF)).widget(tankWidget).widget(new FluidContainerSlotWidget(this.importItems, 0, 90, 16, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.IN_SLOT_OVERLAY)).bindPlayerInventory(entityPlayer.field_71071_by);
    }

    private Consumer<List<ITextComponent>> getFluidNameText(TankWidget tankWidget) {
        return list -> {
            TextComponentTranslation translation = tankWidget.getFluidTextComponent();
            if (translation == null) {
                translation = GTUtility.getFluidTranslation(this.lockedFluid);
            }
            if (translation != null) {
                list.add(translation);
            }
        };
    }

    private Consumer<List<ITextComponent>> getFluidAmountText(TankWidget tankWidget) {
        return list -> {
            String fluidAmount = "";
            if (tankWidget.getFormattedFluidAmount().equals("0")) {
                if (this.lockedFluid != null) {
                    fluidAmount = "0";
                }
            } else {
                fluidAmount = tankWidget.getFormattedFluidAmount();
            }
            if (!fluidAmount.isEmpty()) {
                list.add(new TextComponentString(fluidAmount));
            }
        };
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        if (this.isExportHatch) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_hatch.export.tooltip", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_hatch.import.tooltip", (Object[])new Object[0]));
        }
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.getInventorySize()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    private boolean isLocked() {
        return this.locked;
    }

    private void setLocked(boolean locked) {
        if (this.locked == locked) {
            return;
        }
        this.locked = locked;
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
        if (locked && this.fluidTank.getFluid() != null) {
            this.lockedFluid = this.fluidTank.getFluid().copy();
            this.lockedFluid.amount = 1;
            this.fluidTank.onContentsChanged();
            return;
        }
        this.lockedFluid = null;
        this.fluidTank.onContentsChanged();
    }

    private class HatchFluidTank
    extends NotifiableFluidTank
    implements IFilteredFluidContainer,
    IFilter<FluidStack> {
        public HatchFluidTank(int capacity, MetaTileEntity entityToNotify, boolean isExport) {
            super(capacity, entityToNotify, isExport);
        }

        public int fillInternal(FluidStack resource, boolean doFill) {
            int accepted = super.fillInternal(resource, doFill);
            if (!MetaTileEntityFluidHatch.this.isExportHatch) {
                return accepted;
            }
            if (doFill && MetaTileEntityFluidHatch.this.locked && MetaTileEntityFluidHatch.this.lockedFluid == null) {
                MetaTileEntityFluidHatch.this.lockedFluid = resource.copy();
                ((MetaTileEntityFluidHatch)MetaTileEntityFluidHatch.this).lockedFluid.amount = 1;
            }
            return accepted;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return this.test(fluid);
        }

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
        }

        @Override
        @Nullable
        public IFilter<FluidStack> getFilter() {
            return this;
        }

        @Override
        public boolean test(@NotNull FluidStack fluidStack) {
            if (!MetaTileEntityFluidHatch.this.isExportHatch) {
                return true;
            }
            return !MetaTileEntityFluidHatch.this.locked || MetaTileEntityFluidHatch.this.lockedFluid == null || fluidStack.isFluidEqual(MetaTileEntityFluidHatch.this.lockedFluid);
        }

        @Override
        public int getPriority() {
            if (!MetaTileEntityFluidHatch.this.isExportHatch) {
                return IFilter.noPriority();
            }
            return !MetaTileEntityFluidHatch.this.locked || MetaTileEntityFluidHatch.this.lockedFluid == null ? IFilter.noPriority() : IFilter.whitelistPriority(1);
        }
    }
}

