/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric.generator;

import gregtech.api.GTValues;
import gregtech.api.capability.IRotorHolder;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.MultiblockFuelRecipeLogic;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.FuelMultiblockController;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.IProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.common.metatileentities.multi.electric.generator.LargeTurbineWorkableHandler;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityLargeTurbine
extends FuelMultiblockController
implements ITieredMetaTileEntity,
IProgressBarMultiblock {
    public final int tier;
    public final IBlockState casingState;
    public final IBlockState gearboxState;
    public final ICubeRenderer casingRenderer;
    public final boolean hasMufflerHatch;
    public final ICubeRenderer frontOverlay;
    private static final int MIN_DURABILITY_TO_WARN = 10;
    public IFluidHandler exportFluidHandler;

    public MetaTileEntityLargeTurbine(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, int tier, IBlockState casingState, IBlockState gearboxState, ICubeRenderer casingRenderer, boolean hasMufflerHatch, ICubeRenderer frontOverlay) {
        super(metaTileEntityId, recipeMap, tier);
        this.casingState = casingState;
        this.gearboxState = gearboxState;
        this.casingRenderer = casingRenderer;
        this.hasMufflerHatch = hasMufflerHatch;
        this.frontOverlay = frontOverlay;
        this.tier = tier;
        this.recipeMapWorkable = new LargeTurbineWorkableHandler((RecipeMapMultiblockController)this, tier);
        this.recipeMapWorkable.setMaximumOverclockVoltage(GTValues.V[tier]);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLargeTurbine(this.metaTileEntityId, this.recipeMap, this.tier, this.casingState, this.gearboxState, this.casingRenderer, this.hasMufflerHatch, this.frontOverlay);
    }

    public IRotorHolder getRotorHolder() {
        List<IRotorHolder> abilities = this.getAbilities(MultiblockAbility.ROTOR_HOLDER);
        if (abilities.isEmpty()) {
            return null;
        }
        return abilities.get(0);
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.exportFluidHandler = null;
    }

    public boolean isRotorFaceFree() {
        IRotorHolder rotorHolder = this.getRotorHolder();
        if (rotorHolder != null) {
            return this.isStructureFormed() && this.getRotorHolder().isFrontFaceFree();
        }
        return false;
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.exportFluidHandler = new FluidTankList(true, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
        ((LargeTurbineWorkableHandler)this.recipeMapWorkable).updateTanks();
    }

    @Override
    protected long getMaxVoltage() {
        long maxProduction = this.recipeMapWorkable.getMaxVoltage();
        long currentProduction = ((LargeTurbineWorkableHandler)this.recipeMapWorkable).boostProduction((int)maxProduction);
        if (this.isActive() && currentProduction <= maxProduction) {
            return this.recipeMapWorkable.getMaxVoltage();
        }
        return 0L;
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockFuelRecipeLogic recipeLogic = (MultiblockFuelRecipeLogic)this.recipeMapWorkable;
        MultiblockDisplayText.builder(textList, this.isStructureFormed()).setWorkingStatus(recipeLogic.isWorkingEnabled(), recipeLogic.isActive()).addEnergyProductionLine(this.getMaxVoltage(), recipeLogic.getRecipeEUt()).addCustom(tl -> {
            IRotorHolder rotorHolder;
            if (this.isStructureFormed() && (rotorHolder = this.getRotorHolder()).getRotorEfficiency() > 0) {
                TextComponentString efficiencyInfo = TextComponentUtil.stringWithColor(TextFormatting.AQUA, TextFormattingUtil.formatNumbers(rotorHolder.getTotalEfficiency()) + "%");
                tl.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.turbine.efficiency", efficiencyInfo));
            }
        }).addFuelNeededLine(recipeLogic.getRecipeFluidInputInfo(), recipeLogic.getPreviousRecipeDuration()).addWorkingStatusLine();
    }

    @Override
    protected void addWarningText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, this.isStructureFormed(), false).addCustom(tl -> {
            IRotorHolder rotorHolder;
            if (this.isStructureFormed() && (rotorHolder = this.getRotorHolder()).getRotorEfficiency() > 0 && rotorHolder.getRotorDurabilityPercent() <= 10) {
                tl.add(TextComponentUtil.translationWithColor(TextFormatting.YELLOW, "gregtech.multiblock.turbine.rotor_durability_low", new Object[0]));
            }
        }).addLowDynamoTierLine(this.isDynamoTierTooLow()).addMaintenanceProblemLines(this.getMaintenanceProblems());
    }

    @Override
    protected void addErrorText(List<ITextComponent> textList) {
        super.addErrorText(textList);
        if (this.isStructureFormed()) {
            IRotorHolder rotorHolder;
            if (!this.isRotorFaceFree()) {
                textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.RED, "gregtech.multiblock.turbine.obstructed", new Object[0]));
                textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.turbine.obstructed.desc", new Object[0]));
            }
            if ((rotorHolder = this.getRotorHolder()).getRotorEfficiency() <= 0) {
                textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.RED, "gregtech.multiblock.turbine.no_rotor", new Object[0]));
            }
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.base_production_eut", (Object[])new Object[]{GTValues.V[this.tier] * 2L}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.turbine.efficiency_tooltip", (Object[])new Object[]{GTValues.VNF[this.tier]}));
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("CCCC", "CHHC", "CCCC").aisle("CHHC", "RGGR", "CHHC").aisle("CCCC", "CSHC", "CCCC").where('S', this.selfPredicate()).where('G', MetaTileEntityLargeTurbine.states(this.getGearBoxState())).where('C', MetaTileEntityLargeTurbine.states(this.getCasingState())).where('R', MetaTileEntityLargeTurbine.metaTileEntities((MetaTileEntity[])MultiblockAbility.REGISTRY.get(MultiblockAbility.ROTOR_HOLDER).stream().filter(mte -> mte instanceof ITieredMetaTileEntity && ((ITieredMetaTileEntity)((Object)mte)).getTier() >= this.tier).toArray(MetaTileEntity[]::new)).addTooltips("gregtech.multiblock.pattern.clear_amount_3").addTooltip("gregtech.multiblock.pattern.error.limited.1", GTValues.VN[this.tier]).setExactLimit(1).or(MetaTileEntityLargeTurbine.abilities(MultiblockAbility.OUTPUT_ENERGY)).setExactLimit(1)).where('H', MetaTileEntityLargeTurbine.states(this.getCasingState()).or(this.autoAbilities(false, true, false, false, true, true, true))).build();
    }

    @Override
    public String[] getDescription() {
        return new String[]{I18n.func_135052_a((String)"gregtech.multiblock.large_turbine.description", (Object[])new Object[0])};
    }

    public IBlockState getCasingState() {
        return this.casingState;
    }

    public IBlockState getGearBoxState() {
        return this.gearboxState;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return this.casingRenderer;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return this.frontOverlay;
    }

    @Override
    public boolean hasMufflerMechanics() {
        return this.hasMufflerHatch;
    }

    @Override
    public boolean isStructureObstructed() {
        return super.isStructureObstructed() || !this.isRotorFaceFree();
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public boolean canVoidRecipeItemOutputs() {
        return true;
    }

    @Override
    public boolean canVoidRecipeFluidOutputs() {
        return true;
    }

    @Override
    protected boolean shouldShowVoidingModeButton() {
        return false;
    }

    @Override
    public int getNumProgressBars() {
        return 3;
    }

    @Override
    public double getFillPercentage(int index) {
        if (index == 0) {
            MultiblockFuelRecipeLogic recipeLogic;
            int[] fuelAmount = new int[2];
            if (this.getInputFluidInventory() != null && (recipeLogic = (MultiblockFuelRecipeLogic)this.recipeMapWorkable).getInputFluidStack() != null) {
                FluidStack testStack = recipeLogic.getInputFluidStack().copy();
                testStack.amount = Integer.MAX_VALUE;
                fuelAmount = this.getTotalFluidAmount(testStack, this.getInputFluidInventory());
            }
            return fuelAmount[1] != 0 ? 1.0 * (double)fuelAmount[0] / (double)fuelAmount[1] : 0.0;
        }
        if (index == 1) {
            IRotorHolder rotorHolder = this.getRotorHolder();
            return rotorHolder != null ? 1.0 * (double)rotorHolder.getRotorSpeed() / (double)rotorHolder.getMaxRotorHolderSpeed() : 0.0;
        }
        IRotorHolder rotorHolder = this.getRotorHolder();
        return rotorHolder != null ? 1.0 * (double)rotorHolder.getRotorDurabilityPercent() / 100.0 : 0.0;
    }

    @Override
    public TextureArea getProgressBarTexture(int index) {
        if (index == 0) {
            return GuiTextures.PROGRESS_BAR_LCE_FUEL;
        }
        if (index == 1) {
            return GuiTextures.PROGRESS_BAR_TURBINE_ROTOR_SPEED;
        }
        return GuiTextures.PROGRESS_BAR_TURBINE_ROTOR_DURABILITY;
    }

    @Override
    public void addBarHoverText(List<ITextComponent> hoverList, int index) {
        if (index == 0) {
            this.addFuelText(hoverList);
        } else if (index == 1) {
            IRotorHolder rotorHolder = this.getRotorHolder();
            if (rotorHolder == null || rotorHolder.getRotorEfficiency() <= 0) {
                hoverList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.YELLOW, "gregtech.multiblock.turbine.no_rotor", new Object[0]));
            } else {
                int rotorSpeed = rotorHolder.getRotorSpeed();
                int rotorMaxSpeed = rotorHolder.getMaxRotorHolderSpeed();
                TextComponentTranslation rpmTranslated = TextComponentUtil.translationWithColor(this.getRotorSpeedColor(rotorSpeed, rotorMaxSpeed), "gregtech.multiblock.turbine.rotor_rpm_unit_name", new Object[0]);
                TextComponentTranslation rotorInfo = TextComponentUtil.translationWithColor(this.getRotorSpeedColor(rotorSpeed, rotorMaxSpeed), "%s / %s %s", TextFormattingUtil.formatNumbers(rotorSpeed), TextFormattingUtil.formatNumbers(rotorMaxSpeed), rpmTranslated);
                hoverList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.turbine.rotor_speed", rotorInfo));
            }
        } else {
            IRotorHolder rotorHolder = this.getRotorHolder();
            if (rotorHolder == null || rotorHolder.getRotorEfficiency() <= 0) {
                hoverList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.YELLOW, "gregtech.multiblock.turbine.no_rotor", new Object[0]));
            } else {
                int rotorDurability = rotorHolder.getRotorDurabilityPercent();
                TextComponentString rotorInfo = TextComponentUtil.stringWithColor(this.getRotorDurabilityColor(rotorDurability), rotorDurability + "%");
                hoverList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.turbine.rotor_durability", rotorInfo));
            }
        }
    }

    private TextFormatting getRotorDurabilityColor(int durability) {
        if (durability > 40) {
            return TextFormatting.GREEN;
        }
        if (durability > 10) {
            return TextFormatting.YELLOW;
        }
        return TextFormatting.RED;
    }

    private TextFormatting getRotorSpeedColor(int rotorSpeed, int maxRotorSpeed) {
        double speedRatio = 1.0 * (double)rotorSpeed / (double)maxRotorSpeed;
        if (speedRatio < 0.4) {
            return TextFormatting.RED;
        }
        if (speedRatio < 0.8) {
            return TextFormatting.YELLOW;
        }
        return TextFormatting.GREEN;
    }
}

