/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IHPCAComponentHatch;
import gregtech.api.capability.IHPCAComputationProvider;
import gregtech.api.capability.IHPCACoolantProvider;
import gregtech.api.capability.IOpticalComputationProvider;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.SuppliedImageWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.IProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.api.util.RelativeDirection;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockComputerCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.core.sound.GTSoundEvents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityHPCA
extends MultiblockWithDisplayBase
implements IOpticalComputationProvider,
IControllable,
IProgressBarMultiblock {
    private static final double IDLE_TEMPERATURE = 200.0;
    private static final double DAMAGE_TEMPERATURE = 1000.0;
    private IEnergyContainer energyContainer = new EnergyContainerList(new ArrayList<IEnergyContainer>());
    private IFluidHandler coolantHandler;
    private final HPCAGridHandler hpcaHandler;
    private boolean isActive;
    private boolean isWorkingEnabled = true;
    private boolean hasNotEnoughEnergy;
    private double temperature = 200.0;
    private final ProgressWidget.TimedProgressSupplier progressSupplier = new ProgressWidget.TimedProgressSupplier(200, 47, false);

    public MetaTileEntityHPCA(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
        this.hpcaHandler = new HPCAGridHandler(this);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityHPCA(this.metaTileEntityId);
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.energyContainer = new EnergyContainerList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
        this.coolantHandler = new FluidTankList(false, this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        this.hpcaHandler.onStructureForm(this.getAbilities(MultiblockAbility.HPCA_COMPONENT));
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.energyContainer = new EnergyContainerList(new ArrayList<IEnergyContainer>());
        this.hpcaHandler.onStructureInvalidate();
    }

    @Override
    public int requestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return this.isActive() && this.isWorkingEnabled() && !this.hasNotEnoughEnergy ? this.hpcaHandler.allocateCWUt(cwut, simulate) : 0;
    }

    @Override
    public int getMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return this.isActive() && this.isWorkingEnabled() ? this.hpcaHandler.getMaxCWUt() : 0;
    }

    @Override
    public boolean canBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return !this.isStructureFormed() || this.hpcaHandler.hasHPCABridge();
    }

    @Override
    public void update() {
        super.update();
        if (this.getWorld().field_72995_K) {
            if (this.isStructureFormed()) {
                this.hpcaHandler.tryGatherClientComponents(this.getWorld(), this.getPos(), this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
            } else {
                this.hpcaHandler.clearClientComponents();
            }
        }
    }

    @Override
    protected void updateFormedValid() {
        if (this.isWorkingEnabled()) {
            this.consumeEnergy();
        }
        if (this.isActive()) {
            double midpoint = 400.0;
            double temperatureChange = this.hpcaHandler.calculateTemperatureChange(this.coolantHandler, this.temperature >= midpoint) / 2.0;
            this.temperature = this.temperature + temperatureChange <= 200.0 ? 200.0 : (this.temperature += temperatureChange);
            if (this.temperature >= 1000.0) {
                this.hpcaHandler.attemptDamageHPCA();
            }
            this.hpcaHandler.tick();
        } else {
            this.hpcaHandler.clearComputationCache();
            this.temperature = Math.max(200.0, this.temperature - 0.25);
        }
    }

    private void consumeEnergy() {
        boolean hasMaintenance;
        int energyToConsume = this.hpcaHandler.getCurrentEUt();
        boolean bl = hasMaintenance = ConfigHolder.machines.enableMaintenance && this.hasMaintenanceMechanics();
        if (hasMaintenance) {
            energyToConsume += this.getNumMaintenanceProblems() * energyToConsume / 10;
        }
        if (this.hasNotEnoughEnergy && this.energyContainer.getInputPerSec() > 19L * (long)energyToConsume) {
            this.hasNotEnoughEnergy = false;
        }
        if (this.energyContainer.getEnergyStored() >= (long)energyToConsume) {
            if (!this.hasNotEnoughEnergy) {
                long consumed = this.energyContainer.removeEnergy(energyToConsume);
                if (consumed == (long)(-energyToConsume)) {
                    this.setActive(true);
                } else {
                    this.hasNotEnoughEnergy = true;
                    this.setActive(false);
                }
            }
        } else {
            this.hasNotEnoughEnergy = true;
            this.setActive(false);
        }
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("AA", "CC", "CC", "CC", "AA").aisle("VA", "XV", "XV", "XV", "VA").aisle("VA", "XV", "XV", "XV", "VA").aisle("VA", "XV", "XV", "XV", "VA").aisle("SA", "CC", "CC", "CC", "AA").where('S', this.selfPredicate()).where('A', MetaTileEntityHPCA.states(MetaTileEntityHPCA.getAdvancedState())).where('V', MetaTileEntityHPCA.states(MetaTileEntityHPCA.getVentState())).where('X', MetaTileEntityHPCA.abilities(MultiblockAbility.HPCA_COMPONENT)).where('C', MetaTileEntityHPCA.states(MetaTileEntityHPCA.getCasingState()).setMinGlobalLimited(5).or(this.maintenancePredicate()).or(MetaTileEntityHPCA.abilities(MultiblockAbility.INPUT_ENERGY).setMinGlobalLimited(1)).or(MetaTileEntityHPCA.abilities(MultiblockAbility.IMPORT_FLUIDS).setMaxGlobalLimited(1)).or(MetaTileEntityHPCA.abilities(MultiblockAbility.COMPUTATION_DATA_TRANSMISSION).setExactLimit(1))).build();
    }

    @NotNull
    private static IBlockState getCasingState() {
        return MetaBlocks.COMPUTER_CASING.getState(BlockComputerCasing.CasingType.COMPUTER_CASING);
    }

    @NotNull
    private static IBlockState getAdvancedState() {
        return MetaBlocks.COMPUTER_CASING.getState(BlockComputerCasing.CasingType.ADVANCED_COMPUTER_CASING);
    }

    @NotNull
    private static IBlockState getVentState() {
        return MetaBlocks.COMPUTER_CASING.getState(BlockComputerCasing.CasingType.COMPUTER_HEAT_VENT);
    }

    @Override
    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.Builder builder = MultiblockShapeInfo.builder().aisle("AA", "EC", "MC", "HC", "AA").aisle("VA", "6V", "3V", "0V", "VA").aisle("VA", "7V", "4V", "1V", "VA").aisle("VA", "8V", "5V", "2V", "VA").aisle("SA", "CC", "CC", "OC", "AA").where('S', MetaTileEntities.HIGH_PERFORMANCE_COMPUTING_ARRAY, EnumFacing.SOUTH).where('A', MetaTileEntityHPCA.getAdvancedState()).where('V', MetaTileEntityHPCA.getVentState()).where('C', MetaTileEntityHPCA.getCasingState()).where('E', MetaTileEntities.ENERGY_INPUT_HATCH[6], EnumFacing.NORTH).where('H', MetaTileEntities.FLUID_IMPORT_HATCH[1], EnumFacing.NORTH).where('O', MetaTileEntities.COMPUTATION_HATCH_TRANSMITTER, EnumFacing.SOUTH).where('M', () -> ConfigHolder.machines.enableMaintenance ? MetaTileEntities.MAINTENANCE_HATCH : MetaTileEntityHPCA.getCasingState(), EnumFacing.NORTH);
        shapeInfo.add(builder.shallowCopy().where('0', MetaTileEntities.HPCA_EMPTY_COMPONENT, EnumFacing.WEST).where('1', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('2', MetaTileEntities.HPCA_EMPTY_COMPONENT, EnumFacing.WEST).where('3', MetaTileEntities.HPCA_EMPTY_COMPONENT, EnumFacing.WEST).where('4', MetaTileEntities.HPCA_COMPUTATION_COMPONENT, EnumFacing.WEST).where('5', MetaTileEntities.HPCA_EMPTY_COMPONENT, EnumFacing.WEST).where('6', MetaTileEntities.HPCA_EMPTY_COMPONENT, EnumFacing.WEST).where('7', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('8', MetaTileEntities.HPCA_EMPTY_COMPONENT, EnumFacing.WEST).build());
        shapeInfo.add(builder.shallowCopy().where('0', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('1', MetaTileEntities.HPCA_COMPUTATION_COMPONENT, EnumFacing.WEST).where('2', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('3', MetaTileEntities.HPCA_ACTIVE_COOLER_COMPONENT, EnumFacing.WEST).where('4', MetaTileEntities.HPCA_COMPUTATION_COMPONENT, EnumFacing.WEST).where('5', MetaTileEntities.HPCA_BRIDGE_COMPONENT, EnumFacing.WEST).where('6', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('7', MetaTileEntities.HPCA_COMPUTATION_COMPONENT, EnumFacing.WEST).where('8', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).build());
        shapeInfo.add(builder.shallowCopy().where('0', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('1', MetaTileEntities.HPCA_COMPUTATION_COMPONENT, EnumFacing.WEST).where('2', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('3', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('4', MetaTileEntities.HPCA_ADVANCED_COMPUTATION_COMPONENT, EnumFacing.WEST).where('5', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('6', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('7', MetaTileEntities.HPCA_BRIDGE_COMPONENT, EnumFacing.WEST).where('8', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).build());
        shapeInfo.add(builder.shallowCopy().where('0', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('1', MetaTileEntities.HPCA_ADVANCED_COMPUTATION_COMPONENT, EnumFacing.WEST).where('2', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('3', MetaTileEntities.HPCA_ACTIVE_COOLER_COMPONENT, EnumFacing.WEST).where('4', MetaTileEntities.HPCA_BRIDGE_COMPONENT, EnumFacing.WEST).where('5', MetaTileEntities.HPCA_ACTIVE_COOLER_COMPONENT, EnumFacing.WEST).where('6', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).where('7', MetaTileEntities.HPCA_ADVANCED_COMPUTATION_COMPONENT, EnumFacing.WEST).where('8', MetaTileEntities.HPCA_HEAT_SINK_COMPONENT, EnumFacing.WEST).build());
        return shapeInfo;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        if (sourcePart == null) {
            return Textures.ADVANCED_COMPUTER_CASING;
        }
        return Textures.COMPUTER_CASING;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.HPCA_OVERLAY;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), this.isWorkingEnabled());
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.isActive;
    }

    public void setActive(boolean active) {
        if (this.isActive != active) {
            this.isActive = active;
            this.markDirty();
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                this.writeCustomData(GregtechDataCodes.WORKABLE_ACTIVE, buf -> buf.writeBoolean(active));
            }
        }
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        if (this.isWorkingEnabled != isWorkingAllowed) {
            this.isWorkingEnabled = isWorkingAllowed;
            this.markDirty();
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(this.isWorkingEnabled));
            }
        }
    }

    @Override
    protected ModularUI.Builder createUITemplate(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = super.createUITemplate(entityPlayer);
        builder.widget(new ProgressWidget(() -> this.hpcaHandler.getAllocatedCWUt() > 0 ? this.progressSupplier.getAsDouble() : 0.0, 74, 57, 47, 47, GuiTextures.HPCA_COMPONENT_OUTLINE, ProgressWidget.MoveType.HORIZONTAL).setIgnoreColor(true).setHoverTextConsumer(this.hpcaHandler::addInfo));
        int startX = 76;
        int startY = 59;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int index = i * 3 + j;
                Supplier<IGuiTexture> textureSupplier = () -> this.hpcaHandler.getComponentTexture(index);
                builder.widget(new SuppliedImageWidget(startX + 15 * j, startY + 15 * i, 13, 13, textureSupplier).setIgnoreColor(true));
            }
        }
        return builder;
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, this.isStructureFormed()).setWorkingStatus(true, this.hpcaHandler.getAllocatedCWUt() > 0).setWorkingStatusKeys("gregtech.multiblock.idling", "gregtech.multiblock.idling", "gregtech.multiblock.data_bank.providing").addCustom(tl -> {
            if (this.isStructureFormed()) {
                TextComponentString voltageName = new TextComponentString(GTValues.VNF[GTUtility.getTierByVoltage(this.hpcaHandler.getMaxEUt())]);
                tl.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.hpca.energy", TextFormattingUtil.formatNumbers(this.hpcaHandler.cachedEUt), TextFormattingUtil.formatNumbers(this.hpcaHandler.getMaxEUt()), voltageName));
                TextComponentString cwutInfo = TextComponentUtil.stringWithColor(TextFormatting.AQUA, this.hpcaHandler.cachedCWUt + " / " + this.hpcaHandler.getMaxCWUt() + " CWU/t");
                tl.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.hpca.computation", cwutInfo));
            }
        }).addWorkingStatusLine();
    }

    private TextFormatting getDisplayTemperatureColor() {
        if (this.temperature < 500.0) {
            return TextFormatting.GREEN;
        }
        if (this.temperature < 750.0) {
            return TextFormatting.YELLOW;
        }
        return TextFormatting.RED;
    }

    @Override
    protected void addWarningText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, this.isStructureFormed(), false).addLowPowerLine(this.hasNotEnoughEnergy).addCustom(tl -> {
            if (this.isStructureFormed()) {
                if (this.temperature > 500.0) {
                    tl.add(TextComponentUtil.translationWithColor(TextFormatting.YELLOW, "gregtech.multiblock.hpca.warning_temperature", new Object[0]));
                    tl.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.hpca.warning_temperature_active_cool", new Object[0]));
                }
                this.hpcaHandler.addWarnings((List<ITextComponent>)tl);
            }
        }).addMaintenanceProblemLines(this.getMaintenanceProblems());
    }

    @Override
    protected void addErrorText(List<ITextComponent> textList) {
        super.addErrorText(textList);
        if (this.isStructureFormed()) {
            if (this.temperature > 1000.0) {
                textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.RED, "gregtech.multiblock.hpca.error_temperature", new Object[0]));
            }
            this.hpcaHandler.addErrors(textList);
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.high_performance_computing_array.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.high_performance_computing_array.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.high_performance_computing_array.tooltip.3", (Object[])new Object[0]));
    }

    @Override
    protected boolean shouldShowVoidingModeButton() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SoundEvent getSound() {
        return GTSoundEvents.COMPUTATION;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("isActive", this.isActive);
        data.func_74757_a("isWorkingEnabled", this.isWorkingEnabled);
        data.func_74780_a("temperature", this.temperature);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isActive = data.func_74767_n("isActive");
        this.isWorkingEnabled = data.func_74767_n("isWorkingEnabled");
        this.temperature = data.func_74769_h("temperature");
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isActive);
        buf.writeBoolean(this.isWorkingEnabled);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isActive = buf.readBoolean();
        this.isWorkingEnabled = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.isActive = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.isWorkingEnabled = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.CACHED_CWU) {
            this.hpcaHandler.cachedCWUt = buf.readInt();
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public int getNumProgressBars() {
        return 2;
    }

    @Override
    public double getFillPercentage(int index) {
        return index == 0 ? 1.0 * (double)this.hpcaHandler.cachedCWUt / (double)this.hpcaHandler.getMaxCWUt() : Math.min(1.0, this.temperature / 1000.0);
    }

    @Override
    public TextureArea getProgressBarTexture(int index) {
        return index == 0 ? GuiTextures.PROGRESS_BAR_HPCA_COMPUTATION : GuiTextures.PROGRESS_BAR_FUSION_HEAT;
    }

    @Override
    public void addBarHoverText(List<ITextComponent> hoverList, int index) {
        if (index == 0) {
            TextComponentString cwutInfo = TextComponentUtil.stringWithColor(TextFormatting.AQUA, this.hpcaHandler.cachedCWUt + " / " + this.hpcaHandler.getMaxCWUt() + " CWU/t");
            hoverList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.hpca.computation", cwutInfo));
        } else {
            TextComponentString tempInfo = TextComponentUtil.stringWithColor(this.getDisplayTemperatureColor(), Math.round(this.temperature / 10.0) + "\u00b0C");
            hoverList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.hpca.temperature", tempInfo));
        }
    }

    public static class HPCAGridHandler {
        @Nullable
        private final MetaTileEntityHPCA controller;
        private final List<IHPCAComponentHatch> components = new ObjectArrayList();
        private final Set<IHPCACoolantProvider> coolantProviders = new ObjectOpenHashSet();
        private final Set<IHPCAComputationProvider> computationProviders = new ObjectOpenHashSet();
        private int numBridges;
        private int allocatedCWUt;
        private int cachedEUt;
        private int cachedCWUt;

        public HPCAGridHandler(@Nullable MetaTileEntityHPCA controller) {
            this.controller = controller;
        }

        public void onStructureForm(Collection<IHPCAComponentHatch> components) {
            this.reset();
            for (IHPCAComponentHatch component : components) {
                this.components.add(component);
                if (component instanceof IHPCACoolantProvider) {
                    IHPCACoolantProvider coolantProvider = (IHPCACoolantProvider)component;
                    this.coolantProviders.add(coolantProvider);
                }
                if (component instanceof IHPCAComputationProvider) {
                    IHPCAComputationProvider computationProvider = (IHPCAComputationProvider)component;
                    this.computationProviders.add(computationProvider);
                }
                if (!component.isBridge()) continue;
                ++this.numBridges;
            }
        }

        private void onStructureInvalidate() {
            this.reset();
        }

        private void reset() {
            this.clearComputationCache();
            this.components.clear();
            this.coolantProviders.clear();
            this.computationProviders.clear();
            this.numBridges = 0;
        }

        private void clearComputationCache() {
            this.allocatedCWUt = 0;
        }

        public void tick() {
            if (this.cachedCWUt != this.allocatedCWUt) {
                this.cachedCWUt = this.allocatedCWUt;
                if (this.controller != null) {
                    this.controller.writeCustomData(GregtechDataCodes.CACHED_CWU, buf -> buf.writeInt(this.cachedCWUt));
                }
            }
            this.cachedEUt = this.getCurrentEUt();
            if (this.allocatedCWUt != 0) {
                this.allocatedCWUt = 0;
            }
        }

        public double calculateTemperatureChange(IFluidHandler coolantTank, boolean forceCoolWithActive) {
            double temperatureToDecrease;
            int coolantToDrain;
            FluidStack coolantStack;
            int maxCWUt = Math.max(1, this.getMaxCWUt());
            int maxCoolingDemand = this.getMaxCoolingDemand();
            int temperatureIncrease = (int)Math.round(1.0 * (double)maxCoolingDemand * (double)this.allocatedCWUt / (double)maxCWUt);
            int maxPassiveCooling = 0;
            int maxActiveCooling = 0;
            int maxCoolantDrain = 0;
            for (IHPCACoolantProvider coolantProvider : this.coolantProviders) {
                if (coolantProvider.isActiveCooler()) {
                    maxActiveCooling += coolantProvider.getCoolingAmount();
                    maxCoolantDrain += coolantProvider.getMaxCoolantPerTick();
                    continue;
                }
                maxPassiveCooling += coolantProvider.getCoolingAmount();
            }
            double temperatureChange = temperatureIncrease - maxPassiveCooling;
            if (maxActiveCooling == 0 && maxCoolantDrain == 0) {
                return temperatureChange;
            }
            if (forceCoolWithActive || (double)maxActiveCooling <= temperatureChange) {
                FluidStack coolantStack2 = coolantTank.drain(this.getCoolantStack(maxCoolantDrain), true);
                if (coolantStack2 != null) {
                    int coolantDrained = coolantStack2.amount;
                    temperatureChange = coolantDrained == maxCoolantDrain ? (temperatureChange -= (double)maxActiveCooling) : (temperatureChange -= (double)maxActiveCooling * (1.0 * (double)coolantDrained / (double)maxCoolantDrain));
                }
            } else if (temperatureChange > 0.0 && (coolantStack = coolantTank.drain(this.getCoolantStack(coolantToDrain = Math.max(1, (int)((double)maxCoolantDrain * ((temperatureToDecrease = Math.min(temperatureChange, (double)maxActiveCooling)) / (double)maxActiveCooling)))), true)) != null) {
                int coolantDrained = coolantStack.amount;
                if (coolantDrained == coolantToDrain) {
                    return 0.0;
                }
                temperatureChange -= temperatureToDecrease * (1.0 * (double)coolantDrained / (double)coolantToDrain);
            }
            return temperatureChange;
        }

        public FluidStack getCoolantStack(int amount) {
            return new FluidStack(this.getCoolant(), amount);
        }

        private Fluid getCoolant() {
            return Materials.PCBCoolant.getFluid();
        }

        public void attemptDamageHPCA() {
            if (GTValues.RNG.nextInt(200) == 0) {
                ArrayList<IHPCAComponentHatch> candidates = new ArrayList<IHPCAComponentHatch>();
                for (IHPCAComponentHatch component : this.components) {
                    if (!component.canBeDamaged()) continue;
                    candidates.add(component);
                }
                if (!candidates.isEmpty()) {
                    ((IHPCAComponentHatch)candidates.get(GTValues.RNG.nextInt(candidates.size()))).setDamaged(true);
                }
            }
        }

        public int allocateCWUt(int cwut, boolean simulate) {
            int maxCWUt = this.getMaxCWUt();
            int availableCWUt = maxCWUt - this.allocatedCWUt;
            int toAllocate = Math.min(cwut, availableCWUt);
            if (!simulate) {
                this.allocatedCWUt += toAllocate;
            }
            return toAllocate;
        }

        public int getAllocatedCWUt() {
            return this.allocatedCWUt;
        }

        public int getMaxCWUt() {
            int maxCWUt = 0;
            for (IHPCAComputationProvider computationProvider : this.computationProviders) {
                maxCWUt += computationProvider.getCWUPerTick();
            }
            return maxCWUt;
        }

        public int getCurrentEUt() {
            int upkeepEUt;
            int maximumCWUt = Math.max(1, this.getMaxCWUt());
            int maximumEUt = this.getMaxEUt();
            if (maximumEUt == (upkeepEUt = this.getUpkeepEUt())) {
                return maximumEUt;
            }
            return upkeepEUt + (maximumEUt - upkeepEUt) * this.allocatedCWUt / maximumCWUt;
        }

        public int getUpkeepEUt() {
            int upkeepEUt = 0;
            for (IHPCAComponentHatch component : this.components) {
                upkeepEUt += component.getUpkeepEUt();
            }
            return upkeepEUt;
        }

        public int getMaxEUt() {
            int maximumEUt = 0;
            for (IHPCAComponentHatch component : this.components) {
                maximumEUt += component.getMaxEUt();
            }
            return maximumEUt;
        }

        public boolean hasHPCABridge() {
            return this.numBridges > 0;
        }

        public boolean hasActiveCoolers() {
            for (IHPCACoolantProvider coolantProvider : this.coolantProviders) {
                if (!coolantProvider.isActiveCooler()) continue;
                return true;
            }
            return false;
        }

        public int getMaxCoolingAmount() {
            int maxCooling = 0;
            for (IHPCACoolantProvider coolantProvider : this.coolantProviders) {
                maxCooling += coolantProvider.getCoolingAmount();
            }
            return maxCooling;
        }

        public int getMaxCoolingDemand() {
            int maxCooling = 0;
            for (IHPCAComputationProvider computationProvider : this.computationProviders) {
                maxCooling += computationProvider.getCoolingPerTick();
            }
            return maxCooling;
        }

        public int getMaxCoolantDemand() {
            int maxCoolant = 0;
            for (IHPCACoolantProvider coolantProvider : this.coolantProviders) {
                maxCoolant += coolantProvider.getMaxCoolantPerTick();
            }
            return maxCoolant;
        }

        public void addInfo(List<ITextComponent> textList) {
            TextComponentString data = TextComponentUtil.stringWithColor(TextFormatting.AQUA, Integer.toString(this.getMaxCWUt()));
            textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.hpca.info_max_computation", data));
            TextFormatting coolingColor = this.getMaxCoolingAmount() < this.getMaxCoolingDemand() ? TextFormatting.RED : TextFormatting.GREEN;
            data = TextComponentUtil.stringWithColor(coolingColor, Integer.toString(this.getMaxCoolingDemand()));
            textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.hpca.info_max_cooling_demand", data));
            data = TextComponentUtil.stringWithColor(coolingColor, Integer.toString(this.getMaxCoolingAmount()));
            textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.hpca.info_max_cooling_available", data));
            if (this.getMaxCoolantDemand() > 0) {
                data = TextComponentUtil.stringWithColor(TextFormatting.YELLOW, this.getMaxCoolantDemand() + "L ");
                TextComponentTranslation coolantName = TextComponentUtil.translationWithColor(TextFormatting.YELLOW, "gregtech.multiblock.hpca.info_coolant_name", new Object[0]);
                data.func_150257_a((ITextComponent)coolantName);
            } else {
                data = TextComponentUtil.stringWithColor(TextFormatting.GREEN, "0");
            }
            textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.hpca.info_max_coolant_required", data));
            if (this.numBridges > 0) {
                textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GREEN, "gregtech.multiblock.hpca.info_bridging_enabled", new Object[0]));
            } else {
                textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.RED, "gregtech.multiblock.hpca.info_bridging_disabled", new Object[0]));
            }
        }

        public void addWarnings(List<ITextComponent> textList) {
            ArrayList<TextComponentTranslation> warnings = new ArrayList<TextComponentTranslation>();
            if (this.numBridges > 1) {
                warnings.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.hpca.warning_multiple_bridges", new Object[0]));
            }
            if (this.computationProviders.isEmpty()) {
                warnings.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.hpca.warning_no_computation", new Object[0]));
            }
            if (this.getMaxCoolingDemand() > this.getMaxCoolingAmount()) {
                warnings.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.hpca.warning_low_cooling", new Object[0]));
            }
            if (!warnings.isEmpty()) {
                textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.YELLOW, "gregtech.multiblock.hpca.warning_structure_header", new Object[0]));
                textList.addAll(warnings);
            }
        }

        public void addErrors(List<ITextComponent> textList) {
            if (this.components.stream().anyMatch(IHPCAComponentHatch::isDamaged)) {
                textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.RED, "gregtech.multiblock.hpca.error_damaged", new Object[0]));
            }
        }

        public TextureArea getComponentTexture(int index) {
            if (this.components.size() <= index) {
                return GuiTextures.BLANK_TRANSPARENT;
            }
            return this.components.get(index).getComponentIcon();
        }

        public void tryGatherClientComponents(World world, BlockPos pos, EnumFacing frontFacing, EnumFacing upwardsFacing, boolean flip) {
            EnumFacing relativeUp = RelativeDirection.UP.getRelativeFacing(frontFacing, upwardsFacing, flip);
            if (this.components.isEmpty()) {
                BlockPos testPos = pos.func_177967_a(frontFacing.func_176734_d(), 3).func_177967_a(relativeUp, 3);
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        IGregTechTileEntity igtte;
                        MetaTileEntity mte;
                        BlockPos tempPos = testPos.func_177967_a(frontFacing, j).func_177967_a(relativeUp.func_176734_d(), i);
                        TileEntity te = world.func_175625_s(tempPos);
                        if (te instanceof IHPCAComponentHatch) {
                            IHPCAComponentHatch hatch = (IHPCAComponentHatch)te;
                            this.components.add(hatch);
                            continue;
                        }
                        if (!(te instanceof IGregTechTileEntity) || !((mte = (igtte = (IGregTechTileEntity)te).getMetaTileEntity()) instanceof IHPCAComponentHatch)) continue;
                        IHPCAComponentHatch hatch = (IHPCAComponentHatch)((Object)mte);
                        this.components.add(hatch);
                    }
                }
            }
        }

        public void clearClientComponents() {
            this.components.clear();
        }
    }
}

