/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMufflerHatch;
import gregtech.api.capability.IWorkable;
import gregtech.api.capability.impl.CleanroomLogic;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.metatileentity.IDataInfoProvider;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SimpleGeneratorMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.CleanroomType;
import gregtech.api.metatileentity.multiblock.FuelMultiblockController;
import gregtech.api.metatileentity.multiblock.ICleanroomProvider;
import gregtech.api.metatileentity.multiblock.ICleanroomReceiver;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.PatternStringError;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.util.BlockInfo;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextComponentUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockCleanroomCasing;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.common.metatileentities.multi.MetaTileEntityCokeOven;
import gregtech.common.metatileentities.multi.MetaTileEntityPrimitiveBlastFurnace;
import gregtech.common.metatileentities.multi.MetaTileEntityPrimitiveWaterPump;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityFluidDrill;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityLargeMiner;
import gregtech.common.metatileentities.multi.electric.centralmonitor.MetaTileEntityCentralMonitor;
import gregtech.core.sound.GTSoundEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityCleanroom
extends MultiblockWithDisplayBase
implements ICleanroomProvider,
IWorkable,
IDataInfoProvider {
    public static final int CLEAN_AMOUNT_THRESHOLD = 90;
    public static final int MIN_CLEAN_AMOUNT = 0;
    public static final int MIN_RADIUS = 2;
    public static final int MIN_DEPTH = 4;
    private int lDist = 0;
    private int rDist = 0;
    private int bDist = 0;
    private int fDist = 0;
    private int hDist = 0;
    private CleanroomType cleanroomType = null;
    private int cleanAmount;
    private IEnergyContainer energyContainer;
    private final CleanroomLogic cleanroomLogic;
    private final Collection<ICleanroomReceiver> cleanroomReceivers = new HashSet<ICleanroomReceiver>();

    public MetaTileEntityCleanroom(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
        this.cleanroomLogic = new CleanroomLogic(this, 1);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityCleanroom(this.metaTileEntityId);
    }

    protected void initializeAbilities() {
        this.energyContainer = new EnergyContainerList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
    }

    private void resetTileAbilities() {
        this.energyContainer = new EnergyContainerList(new ArrayList<IEnergyContainer>());
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.initializeAbilities();
        Object type = context.get("FilterType");
        if (type instanceof BlockCleanroomCasing.CasingType) {
            BlockCleanroomCasing.CasingType casingType = (BlockCleanroomCasing.CasingType)((Object)type);
            if (casingType.equals((Object)BlockCleanroomCasing.CasingType.FILTER_CASING)) {
                this.cleanroomType = CleanroomType.CLEANROOM;
            } else if (casingType.equals((Object)BlockCleanroomCasing.CasingType.FILTER_CASING_STERILE)) {
                this.cleanroomType = CleanroomType.STERILE_CLEANROOM;
            }
        }
        this.cleanroomLogic.setMaxProgress(Math.max(100, (this.lDist + this.rDist + 1) * (this.bDist + this.fDist + 1) * this.hDist - (this.lDist + this.rDist + 1) * (this.bDist + this.fDist + 1)));
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.resetTileAbilities();
        this.cleanroomLogic.invalidate();
        this.cleanAmount = 0;
        this.cleanroomReceivers.forEach(receiver -> receiver.setCleanroom(null));
        this.cleanroomReceivers.clear();
    }

    @Override
    protected void updateFormedValid() {
        if (!this.getWorld().field_72995_K) {
            this.cleanroomLogic.updateLogic();
            if (this.cleanroomLogic.wasActiveAndNeedsUpdate()) {
                this.cleanroomLogic.setWasActiveAndNeedsUpdate(false);
                this.cleanroomLogic.setActive(false);
            }
        }
    }

    @Override
    public void checkStructurePattern() {
        if (!this.isStructureFormed()) {
            this.reinitializeStructurePattern();
        }
        super.checkStructurePattern();
    }

    @Override
    public boolean allowsExtendedFacing() {
        return false;
    }

    @Override
    public boolean allowsFlip() {
        return false;
    }

    public boolean updateStructureDimensions() {
        int i;
        World world = this.getWorld();
        EnumFacing front = this.getFrontFacing();
        EnumFacing back = front.func_176734_d();
        EnumFacing left = front.func_176735_f();
        EnumFacing right = left.func_176734_d();
        BlockPos.MutableBlockPos lPos = new BlockPos.MutableBlockPos(this.getPos());
        BlockPos.MutableBlockPos rPos = new BlockPos.MutableBlockPos(this.getPos());
        BlockPos.MutableBlockPos fPos = new BlockPos.MutableBlockPos(this.getPos());
        BlockPos.MutableBlockPos bPos = new BlockPos.MutableBlockPos(this.getPos());
        BlockPos.MutableBlockPos hPos = new BlockPos.MutableBlockPos(this.getPos());
        int lDist = 0;
        int rDist = 0;
        int bDist = 0;
        int fDist = 0;
        int hDist = 0;
        for (i = 1; i < 8; ++i) {
            if (lDist == 0 && this.isBlockEdge(world, lPos, left)) {
                lDist = i;
            }
            if (rDist == 0 && this.isBlockEdge(world, rPos, right)) {
                rDist = i;
            }
            if (bDist == 0 && this.isBlockEdge(world, bPos, back)) {
                bDist = i;
            }
            if (fDist == 0 && this.isBlockEdge(world, fPos, front)) {
                fDist = i;
            }
            if (lDist != 0 && rDist != 0 && bDist != 0 && fDist != 0) break;
        }
        for (i = 1; i < 15; ++i) {
            if (this.isBlockFloor(world, hPos, EnumFacing.DOWN)) {
                hDist = i;
            }
            if (hDist != 0) break;
        }
        if (lDist < 2 || rDist < 2 || bDist < 2 || fDist < 2 || hDist < 4) {
            this.invalidateStructure();
            return false;
        }
        this.lDist = lDist;
        this.rDist = rDist;
        this.bDist = bDist;
        this.fDist = fDist;
        this.hDist = hDist;
        this.writeCustomData(GregtechDataCodes.UPDATE_STRUCTURE_SIZE, buf -> {
            buf.writeInt(this.lDist);
            buf.writeInt(this.rDist);
            buf.writeInt(this.bDist);
            buf.writeInt(this.fDist);
            buf.writeInt(this.hDist);
        });
        return true;
    }

    public boolean isBlockEdge(@NotNull World world, @NotNull BlockPos.MutableBlockPos pos, @NotNull EnumFacing direction) {
        return world.func_180495_p((BlockPos)pos.func_189536_c(direction)) == MetaBlocks.CLEANROOM_CASING.getState(BlockCleanroomCasing.CasingType.PLASCRETE);
    }

    public boolean isBlockFloor(@NotNull World world, @NotNull BlockPos.MutableBlockPos pos, @NotNull EnumFacing direction) {
        return this.isBlockEdge(world, pos, direction) || world.func_180495_p((BlockPos)pos) == MetaBlocks.TRANSPARENT_CASING.getState(BlockGlassCasing.CasingType.CLEANROOM_GLASS);
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        int i;
        if (this.getWorld() != null) {
            this.updateStructureDimensions();
        }
        if (this.lDist < 2) {
            this.lDist = 2;
        }
        if (this.rDist < 2) {
            this.rDist = 2;
        }
        if (this.bDist < 2) {
            this.bDist = 2;
        }
        if (this.fDist < 2) {
            this.fDist = 2;
        }
        if (this.hDist < 4) {
            this.hDist = 4;
        }
        if (this.frontFacing == EnumFacing.EAST || this.frontFacing == EnumFacing.WEST) {
            int tmp = this.lDist;
            this.lDist = this.rDist;
            this.rDist = tmp;
        }
        StringBuilder borderBuilder = new StringBuilder();
        StringBuilder wallBuilder = new StringBuilder();
        StringBuilder insideBuilder = new StringBuilder();
        StringBuilder roofBuilder = new StringBuilder();
        StringBuilder controllerBuilder = new StringBuilder();
        StringBuilder centerBuilder = new StringBuilder();
        for (i = 0; i < this.lDist; ++i) {
            borderBuilder.append("B");
            if (i == 0) {
                wallBuilder.append("B");
                insideBuilder.append("X");
                roofBuilder.append("B");
                controllerBuilder.append("B");
                centerBuilder.append("B");
                continue;
            }
            insideBuilder.append(" ");
            wallBuilder.append("X");
            roofBuilder.append("F");
            controllerBuilder.append("F");
            centerBuilder.append("X");
        }
        borderBuilder.append("B");
        wallBuilder.append("X");
        insideBuilder.append(" ");
        roofBuilder.append("F");
        controllerBuilder.append("S");
        centerBuilder.append("K");
        for (i = 0; i < this.rDist; ++i) {
            borderBuilder.append("B");
            if (i == this.rDist - 1) {
                wallBuilder.append("B");
                insideBuilder.append("X");
                roofBuilder.append("B");
                controllerBuilder.append("B");
                centerBuilder.append("B");
                continue;
            }
            insideBuilder.append(" ");
            wallBuilder.append("X");
            roofBuilder.append("F");
            controllerBuilder.append("F");
            centerBuilder.append("X");
        }
        Object[] wall = new String[this.hDist + 1];
        Arrays.fill(wall, wallBuilder.toString());
        wall[0] = borderBuilder.toString();
        wall[wall.length - 1] = borderBuilder.toString();
        Object[] slice = new String[this.hDist + 1];
        Arrays.fill(slice, insideBuilder.toString());
        slice[0] = wallBuilder.toString();
        slice[slice.length - 1] = roofBuilder.toString();
        String[] center = (String[])Arrays.copyOf(slice, slice.length);
        if (this.frontFacing == EnumFacing.NORTH || this.frontFacing == EnumFacing.SOUTH) {
            center[0] = centerBuilder.reverse().toString();
            center[center.length - 1] = controllerBuilder.reverse().toString();
        } else {
            center[0] = centerBuilder.toString();
            center[center.length - 1] = controllerBuilder.toString();
        }
        TraceabilityPredicate wallPredicate = MetaTileEntityCleanroom.states(this.getCasingState(), this.getGlassState());
        TraceabilityPredicate basePredicate = this.autoAbilities().or(MetaTileEntityCleanroom.abilities(MultiblockAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(3));
        return FactoryBlockPattern.start().aisle((String[])wall).aisle((String[])slice).setRepeatable(this.bDist - 1).aisle(center).aisle((String[])slice).setRepeatable(this.fDist - 1).aisle((String[])wall).where('S', this.selfPredicate()).where('B', MetaTileEntityCleanroom.states(this.getCasingState()).or(basePredicate)).where('X', wallPredicate.or(basePredicate).or(MetaTileEntityCleanroom.doorPredicate().setMaxGlobalLimited(8)).or(MetaTileEntityCleanroom.abilities(MultiblockAbility.PASSTHROUGH_HATCH).setMaxGlobalLimited(30))).where('K', wallPredicate).where('F', this.filterPredicate()).where(' ', this.innerPredicate()).build();
    }

    @NotNull
    protected TraceabilityPredicate filterPredicate() {
        return new TraceabilityPredicate(blockWorldState -> {
            IBlockState blockState = blockWorldState.getBlockState();
            Block block = blockState.func_177230_c();
            if (block instanceof BlockCleanroomCasing) {
                BlockCleanroomCasing.CasingType casingType = (BlockCleanroomCasing.CasingType)((Object)((Object)((BlockCleanroomCasing)blockState.func_177230_c()).getState(blockState)));
                if (casingType.equals((Object)BlockCleanroomCasing.CasingType.PLASCRETE)) {
                    return false;
                }
                BlockCleanroomCasing.CasingType currentFilter = blockWorldState.getMatchContext().getOrPut("FilterType", casingType);
                if (!((Object)((Object)currentFilter)).toString().equals(casingType.func_176610_l())) {
                    blockWorldState.setError(new PatternStringError("gregtech.multiblock.pattern.error.filters"));
                    return false;
                }
                blockWorldState.getMatchContext().getOrPut("VABlock", new LinkedList()).add(blockWorldState.getPos());
                return true;
            }
            return false;
        }, () -> (BlockInfo[])ArrayUtils.addAll((Object[])((BlockInfo[])Arrays.stream(BlockCleanroomCasing.CasingType.values()).filter(type -> !type.equals((Object)BlockCleanroomCasing.CasingType.PLASCRETE)).map(type -> new BlockInfo(MetaBlocks.CLEANROOM_CASING.getState(type), null)).toArray(BlockInfo[]::new)), (Object[])new BlockInfo[0])).addTooltips("gregtech.multiblock.pattern.error.filters");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.PLASCRETE;
    }

    @NotNull
    protected IBlockState getCasingState() {
        return MetaBlocks.CLEANROOM_CASING.getState(BlockCleanroomCasing.CasingType.PLASCRETE);
    }

    @NotNull
    protected IBlockState getGlassState() {
        return MetaBlocks.TRANSPARENT_CASING.getState(BlockGlassCasing.CasingType.CLEANROOM_GLASS);
    }

    @NotNull
    protected static TraceabilityPredicate doorPredicate() {
        return new TraceabilityPredicate(blockWorldState -> blockWorldState.getBlockState().func_177230_c() instanceof BlockDoor);
    }

    @NotNull
    protected TraceabilityPredicate innerPredicate() {
        return new TraceabilityPredicate(blockWorldState -> {
            TileEntity tileEntity = blockWorldState.getTileEntity();
            if (!(tileEntity instanceof IGregTechTileEntity)) {
                return true;
            }
            MetaTileEntity metaTileEntity = ((IGregTechTileEntity)tileEntity).getMetaTileEntity();
            if (metaTileEntity instanceof ICleanroomProvider) {
                return false;
            }
            if (this.isMachineBanned(metaTileEntity)) {
                return false;
            }
            if (!(metaTileEntity instanceof ICleanroomReceiver)) {
                return true;
            }
            ICleanroomReceiver cleanroomReceiver = (ICleanroomReceiver)((Object)metaTileEntity);
            if (cleanroomReceiver.getCleanroom() != this) {
                cleanroomReceiver.setCleanroom(this);
                this.cleanroomReceivers.add(cleanroomReceiver);
            }
            return true;
        });
    }

    @Override
    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_MECHANICAL;
    }

    protected boolean isMachineBanned(MetaTileEntity metaTileEntity) {
        if (metaTileEntity instanceof IMufflerHatch) {
            return true;
        }
        if (metaTileEntity instanceof SimpleGeneratorMetaTileEntity) {
            return true;
        }
        if (metaTileEntity instanceof FuelMultiblockController) {
            return true;
        }
        if (metaTileEntity instanceof MetaTileEntityLargeMiner) {
            return true;
        }
        if (metaTileEntity instanceof MetaTileEntityFluidDrill) {
            return true;
        }
        if (metaTileEntity instanceof MetaTileEntityCentralMonitor) {
            return true;
        }
        if (metaTileEntity instanceof MetaTileEntityCleanroom) {
            return true;
        }
        if (metaTileEntity instanceof MetaTileEntityCokeOven) {
            return true;
        }
        if (metaTileEntity instanceof MetaTileEntityPrimitiveBlastFurnace) {
            return true;
        }
        return metaTileEntity instanceof MetaTileEntityPrimitiveWaterPump;
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, this.isStructureFormed()).setWorkingStatus(this.cleanroomLogic.isWorkingEnabled(), this.cleanroomLogic.isActive()).addEnergyUsageLine(this.energyContainer).addCustom(tl -> {
            if (this.isStructureFormed()) {
                TextComponentTranslation cleanState = this.isClean() ? TextComponentUtil.translationWithColor(TextFormatting.GREEN, "gregtech.multiblock.cleanroom.clean_state", this.cleanAmount) : TextComponentUtil.translationWithColor(TextFormatting.DARK_RED, "gregtech.multiblock.cleanroom.dirty_state", this.cleanAmount);
                tl.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.cleanroom.clean_status", cleanState));
            }
        }).addWorkingStatusLine().addProgressLine((double)this.getProgressPercent() / 100.0);
    }

    @Override
    protected void addWarningText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, this.isStructureFormed(), false).addLowPowerLine(!this.drainEnergy(true)).addCustom(tl -> {
            if (this.isStructureFormed() && !this.isClean()) {
                tl.add(TextComponentUtil.translationWithColor(TextFormatting.YELLOW, "gregtech.multiblock.cleanroom.warning_contaminated", new Object[0]));
            }
        }).addMaintenanceProblemLines(this.getMaintenanceProblems());
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.cleanroom.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.cleanroom.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.cleanroom.tooltip.3", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.cleanroom.tooltip.4", (Object[])new Object[0]));
        if (TooltipHelper.isCtrlDown()) {
            tooltip.add("");
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.cleanroom.tooltip.5", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.cleanroom.tooltip.6", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.cleanroom.tooltip.7", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.cleanroom.tooltip.8", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.cleanroom.tooltip.9", (Object[])new Object[0]));
            if (Loader.isModLoaded((String)"appliedenergistics2")) {
                tooltip.add(I18n.func_135052_a((String)(AEConfig.instance().isFeatureEnabled(AEFeature.CHANNELS) ? "gregtech.machine.cleanroom.tooltip.ae2.channels" : "gregtech.machine.cleanroom.tooltip.ae2.no_channels"), (Object[])new Object[0]));
            }
            tooltip.add("");
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.cleanroom.tooltip.hold_ctrl", (Object[])new Object[0]));
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), this.isWorkingEnabled());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.CLEANROOM_OVERLAY;
    }

    @Override
    public boolean checkCleanroomType(@NotNull CleanroomType type) {
        return type == this.cleanroomType;
    }

    @Override
    public void setCleanAmount(int amount) {
        this.cleanAmount = amount;
    }

    @Override
    public void adjustCleanAmount(int amount) {
        this.cleanAmount = MathHelper.func_76125_a((int)(this.cleanAmount + amount), (int)0, (int)100);
    }

    @Override
    public boolean isClean() {
        return this.cleanAmount >= 90;
    }

    @Override
    @NotNull
    public List<ITextComponent> getDataInfo() {
        return Collections.singletonList(new TextComponentTranslation(this.isClean() ? "gregtech.multiblock.cleanroom.clean_state" : "gregtech.multiblock.cleanroom.dirty_state", new Object[0]));
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.cleanroomLogic.isActive();
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.cleanroomLogic.isWorkingEnabled();
    }

    @Override
    public void setWorkingEnabled(boolean isActivationAllowed) {
        if (!isActivationAllowed) {
            this.setCleanAmount(0);
        }
        this.cleanroomLogic.setWorkingEnabled(isActivationAllowed);
    }

    @Override
    public int getProgress() {
        return this.cleanroomLogic.getProgressTime();
    }

    @Override
    public int getMaxProgress() {
        return this.cleanroomLogic.getMaxProgress();
    }

    public int getProgressPercent() {
        return this.cleanroomLogic.getProgressPercent();
    }

    @Override
    public int getEnergyTier() {
        if (this.energyContainer == null) {
            return 1;
        }
        return Math.max(1, GTUtility.getFloorTierByVoltage(this.energyContainer.getInputVoltage()));
    }

    @Override
    public long getEnergyInputPerSecond() {
        return this.energyContainer.getInputPerSec();
    }

    @Override
    public boolean drainEnergy(boolean simulate) {
        long energyToDrain = this.isClean() ? (long)Math.min(4.0, Math.pow(4.0, this.getEnergyTier())) : (long)GTValues.VA[this.getEnergyTier()];
        long resultEnergy = this.energyContainer.getEnergyStored() - energyToDrain;
        if (resultEnergy >= 0L && resultEnergy <= this.energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.changeEnergy(-energyToDrain);
            }
            return true;
        }
        return false;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_WORKABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_WORKABLE.cast((Object)this);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_STRUCTURE_SIZE) {
            this.lDist = buf.readInt();
            this.rDist = buf.readInt();
            this.bDist = buf.readInt();
            this.fDist = buf.readInt();
            this.hDist = buf.readInt();
        } else if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.cleanroomLogic.setActive(buf.readBoolean());
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.cleanroomLogic.setWorkingEnabled(buf.readBoolean());
            this.scheduleRenderUpdate();
        }
    }

    @Override
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("lDist", this.lDist);
        data.func_74768_a("rDist", this.rDist);
        data.func_74768_a("bDist", this.fDist);
        data.func_74768_a("fDist", this.bDist);
        data.func_74768_a("hDist", this.hDist);
        data.func_74768_a("cleanAmount", this.cleanAmount);
        return this.cleanroomLogic.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.lDist = data.func_74764_b("lDist") ? data.func_74762_e("lDist") : this.lDist;
        this.rDist = data.func_74764_b("rDist") ? data.func_74762_e("rDist") : this.rDist;
        this.hDist = data.func_74764_b("hDist") ? data.func_74762_e("hDist") : this.hDist;
        this.bDist = data.func_74764_b("bDist") ? data.func_74762_e("bDist") : this.bDist;
        this.fDist = data.func_74764_b("fDist") ? data.func_74762_e("fDist") : this.fDist;
        this.reinitializeStructurePattern();
        this.cleanAmount = data.func_74762_e("cleanAmount");
        this.cleanroomLogic.readFromNBT(data);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeInt(this.lDist);
        buf.writeInt(this.rDist);
        buf.writeInt(this.bDist);
        buf.writeInt(this.fDist);
        buf.writeInt(this.hDist);
        buf.writeInt(this.cleanAmount);
        this.cleanroomLogic.writeInitialSyncData(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.lDist = buf.readInt();
        this.rDist = buf.readInt();
        this.bDist = buf.readInt();
        this.fDist = buf.readInt();
        this.hDist = buf.readInt();
        this.cleanAmount = buf.readInt();
        this.cleanroomLogic.receiveInitialSyncData(buf);
    }

    @Override
    public void getSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        if (ConfigHolder.machines.enableCleanroom) {
            super.getSubItems(creativeTab, subItems);
        }
    }

    @Override
    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.Builder builder = MultiblockShapeInfo.builder().aisle("XXXXX", "XIHLX", "XXDXX", "XXXXX", "XXXXX").aisle("XXXXX", "X   X", "G   G", "X   X", "XFFFX").aisle("XXXXX", "X   X", "G   G", "X   X", "XFSFX").aisle("XXXXX", "X   X", "G   G", "X   X", "XFFFX").aisle("XMXEX", "XXOXX", "XXRXX", "XXXXX", "XXXXX").where('X', MetaBlocks.CLEANROOM_CASING.getState(BlockCleanroomCasing.CasingType.PLASCRETE)).where('G', MetaBlocks.TRANSPARENT_CASING.getState(BlockGlassCasing.CasingType.CLEANROOM_GLASS)).where('S', MetaTileEntities.CLEANROOM, EnumFacing.SOUTH).where(' ', Blocks.field_150350_a.func_176223_P()).where('E', MetaTileEntities.ENERGY_INPUT_HATCH[1], EnumFacing.SOUTH).where('I', MetaTileEntities.PASSTHROUGH_HATCH_ITEM, EnumFacing.NORTH).where('L', MetaTileEntities.PASSTHROUGH_HATCH_FLUID, EnumFacing.NORTH).where('H', MetaTileEntities.HULL[3], EnumFacing.NORTH).where('D', MetaTileEntities.DIODES[3], EnumFacing.NORTH).where('M', () -> ConfigHolder.machines.enableMaintenance ? MetaTileEntities.MAINTENANCE_HATCH : MetaBlocks.CLEANROOM_CASING.getState(BlockCleanroomCasing.CasingType.PLASCRETE), EnumFacing.SOUTH).where('O', Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER)).where('R', Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER));
        Arrays.stream(BlockCleanroomCasing.CasingType.values()).filter(casingType -> !casingType.equals((Object)BlockCleanroomCasing.CasingType.PLASCRETE)).forEach(casingType -> shapeInfo.add(builder.where('F', MetaBlocks.CLEANROOM_CASING.getState(casingType)).build()));
        return shapeInfo;
    }

    @Override
    protected boolean shouldShowVoidingModeButton() {
        return false;
    }
}

