/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.terminal.gui.widgets.SelectorWidget;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.core.sound.GTSoundEvents;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityAlarm
extends TieredMetaTileEntity {
    private SoundEvent selectedSound = GTSoundEvents.DEFAULT_ALARM;
    private boolean isActive;
    private int radius = 64;
    public static final int BASE_EU_CONSUMPTION = 4;

    public MetaTileEntityAlarm(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, 1);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityAlarm(this.metaTileEntityId);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.uses_per_tick", (Object[])new Object[]{4}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.isActive) {
            Textures.ALARM_OVERLAY_ACTIVE.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        } else {
            Textures.ALARM_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        }
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return ModularUI.builder(GuiTextures.BACKGROUND, 240, 86).widget(new LabelWidget(10, 5, this.getMetaFullName(), new Object[0])).widget(new SelectorWidget(10, 20, 220, 20, this.getSounds().stream().map(event -> event.func_187503_a().toString()).collect(Collectors.toList()), 0x555555, () -> this.selectedSound.func_187503_a().toString(), true).setOnChanged(v -> {
            GregTechAPI.soundManager.stopTileSound(this.getPos());
            SoundEvent newSound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(v));
            if (this.selectedSound != newSound) {
                this.selectedSound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(v));
                this.writeCustomData(GregtechDataCodes.UPDATE_SOUND, writer -> writer.func_192572_a(this.selectedSound.func_187503_a()));
            }
        })).widget(new ImageWidget(10, 54, 220, 20, GuiTextures.DISPLAY)).label(10, 44, "gregtech.gui.alarm.radius").widget(new TextFieldWidget2(12, 60, 216, 16, () -> String.valueOf(this.radius), value -> {
            int newRadius;
            if (!value.isEmpty() && (newRadius = Integer.parseInt(value)) != this.radius) {
                this.writeCustomData(GregtechDataCodes.UPDATE_RADIUS, writer -> writer.writeInt(newRadius));
                this.radius = newRadius;
            }
        }).setMaxLength(10).setNumbersOnly(0, 128)).build(this.getHolder(), entityPlayer);
    }

    protected List<SoundEvent> getSounds() {
        if (GTValues.FOOLS.get().booleanValue() && ConfigHolder.misc.specialEvents) {
            return Arrays.asList(GTSoundEvents.DEFAULT_ALARM, GTSoundEvents.ARC, SoundEvents.field_189111_gN, SoundEvents.field_187530_aT, GTSoundEvents.SUS_RECORD);
        }
        return Arrays.asList(GTSoundEvents.DEFAULT_ALARM, GTSoundEvents.ARC, SoundEvents.field_189111_gN, SoundEvents.field_187530_aT);
    }

    @Override
    public SoundEvent getSound() {
        return this.selectedSound;
    }

    @Override
    public boolean isActive() {
        if (this.getWorld().field_72995_K) {
            return this.isActive;
        }
        return this.isBlockRedstonePowered() && this.energyContainer.changeEnergy(-4L) == -4L;
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.isActive != this.isActive()) {
            this.writeCustomData(GregtechDataCodes.UPDATE_ACTIVE, writer -> writer.writeBoolean(this.isActive()));
            this.isActive = this.isActive();
        }
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_ACTIVE) {
            this.isActive = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.UPDATE_SOUND) {
            this.selectedSound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)buf.func_192575_l());
            GregTechAPI.soundManager.stopTileSound(this.getPos());
        } else if (dataId == GregtechDataCodes.UPDATE_RADIUS) {
            this.radius = buf.readInt();
            GregTechAPI.soundManager.stopTileSound(this.getPos());
        }
    }

    @Override
    public float getVolume() {
        return (float)this.radius / 16.0f;
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isActive = buf.readBoolean();
        this.selectedSound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)buf.func_192575_l());
        this.radius = buf.readInt();
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isActive);
        buf.func_192572_a(this.selectedSound.func_187503_a());
        buf.writeInt(this.radius);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data.func_74757_a("isActive", this.isActive);
        data.func_74778_a("selectedSound", this.selectedSound.func_187503_a().toString());
        data.func_74768_a("radius", this.radius);
        return super.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.isActive = data.func_74767_n("isActive");
        this.selectedSound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(data.func_74779_i("selectedSound")));
        this.radius = data.func_74762_e("radius");
        super.readFromNBT(data);
    }
}

