/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.tool;

import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.items.toolitem.behavior.IToolBehavior;
import gregtech.api.unification.OreDictUnifier;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TorchPlaceBehavior
implements IToolBehavior {
    public static final TorchPlaceBehavior INSTANCE = new TorchPlaceBehavior();

    protected TorchPlaceBehavior() {
    }

    @Override
    @NotNull
    public EnumActionResult onItemUse(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound behaviourTag = ToolHelper.getBehaviorsTag(stack);
        if (behaviourTag.func_74767_n("TorchPlacing")) {
            int i;
            int cachedTorchSlot;
            ItemStack slotStack;
            if (behaviourTag.func_74767_n("TorchPlacing$Slot") && TorchPlaceBehavior.checkAndPlaceTorch(slotStack = (cachedTorchSlot = behaviourTag.func_74762_e("TorchPlacing$Slot")) < 0 ? (ItemStack)player.field_71071_by.field_184439_c.get(0) : (ItemStack)player.field_71071_by.field_70462_a.get(cachedTorchSlot), player, world, pos, hand, facing, hitX, hitY, hitZ)) {
                return EnumActionResult.SUCCESS;
            }
            for (i = 0; i < player.field_71071_by.field_184439_c.size(); ++i) {
                slotStack = (ItemStack)player.field_71071_by.field_184439_c.get(i);
                if (!TorchPlaceBehavior.checkAndPlaceTorch(slotStack, player, world, pos, hand, facing, hitX, hitY, hitZ)) continue;
                behaviourTag.func_74768_a("TorchPlacing$Slot", -(i + 1));
                return EnumActionResult.SUCCESS;
            }
            for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                slotStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (!TorchPlaceBehavior.checkAndPlaceTorch(slotStack, player, world, pos, hand, facing, hitX, hitY, hitZ)) continue;
                behaviourTag.func_74768_a("TorchPlacing$Slot", i);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    private static boolean checkAndPlaceTorch(ItemStack slotStack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemBlock slotItemBlock;
        Block slotBlock;
        Item slotItem;
        if (!slotStack.func_190926_b() && (slotItem = slotStack.func_77973_b()) instanceof ItemBlock && ((slotBlock = (slotItemBlock = (ItemBlock)slotItem).func_179223_d()) == Blocks.field_150478_aa || OreDictUnifier.hasOreDictionary(slotStack, "torch") || OreDictUnifier.hasOreDictionary(slotStack, "blockTorch"))) {
            int i;
            IBlockState slotState;
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (!block.func_176200_f((IBlockAccess)world, pos)) {
                pos = pos.func_177972_a(facing);
            }
            if (player.func_175151_a(pos, facing, slotStack) && world.func_190527_a(slotBlock, pos, false, facing, (Entity)player) && slotItemBlock.placeBlockAt(slotStack, player, world, pos, facing, hitX, hitY, hitZ, slotState = slotBlock.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, i = slotItemBlock.func_77647_b(slotStack.func_77960_j()), (EntityLivingBase)player, hand))) {
                slotState = world.func_180495_p(pos);
                SoundType soundtype = slotState.func_177230_c().getSoundType(slotState, world, pos, (Entity)player);
                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                if (!player.func_184812_l_()) {
                    slotStack.func_190918_g(1);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void addBehaviorNBT(@NotNull ItemStack stack, @NotNull NBTTagCompound tag) {
        tag.func_74757_a("TorchPlacing", true);
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)"item.gt.tool.behavior.torch_place", (Object[])new Object[0]));
    }
}

