/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.tool;

import codechicken.lib.raytracer.RayTracer;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.items.toolitem.behavior.IToolBehavior;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.common.items.tool.rotation.CustomBlockRotations;
import gregtech.common.items.tool.rotation.ICustomRotationBehavior;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockRotatingBehavior
implements IToolBehavior {
    public static final BlockRotatingBehavior INSTANCE = new BlockRotatingBehavior();

    protected BlockRotatingBehavior() {
    }

    @Override
    public EnumActionResult onItemUseFirst(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing side, float hitX, float hitY, float hitZ, @NotNull EnumHand hand) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IGregTechTileEntity) {
            return EnumActionResult.PASS;
        }
        IBlockState state = world.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b instanceof BlockRailBase) {
            return EnumActionResult.FAIL;
        }
        if (!player.func_70093_af() && world.canMineBlockBody(player, pos)) {
            ICustomRotationBehavior behavior = CustomBlockRotations.getCustomRotation(b);
            if (behavior != null) {
                if (behavior.customRotate(state, world, pos, RayTracer.retraceBlock((World)world, (EntityPlayer)player, (BlockPos)pos))) {
                    ToolHelper.onActionDone(player, world, hand);
                    return EnumActionResult.SUCCESS;
                }
            } else if (b.rotateBlock(world, pos, side)) {
                ToolHelper.onActionDone(player, world, hand);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)"item.gt.tool.behavior.block_rotation", (Object[])new Object[0]));
    }
}

