/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors.monitorplugin;

import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.impl.FakeModularGui;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.items.behavior.MonitorPluginBaseBehavior;
import gregtech.api.items.behavior.ProxyHolderPluginBehavior;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.util.GTLog;
import gregtech.api.util.GregFakePlayer;
import gregtech.common.gui.impl.FakeModularUIPluginContainer;
import gregtech.common.gui.widget.monitor.WidgetPluginConfig;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class FakeGuiPluginBehavior
extends ProxyHolderPluginBehavior {
    private int partIndex;
    @SideOnly(value=Side.CLIENT)
    private FakeModularGui fakeModularGui;
    private BlockPos partPos;
    private FakeModularUIPluginContainer fakeModularUIContainer;
    private GregFakePlayer fakePlayer;
    private static final Method methodCreateUI = ObfuscationReflectionHelper.findMethod(MetaTileEntity.class, (String)"createUI", ModularUI.class, (Class[])new Class[]{EntityPlayer.class});

    public void setConfig(int partIndex) {
        if (this.partIndex == partIndex || partIndex < 0) {
            return;
        }
        this.partIndex = partIndex;
        this.partPos = null;
        this.writePluginData(GregtechDataCodes.UPDATE_PLUGIN_CONFIG, buffer -> buffer.func_150787_b(this.partIndex));
        this.markAsDirty();
    }

    public MetaTileEntity getRealMTE() {
        MetaTileEntity target = this.holder.getMetaTileEntity();
        if (target instanceof MultiblockControllerBase) {
            MultiblockControllerBase multi = (MultiblockControllerBase)target;
            if (this.partIndex > 0) {
                if (this.partPos != null) {
                    TileEntity entity = this.screen.getWorld().func_175625_s(this.partPos);
                    if (entity instanceof IGregTechTileEntity) {
                        return ((IGregTechTileEntity)entity).getMetaTileEntity();
                    }
                    this.partPos = null;
                    return null;
                }
                PatternMatchContext context = multi.structurePattern.checkPatternFastAt(target.getWorld(), target.getPos(), target.getFrontFacing().func_176734_d(), multi.getUpwardsFacing(), multi.allowsFlip());
                if (context == null) {
                    return null;
                }
                Set rawPartsSet = context.getOrCreate("MultiblockParts", HashSet::new);
                ArrayList<IMultiblockPart> parts = new ArrayList<IMultiblockPart>(rawPartsSet);
                parts.sort(Comparator.comparing(it -> ((MetaTileEntity)((Object)it)).getPos().hashCode()));
                if (parts.size() > this.partIndex - 1 && parts.get(this.partIndex - 1) instanceof MetaTileEntity) {
                    target = (MetaTileEntity)parts.get(this.partIndex - 1);
                    this.partPos = target.getPos();
                } else {
                    return null;
                }
            }
        }
        return target;
    }

    public void createFakeGui() {
        if (this.holder == null || this.screen == null || !this.screen.isValid()) {
            return;
        }
        try {
            this.fakePlayer = new GregFakePlayer(this.screen.getWorld());
            MetaTileEntity mte = this.getRealMTE();
            if (mte == null || this.partIndex > 0 && this.holder.getMetaTileEntity() == mte) {
                this.fakeModularUIContainer = null;
                if (this.screen.getWorld().field_72995_K) {
                    this.fakeModularGui = null;
                }
                return;
            }
            ModularUI ui = (ModularUI)methodCreateUI.invoke((Object)mte, new Object[]{this.fakePlayer});
            if (ui == null) {
                this.fakeModularUIContainer = null;
                if (this.screen.getWorld().field_72995_K) {
                    this.fakeModularGui = null;
                }
                return;
            }
            ArrayList<Widget> widgets = new ArrayList<Widget>();
            boolean hasPlayerInventory = false;
            for (Widget widget : ui.guiWidgets.values()) {
                IInventory handler;
                if (widget instanceof SlotWidget && ((handler = ((SlotWidget)widget).getHandle().field_75224_c) instanceof PlayerMainInvWrapper || handler instanceof InventoryPlayer)) {
                    hasPlayerInventory = true;
                    continue;
                }
                widgets.add(widget);
            }
            ModularUI.Builder builder = new ModularUI.Builder(ui.backgroundPath, ui.getWidth(), ui.getHeight() - (hasPlayerInventory ? 80 : 0));
            for (Widget widget : widgets) {
                builder.widget(widget);
            }
            ui = builder.build(ui.holder, ui.entityPlayer);
            this.fakeModularUIContainer = new FakeModularUIPluginContainer(ui, this);
            if (this.screen.getWorld().field_72995_K) {
                this.fakeModularGui = new FakeModularGui(ui, this.fakeModularUIContainer);
                this.writePluginAction(GregtechDataCodes.ACTION_PLUGIN_CONFIG, buffer -> {});
            }
        }
        catch (Exception e) {
            GTLog.logger.error((Object)e);
        }
    }

    @Override
    public void readPluginAction(EntityPlayerMP player, int id, PacketBuffer buf) {
        if (id == GregtechDataCodes.ACTION_PLUGIN_CONFIG) {
            this.createFakeGui();
        }
        if (id == GregtechDataCodes.ACTION_FAKE_GUI && this.fakeModularUIContainer != null) {
            this.fakeModularUIContainer.handleClientAction(buf);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("part", this.partIndex);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.partIndex = data.func_74764_b("part") ? data.func_74762_e("part") : 0;
    }

    @Override
    public void onHolderChanged(IGregTechTileEntity lastHolder) {
        if (this.holder == null) {
            if (this.screen.getWorld() != null && this.screen.getWorld().field_72995_K) {
                this.fakeModularGui = null;
            }
            this.fakeModularUIContainer = null;
            this.fakePlayer = null;
        } else if (this.screen.getWorld().field_72995_K) {
            this.createFakeGui();
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.screen.getWorld().field_72995_K) {
            if (this.partIndex > 0 && this.fakeModularUIContainer == null && this.screen.getOffsetTimer() % 20L == 0L) {
                this.createFakeGui();
            }
            if (this.fakeModularGui != null) {
                this.fakeModularGui.updateScreen();
            }
        } else {
            if (this.partIndex > 0 && this.screen.getOffsetTimer() % 20L == 0L && this.fakeModularUIContainer != null && this.getRealMTE() == null) {
                this.writePluginData(GregtechDataCodes.UPDATE_PLUGIN_CONFIG, buf -> buf.func_150787_b(this.partIndex));
                this.fakeModularUIContainer = null;
            }
            if (this.fakeModularUIContainer != null) {
                this.fakeModularUIContainer.detectAndSendChanges();
            }
        }
    }

    @Override
    public MonitorPluginBaseBehavior createPlugin() {
        return new FakeGuiPluginBehavior();
    }

    @Override
    public void renderPlugin(float partialTicks, RayTraceResult rayTraceResult) {
        if (this.fakeModularGui != null) {
            double[] result = this.screen.checkLookingAt(rayTraceResult);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.01);
            if (result == null) {
                this.fakeModularGui.drawScreen(0.0, 0.0, partialTicks);
            } else {
                this.fakeModularGui.drawScreen(result[0], result[1], partialTicks);
            }
        }
    }

    @Override
    public boolean onClickLogic(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, boolean isRight, double x, double y) {
        if (this.screen.getWorld().field_72995_K) {
            return true;
        }
        if (this.fakeModularUIContainer != null && this.fakeModularUIContainer.modularUI != null && !ToolHelper.isTool(playerIn.func_184614_ca(), "screwdriver")) {
            int width = this.fakeModularUIContainer.modularUI.getWidth();
            int height = this.fakeModularUIContainer.modularUI.getHeight();
            float halfW = (float)width / 2.0f;
            float halfH = (float)height / 2.0f;
            float scale = 0.5f / Math.max(halfW, halfH);
            int mouseX = (int)(x / (double)scale + (double)(halfW > halfH ? 0.0f : halfW - halfH));
            int mouseY = (int)(y / (double)scale + (double)(halfH > halfW ? 0.0f : halfH - halfW));
            MetaTileEntity mte = this.getRealMTE();
            if (mte != null && 0 <= mouseX && mouseX <= width && 0 <= mouseY && mouseY <= height) {
                if (playerIn.func_70093_af()) {
                    this.writePluginData(GregtechDataCodes.UPDATE_PLUGIN_CLICK, buf -> {
                        buf.func_150787_b(mouseX);
                        buf.func_150787_b(mouseY);
                        buf.func_150787_b(isRight ? 1 : 0);
                        buf.func_150787_b(this.fakeModularUIContainer.syncId);
                    });
                } else {
                    return isRight && mte.onRightClick(playerIn, hand, facing, null);
                }
            }
        }
        return false;
    }

    @Override
    public void readPluginData(int id, PacketBuffer buf) {
        if (id == GregtechDataCodes.UPDATE_PLUGIN_CONFIG) {
            this.partIndex = buf.func_150792_a();
            this.partPos = null;
            this.createFakeGui();
        } else if (id == GregtechDataCodes.UPDATE_FAKE_GUI) {
            int windowID = buf.func_150792_a();
            int widgetID = buf.func_150792_a();
            if (this.fakeModularGui != null) {
                this.fakeModularGui.handleWidgetUpdate(windowID, widgetID, buf);
            }
        } else if (id == GregtechDataCodes.UPDATE_FAKE_GUI_DETECT) {
            if (this.fakeModularUIContainer != null) {
                this.fakeModularUIContainer.handleSlotUpdate(buf);
            }
        } else if (id == GregtechDataCodes.UPDATE_PLUGIN_CLICK) {
            int mouseX = buf.func_150792_a();
            int mouseY = buf.func_150792_a();
            int button = buf.func_150792_a();
            int syncID = buf.func_150792_a();
            if (this.fakeModularGui != null && this.fakeModularUIContainer != null) {
                this.fakeModularUIContainer.syncId = syncID;
                this.fakeModularGui.mouseClicked(mouseX, mouseY, button);
            }
        }
    }

    @Override
    public WidgetPluginConfig customUI(WidgetPluginConfig widgetGroup, IUIHolder holder, EntityPlayer entityPlayer) {
        return widgetGroup.setSize(170, 50).widget(new LabelWidget(20, 20, "Part:", -1)).widget(new ClickButtonWidget(55, 15, 20, 20, "-1", data -> this.setConfig(this.partIndex - 1))).widget(new ClickButtonWidget(135, 15, 20, 20, "+1", data -> this.setConfig(this.partIndex + 1))).widget(new ImageWidget(75, 15, 60, 20, GuiTextures.DISPLAY)).widget(new SimpleTextWidget(105, 25, "", 0xFFFFFF, () -> Integer.toString(this.partIndex)));
    }

    static {
        methodCreateUI.setAccessible(true);
    }
}

