/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.GTValues;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.metaitem.stats.IItemDurabilityManager;
import gregtech.api.items.metaitem.stats.ISubItemHandler;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GradientUtil;
import java.awt.Color;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LighterBehaviour
implements IItemBehaviour,
IItemDurabilityManager,
ISubItemHandler {
    private static final String LIGHTER_OPEN = "lighterOpen";
    private static final String USES_LEFT = "usesLeft";
    private static final Pair<Color, Color> DURABILITY_BAR_COLORS = GradientUtil.getGradient(15761181, 10);
    private final ResourceLocation overrideLocation;
    private final boolean usesFluid;
    private final boolean hasMultipleUses;
    private final boolean canOpen;
    private Item destroyItem = Items.field_190931_a;
    private int maxUses = 0;

    public LighterBehaviour(boolean usesFluid, boolean hasMultipleUses, boolean canOpen) {
        this(null, usesFluid, hasMultipleUses, canOpen);
    }

    public LighterBehaviour(boolean usesFluid, boolean hasMultipleUses, boolean canOpen, Item destroyItem, int maxUses) {
        this(null, usesFluid, hasMultipleUses, canOpen);
        this.maxUses = maxUses;
        this.destroyItem = destroyItem;
    }

    public LighterBehaviour(@Nullable ResourceLocation overrideLocation, boolean usesFluid, boolean hasMultipleUses, boolean canOpen) {
        this.overrideLocation = overrideLocation;
        this.usesFluid = usesFluid;
        this.hasMultipleUses = hasMultipleUses;
        this.canOpen = canOpen;
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityCreeper) {
            NBTTagCompound compound = GTUtility.getOrCreateNbtCompound(stack);
            if ((!this.canOpen || compound.func_74767_n(LIGHTER_OPEN)) && this.consumeFuel(player, stack)) {
                player.func_130014_f_().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, GTValues.RNG.nextFloat() * 0.4f + 0.8f);
                ((EntityCreeper)entity).func_146079_cb();
                return true;
            }
        }
        return false;
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound compound = GTUtility.getOrCreateNbtCompound(stack);
        if (this.canOpen && player.func_70093_af()) {
            compound.func_74757_a(LIGHTER_OPEN, !compound.func_74767_n(LIGHTER_OPEN));
            stack.func_77982_d(compound);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    @Override
    public EnumActionResult onItemUseFirst(@NotNull EntityPlayer player, @NotNull World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound compound = GTUtility.getOrCreateNbtCompound(stack);
        if (!player.func_175151_a(pos, side, player.func_184586_b(hand))) {
            return EnumActionResult.FAIL;
        }
        if ((!this.canOpen || compound.func_74767_n(LIGHTER_OPEN) && !player.func_70093_af()) && this.consumeFuel(player, stack)) {
            player.func_130014_f_().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, GTValues.RNG.nextFloat() * 0.4f + 0.8f);
            IBlockState blockState = world.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (block instanceof BlockTNT) {
                ((BlockTNT)block).func_180692_a(world, pos, blockState.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)), (EntityLivingBase)player);
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
                return EnumActionResult.SUCCESS;
            }
            BlockPos offset = pos.func_177972_a(side);
            world.func_180501_a(offset, Blocks.field_150480_ab.func_176223_P(), 11);
            if (!world.field_72995_K) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, offset, stack);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Override
    public void addInformation(ItemStack itemStack, @NotNull List<String> lines) {
        lines.add(I18n.func_135052_a((String)(this.usesFluid ? "behaviour.lighter.fluid.tooltip" : "behaviour.lighter.tooltip"), (Object[])new Object[0]));
        if (this.hasMultipleUses && !this.usesFluid) {
            lines.add(I18n.func_135052_a((String)"behaviour.lighter.uses", (Object[])new Object[]{this.getUsesLeft(itemStack)}));
        }
    }

    public boolean consumeFuel(EntityPlayer entity, ItemStack stack) {
        if (entity != null && entity.func_184812_l_()) {
            return true;
        }
        int usesLeft = this.getUsesLeft(stack);
        if (usesLeft - 1 >= 0) {
            this.setUsesLeft(entity, stack, usesLeft - 1);
            return true;
        }
        return false;
    }

    private int getUsesLeft(@NotNull ItemStack stack) {
        if (this.usesFluid) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (fluidHandlerItem == null) {
                return 0;
            }
            FluidStack drained = fluidHandlerItem.drain(Integer.MAX_VALUE, false);
            return drained == null ? 0 : drained.amount;
        }
        if (this.hasMultipleUses) {
            NBTTagCompound compound = GTUtility.getOrCreateNbtCompound(stack);
            if (compound.func_74764_b(USES_LEFT)) {
                return compound.func_74762_e(USES_LEFT);
            }
            compound.func_74768_a(USES_LEFT, this.maxUses);
            stack.func_77982_d(compound);
            return compound.func_74762_e(USES_LEFT);
        }
        return stack.func_190916_E();
    }

    private void setUsesLeft(EntityPlayer entity, @NotNull ItemStack stack, int usesLeft) {
        if (this.usesFluid) {
            FluidStack drained;
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (fluidHandlerItem != null && (drained = fluidHandlerItem.drain(Integer.MAX_VALUE, false)) != null) {
                fluidHandlerItem.drain(drained.amount - usesLeft, true);
            }
        } else if (this.hasMultipleUses) {
            if (usesLeft == 0) {
                stack.func_190920_e(0);
                entity.func_191521_c(new ItemStack(this.destroyItem));
            } else {
                GTUtility.getOrCreateNbtCompound(stack).func_74768_a(USES_LEFT, usesLeft);
            }
        } else {
            stack.func_190920_e(usesLeft);
        }
    }

    @Override
    public void addPropertyOverride(@NotNull Item item) {
        if (this.overrideLocation != null) {
            item.func_185043_a(this.overrideLocation, (stack, world, entity) -> GTUtility.getOrCreateNbtCompound(stack).func_74767_n(LIGHTER_OPEN) ? 1.0f : 0.0f);
        }
    }

    @Override
    public double getDurabilityForDisplay(ItemStack itemStack) {
        if (this.usesFluid) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (fluidHandlerItem == null) {
                return 0.0;
            }
            IFluidTankProperties properties = fluidHandlerItem.getTankProperties()[0];
            FluidStack fluidStack = properties.getContents();
            return fluidStack == null ? 0.0 : (double)fluidStack.amount / (double)properties.getCapacity();
        }
        if (this.hasMultipleUses) {
            return (double)this.getUsesLeft(itemStack) / (double)this.maxUses;
        }
        return 0.0;
    }

    @Override
    @Nullable
    public Pair<Color, Color> getDurabilityColorsForDisplay(ItemStack itemStack) {
        if (this.hasMultipleUses && this.usesFluid) {
            return DURABILITY_BAR_COLORS;
        }
        return null;
    }

    @Override
    public boolean doDamagedStateColors(ItemStack itemStack) {
        return this.hasMultipleUses && !this.usesFluid;
    }

    @Override
    public boolean showEmptyBar(ItemStack itemStack) {
        return this.hasMultipleUses;
    }

    @Override
    public boolean showFullBar(ItemStack itemStack) {
        return this.hasMultipleUses;
    }

    @Override
    public String getItemSubType(ItemStack itemStack) {
        return "";
    }

    @Override
    public void getSubItems(ItemStack itemStack, CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        ItemStack copy;
        IFluidHandlerItem fluidHandlerItem;
        if (this.usesFluid && (fluidHandlerItem = (IFluidHandlerItem)(copy = itemStack.func_77946_l()).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
            fluidHandlerItem.fill(Materials.Butane.getFluid(Integer.MAX_VALUE), true);
            subItems.add((Object)copy);
            return;
        }
        subItems.add((Object)itemStack);
    }
}

